/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import api.player.client.ClientPlayerAPI;
import api.player.client.ClientPlayerBase;
import cpw.mods.fml.common.Loader;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.entities.player.FreefallHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerClient;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class GCPlayerBaseSP
extends ClientPlayerBase {
    boolean lastIsFlying;
    int lastLandingTicks;

    public GCPlayerBaseSP(ClientPlayerAPI playerAPI) {
        super(playerAPI);
    }

    private IPlayerClient getClientHandler() {
        return ClientProxyCore.playerClientHandler;
    }

    public boolean isEntityInsideOpaqueBlock() {
        return this.getClientHandler().isEntityInsideOpaqueBlock(this.player, super.isEntityInsideOpaqueBlock());
    }

    public void onLivingUpdate() {
        this.getClientHandler().onLivingUpdatePre(this.player);
        super.onLivingUpdate();
        this.getClientHandler().onLivingUpdatePost(this.player);
    }

    public void beforeUpdateEntityActionState() {
        if (this.player.field_70170_p.field_73011_w instanceof IZeroGDimension) {
            GCPlayerStatsClient stats = GCPlayerStatsClient.get(this.player);
            if (stats.landingTicks > 0) {
                this.player.field_70139_V = stats.landingYOffset[stats.landingTicks];
                this.player.field_71158_b.field_78902_a *= 0.5f;
                this.player.field_71158_b.field_78900_b *= 0.5f;
                if (this.player.field_71158_b.field_78899_d && this.player.field_70139_V < 0.2f) {
                    this.player.field_70139_V = 0.2f;
                }
            } else if (stats.pjumpticks > 0) {
                this.player.field_70139_V = 0.01f * (float)stats.pjumpticks;
            } else if (!this.player.field_70122_E || stats.inFreefall) {
                this.player.field_70139_V = 0.0f;
            }
        }
    }

    public void afterUpdateEntityActionState() {
        if (this.player.field_70170_p.field_73011_w instanceof IZeroGDimension) {
            this.player.func_70637_d(false);
            if (this.player.field_70121_D.field_72338_b % 1.0 == 0.5) {
                this.player.field_70121_D.field_72338_b += (double)1.0E-5f;
            }
        }
    }

    public void moveEntity(double par1, double par3, double par5) {
        super.moveEntity(par1, par3, par5);
        this.getClientHandler().moveEntity(this.player, par1, par3, par5);
    }

    public void afterMoveEntityWithHeading(float paramFloat1, float paramFloat2) {
        super.afterMoveEntityWithHeading(paramFloat1, paramFloat2);
        if (Loader.isModLoaded((String)"SmartMoving") && !this.player.field_71075_bZ.field_75100_b) {
            this.player.field_70181_x += 0.08;
            this.player.field_70181_x -= WorldUtil.getGravityForEntity((Entity)this.player);
        }
    }

    public void onUpdate() {
        this.getClientHandler().onUpdate(this.player);
        super.onUpdate();
    }

    public boolean isSneaking() {
        if (this.player.field_70170_p.field_73011_w instanceof IZeroGDimension) {
            GCPlayerStatsClient stats = GCPlayerStatsClient.get(this.player);
            if (stats.landingTicks > 0) {
                if (this.lastLandingTicks == 0) {
                    this.lastLandingTicks = stats.landingTicks;
                }
                return stats.landingTicks < this.lastLandingTicks;
            }
            this.lastLandingTicks = 0;
            if (stats.pjumpticks > 0) {
                return true;
            }
            if (ClientProxyCore.sneakRenderOverride && (FreefallHandler.testFreefall((EntityPlayer)this.player) || stats.inFreefall)) {
                return false;
            }
        }
        return super.isSneaking();
    }
}

