/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.gtnewhorizons.gtnhintergalactic.recipe.IGRecipeMaps;
import com.gtnewhorizons.gtnhintergalactic.recipe.ResultNoSpaceProject;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevator.ElevatorUtil;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.MultiblockTooltipBuilder;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;

public class TileEntityModuleResearch
extends TileEntityModuleBase {
    private static final int MODULE_VOLTAGE_TIER = 12;
    protected static final int MODULE_TIER = 1;
    protected static final int MINIMUM_MOTOR_TIER = 2;

    public TileEntityModuleResearch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 12, 1, 2);
    }

    public TileEntityModuleResearch(String aName) {
        super(aName, 12, 1, 2);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.research.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.research.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT2")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
        return tt;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntityModuleResearch(this.mName);
    }

    public RecipeMap<?> getRecipeMap() {
        return IGRecipeMaps.spaceResearchRecipes;
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTValues.V[this.tTier]);
        logic.setAvailableAmperage(1L);
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (this.lastRecipe != recipe) {
                    String neededProject = (String)recipe.getMetadata(IGRecipeMaps.SPACE_PROJECT);
                    String neededLocation = (String)recipe.getMetadata(IGRecipeMaps.SPACE_LOCATION);
                    if (!ElevatorUtil.isProjectAvailable(TileEntityModuleResearch.this.getBaseMetaTileEntity().getOwnerUuid(), neededProject, neededLocation)) {
                        return new ResultNoSpaceProject(neededProject, neededLocation);
                    }
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    public boolean protectsExcessItem() {
        return !this.eSafeVoid;
    }

    public boolean protectsExcessFluid() {
        return !this.eSafeVoid;
    }
}

