/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.gtnhintergalactic.block.IGBlocks;
import com.gtnewhorizons.gtnhintergalactic.client.IGTextures;
import com.gtnewhorizons.gtnhintergalactic.client.TooltipUtil;
import com.gtnewhorizons.gtnhintergalactic.config.IGConfig;
import com.gtnewhorizons.gtnhintergalactic.item.IGItems;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class TileEntityDysonSwarm
extends TTMultiblockBase
implements ISurvivalConstructable {
    private static final Map<Locale, DecimalFormat> DECIMAL_FORMATTERS = new HashMap<Locale, DecimalFormat>();
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<TileEntityDysonSwarm> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "  ttt           ", "  ttt        k  ", "  ttt       k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "  ttt           ", "  tst        k  ", "  ttt       k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "                ", "   s         k  ", "            k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----h-----", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " t g t          ", " tgsgt       k  ", " t g t      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----f-----", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "                ", "   s         k  ", "            k k ", "             k  ", "                "}, {"         ddd    ", "        d---d   ", "       d-----d  ", "      d-------d ", "     d---------d", "     d----f----d", "     d---------d", "      d-------d ", "       d-----d  ", "        d---d   ", "  ttt    ddd    ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "         ddd    ", "        ddddd   ", "       dd---dd  ", "      dd-----dd ", "      dd--f--dd ", "      dd-----dd ", "       dd---dd  ", "        ddddd   ", "         ddd    ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "         ddd    ", "        ddddd   ", "        ddddd   ", "        ddddd   ", "         ddd    ", "                ", "                ", "  ttt           ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "  ttt           ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "  ppp           ", " p   p          ", " p s p      kmk ", " p   p      m m ", "  ppp       kmk ", "                "}, {"                ", "                ", "                ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "                ", "yyyyyyy         ", "yyyyyyy         ", "yypppyy    zzzzz", "yypypyy    zzzzz", "yypppyy    zzjzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz"}, {"                ", "                ", "                ", "        xeeex   ", "        eccce   ", "        eccce   ", "        eccce   ", "        xeeex   ", "                ", "ooooooo         ", "oyyyyyo         ", "oyyyyyo    ziiiz", "oyyyyyo    izzzi", "oyyyyyo    izzzi", "oyyyyyo    izzzi", "ooooooo    ziiiz"}, {"                ", "                ", "                ", "        xx~xx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "                ", "yyyyyyy         ", "yyyyyyy         ", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz"}, {"bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbnbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb"}})).addElement('b', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)9)).addElement('c', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings5, (int)8)).addElement('d', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)1)).addElement('e', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(TTMultiblockBase::addDynamoToMachineList, (int)150, (int)1), StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)0)})).addElement('f', GTStructureUtility.ofFrame((Materials)Materials.HSSS)).addElement('g', GTStructureUtility.ofFrame((Materials)Materials.Titanium)).addElement('h', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings6, (int)10)).addElement('i', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(TTMultiblockBase::addInputToMachineList, (int)152, (int)2), StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)2)})).addElement('j', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)3)).addElement('k', GTStructureUtility.ofFrame((Materials)Materials.Longasssuperconductornameforuhvwire)).addElement('m', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)4)).addElement('n', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(TTMultiblockBase::addClassicMaintenanceToMachineList, (int)153, (int)3), StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)9)})).addElement('o', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(TTMultiblockBase::addDataInputToMachineList, (int)151, (int)4), StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)5)})).addElement('p', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)6)).addElement('s', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)7)).addElement('t', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)8)).addElement('x', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)0)).addElement('y', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)5)).addElement('z', StructureUtility.ofBlock((Block)IGBlocks.DysonSwarmCasing, (int)2)).build();
    private long euPerTick = 0L;
    private double powerFactor = 0.0;
    private int moduleCount = 0;

    public TileEntityDysonSwarm(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected TileEntityDysonSwarm(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntityDysonSwarm(this.mName);
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        this.powerFactor = this.getPowerFactor();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 10, 18, 3, stackSize, hintsOnly);
    }

    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 10, 18, 3, elementBudget, env, true, true);
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 10, 18, 3) && this.mMaintenanceHatches.size() <= 1 && this.mInputBusses.size() > 0 && this.mInputHatches.size() > 0 && this.eInputData.size() > 0 && (this.mDynamoHatches.size() > 0 || this.eDynamoMulti.size() > 0);
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        for (MTEHatchInputBus bus : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputBusses)) {
            for (int i = 0; i < bus.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                ItemStack stack = bus.getBaseMetaTileEntity().func_70301_a(i);
                if (stack == null || stack.func_77973_b() != IGItems.DysonSwarmItems || stack.func_77960_j() != 0 || this.moduleCount >= IGConfig.dysonSwarm.maxModules + 1) continue;
                int usedStackSize = Math.min(stack.field_77994_a, IGConfig.dysonSwarm.maxModules - this.moduleCount);
                this.moduleCount += usedStackSize;
                stack.field_77994_a -= usedStackSize;
            }
        }
        this.euPerTick = (long)((double)((long)this.moduleCount * (long)IGConfig.dysonSwarm.euPerModule) * this.powerFactor);
        if (this.moduleCount > 0 && this.depleteInput(IGConfig.dysonSwarm.getCoolantStack())) {
            this.destroyModules();
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = 72000;
            return true;
        }
        this.mEfficiency = 0;
        return false;
    }

    private void destroyModules() {
        if (IGConfig.dysonSwarm.destroyModuleA <= 0.0) {
            return;
        }
        this.moduleCount = (int)((double)this.moduleCount - (double)this.moduleCount * (2.0 * IGConfig.dysonSwarm.destroyModuleChance) / (Math.exp(-IGConfig.dysonSwarm.destroyModuleA * (double)(this.moduleCount - 1)) + Math.exp(IGConfig.dysonSwarm.destroyModuleB * (double)Math.min(this.eAvailableData, (long)IGConfig.dysonSwarm.destroyModuleMaxCPS))));
        if (this.moduleCount < 0) {
            this.moduleCount = 0;
        }
    }

    public boolean energyFlowOnRunningTick(ItemStack aStack, boolean allowProduction) {
        if (allowProduction && this.euPerTick > 0L) {
            this.addEnergyOutput_EM(this.euPerTick, 1L);
        }
        return true;
    }

    public boolean addEnergyOutput_EM(long EU, long Amperes) {
        return this.addEnergyOutput_EM(EU, Amperes, true);
    }

    public boolean addEnergyOutput_EM(long EU, long Amperes, boolean allowMixedVoltages) {
        long diff;
        if (EU < 0L) {
            EU = -EU;
        }
        if (Amperes < 0L) {
            Amperes = -Amperes;
        }
        long euVar = EU * Amperes;
        for (MTEHatchDynamo tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mDynamoHatches)) {
            if (tHatch.maxEUOutput() < euVar && !allowMixedVoltages) {
                this.explodeMultiblock();
            }
            if ((diff = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU()) <= 0L) continue;
            if (euVar <= diff) {
                tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + euVar);
                return true;
            }
            tHatch.setEUVar(tHatch.maxEUStore());
            euVar -= diff;
        }
        for (MTEHatchDynamo tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.eDynamoMulti)) {
            if (tHatch.maxEUOutput() < euVar && !allowMixedVoltages) {
                this.explodeMultiblock();
            }
            if ((diff = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU()) <= 0L) continue;
            if (euVar <= diff) {
                tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + euVar);
                return true;
            }
            tHatch.setEUVar(tHatch.maxEUStore());
            euVar -= diff;
        }
        this.explodeMultiblock();
        return false;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack heldItem = aPlayer.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() != MetaGeneratedTool01.INSTANCE || heldItem.func_77960_j() != IDMetaTool01.PLUNGER.ID) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer);
        }
        int prevCount = this.moduleCount;
        int maxReduction = (int)Math.min((long)this.moduleCount, MetaGeneratedTool01.getToolMaxDamage((ItemStack)heldItem) - MetaGeneratedTool01.getToolDamage((ItemStack)heldItem));
        ItemStack modules = new ItemStack(IGItems.DysonSwarmItems, maxReduction);
        aPlayer.field_71071_by.func_70441_a(modules);
        if (modules.field_77994_a > 0 && aPlayer.func_70093_af()) {
            aPlayer.field_70170_p.func_72838_d((Entity)new EntityItem(aPlayer.field_70170_p, aPlayer.field_70165_t, aPlayer.field_70163_u + 0.5, aPlayer.field_70161_v, modules));
            this.moduleCount = 0;
            MetaGeneratedTool01.INSTANCE.doDamage(heldItem, (long)maxReduction);
        } else {
            this.moduleCount = prevCount - maxReduction + modules.field_77994_a;
            MetaGeneratedTool01.INSTANCE.doDamage(heldItem, (long)(maxReduction - modules.field_77994_a));
        }
        return true;
    }

    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150), TextureFactory.of((ITexture[])new ITexture[]{IGTextures.DYSON_OVERLAY_FRONT_ACTIVE}), TextureFactory.builder().addIcon(new IIconContainer[]{IGTextures.DYSON_OVERLAY_FRONT_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150), TextureFactory.of((ITexture[])new ITexture[]{IGTextures.DYSON_OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{IGTextures.DYSON_OVERLAY_FRONT_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150)};
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.dyson.type"));
        if (TooltipUtil.dysonLoreText != null) {
            tt.addInfo(EnumChatFormatting.ITALIC + TooltipUtil.dysonLoreText);
        }
        tt.addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.dyson.desc1")).addInfo(StatCollector.func_74837_a((String)"gt.blockmachines.multimachine.ig.dyson.desc2", (Object[])new Object[]{TileEntityDysonSwarm.getDecimalFormat().format(IGConfig.dysonSwarm.euPerModule)})).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.dyson.desc3")).addInfo(StatCollector.func_74837_a((String)"gt.blockmachines.multimachine.ig.dyson.desc4", (Object[])new Object[]{TileEntityDysonSwarm.getDecimalFormat().format(IGConfig.dysonSwarm.destroyModuleChance), TileEntityDysonSwarm.getDecimalFormat().format(IGConfig.dysonSwarm.destroyModuleA), IGConfig.dysonSwarm.destroyModuleB})).addInfo(StatCollector.func_74837_a((String)"gt.blockmachines.multimachine.ig.dyson.desc5", (Object[])new Object[]{TileEntityDysonSwarm.getDecimalFormat().format(IGConfig.dysonSwarm.coolantConsumption), IGConfig.dysonSwarm.getCoolantStack().getLocalizedName()})).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.dyson.desc6")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.dyson.desc7")).addTecTechHatchInfo().beginStructureBlock(16, 20, 16, false).addDynamoHatch(StatCollector.func_74838_a((String)"ig.dyson.structure.dynamo"), new int[]{1}).addInputBus("1 - 11", new int[]{2}).addInputHatch("1 - 11", new int[]{2}).addOtherStructurePart(StatCollector.func_74838_a((String)"ig.dyson.structure.optical"), "1 - 24", new int[]{4}).addStructureInfo("").addStructureInfo(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"ig.dyson.structure.additionally")).addCasingInfoRange(StatCollector.func_74838_a((String)"ig.dyson.structure.receiver.base"), 53, 64, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.receiver.dish"), 81, false).addCasingInfoRange(StatCollector.func_74838_a((String)"ig.dyson.structure.deployment.base"), 62, 72, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.deployment.core"), 1, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.deployment.magnet"), 32, false).addCasingInfoRange(StatCollector.func_74838_a((String)"ig.dyson.structure.control.base"), 115, 138, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.control.primary"), 20, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.control.secondary"), 12, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.control.toroid"), 128, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.base.floor"), 256, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.base.coil"), 9, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.base.hermetic"), 1, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.base.frameTitanium"), 16, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.base.frameHSSS"), 23, false).addCasingInfoExactly(StatCollector.func_74838_a((String)"ig.dyson.structure.base.frameUHVBase"), 64, false).toolTipFinisher(new String[0]);
        return tt;
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Modules: " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)this.moduleCount) + EnumChatFormatting.RESET, "Power Factor: " + (this.powerFactor < 1.0 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + GTUtility.formatNumbers((double)(this.powerFactor * 100.0)) + "%" + EnumChatFormatting.RESET, "Theoretical Output: " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((double)((double)((long)this.moduleCount * (long)IGConfig.dysonSwarm.euPerModule) * this.powerFactor)) + EnumChatFormatting.RESET + " EU/t", "Current Output: " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)this.euPerTick) + EnumChatFormatting.RESET + " EU/t", "Computation required: " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)this.eRequiredData) + EnumChatFormatting.RESET + "/t", "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    public double getPowerFactor() {
        double d;
        String className;
        WorldProvider provider = this.getBaseMetaTileEntity().getWorld().field_73011_w;
        if (provider instanceof IOrbitDimension) {
            IOrbitDimension orbitDimension = (IOrbitDimension)provider;
            return IGConfig.dysonSwarm.getPowerFactor(orbitDimension.getPlanetToOrbit());
        }
        switch (className = provider.getClass().getName()) {
            case "me.eigenraven.personalspace.world.PersonalWorldProvider": {
                d = IGConfig.dysonSwarm.getPowerFactor("PS");
                break;
            }
            default: {
                d = IGConfig.dysonSwarm.getPowerFactor(String.valueOf(provider.field_76574_g));
            }
        }
        return d;
    }

    private static DecimalFormat getDecimalFormat() {
        return DECIMAL_FORMATTERS.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> {
            DecimalFormat format = new DecimalFormat();
            format.setGroupingUsed(true);
            format.setMaximumFractionDigits(5);
            format.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormatSymbols dfs = format.getDecimalFormatSymbols();
            dfs.setGroupingSeparator(',');
            format.setDecimalFormatSymbols(dfs);
            return format;
        });
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.moduleCount = aNBT.func_74762_e("moduleCount");
        this.euPerTick = aNBT.func_74763_f("euPerTick");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("moduleCount", this.moduleCount);
        aNBT.func_74772_a("euPerTick", this.euPerTick);
    }
}

