/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.gregtech;

import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.integration.gregtech.GTConstructableScan;
import blockrenderer6343.integration.gregtech.GTGuiMultiblockHandler;
import blockrenderer6343.integration.nei.MultiblockHandler;
import blockrenderer6343.integration.nei.StructureHacks;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.util.GTStructureUtility;
import gregtech.common.blocks.ItemMachines;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GTNEIMultiblockHandler
extends MultiblockHandler {
    public static final List<IConstructable> multiblocksList = new ArrayList<IConstructable>();
    private static Long2ObjectMap<ObjectSet<IConstructable>> multiBlockComponents;
    private static final GTGuiMultiblockHandler baseHandler;

    public GTNEIMultiblockHandler() {
        super(baseHandler);
    }

    public TemplateRecipeHandler newInstance() {
        return new GTNEIMultiblockHandler();
    }

    @Override
    @NotNull
    public ItemStack getConstructableStack(IConstructable multiblock) {
        return ((IMetaTileEntity)multiblock).getStackForm(1L);
    }

    @Override
    @NotNull
    protected ObjectSet<IConstructable> tryLoadingMultiblocks(ItemStack candidate) {
        if (candidate.func_77973_b() instanceof ItemMachines) {
            for (IConstructable multiblock : multiblocksList) {
                ItemStack stackForm = ((IMetaTileEntity)multiblock).getStackForm(1L);
                if (!NEIClientUtils.areStacksSameType((ItemStack)stackForm, (ItemStack)candidate)) continue;
                return ObjectSets.singleton((Object)multiblock);
            }
        }
        if (multiBlockComponents == null) {
            return ObjectSets.emptySet();
        }
        return (ObjectSet)multiBlockComponents.getOrDefault(BRUtil.hashStack(candidate), (Object)ObjectSets.emptySet());
    }

    static {
        baseHandler = new GTGuiMultiblockHandler();
        StructureHacks.addTieredElement(GTStructureUtility.ofCoil((a, c) -> true, b -> HeatingCoilLevel.LV).getClass().getName());
        for (IMetaTileEntity mte : GregTechAPI.METATILEENTITIES) {
            if (!(mte instanceof IConstructable)) continue;
            IConstructable constructable = (IConstructable)mte;
            multiblocksList.add(constructable);
        }
        new Thread(new GTConstructableScan(e -> {
            multiBlockComponents = e;
        }, multiblocksList)).start();
    }
}

