/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.conduit.geom.CollidableComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class RaytraceResult {
    public final CollidableComponent component;
    public final MovingObjectPosition movingObjectPosition;

    public static RaytraceResult getClosestHit(Vec3 origin, Collection<RaytraceResult> candidates) {
        double minLengthSquared = Double.POSITIVE_INFINITY;
        RaytraceResult closest = null;
        for (RaytraceResult candidate : candidates) {
            double lengthSquared;
            MovingObjectPosition hit = candidate.movingObjectPosition;
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            closest = candidate;
        }
        return closest;
    }

    public static void sort(final Vec3 origin, List<RaytraceResult> toSort) {
        if (origin == null || toSort == null) {
            return;
        }
        Collections.sort(toSort, new Comparator<RaytraceResult>(){

            @Override
            public int compare(RaytraceResult o1, RaytraceResult o2) {
                return Double.compare(o1.getDistanceTo(origin), o2.getDistanceTo(origin));
            }
        });
    }

    public RaytraceResult(CollidableComponent component, MovingObjectPosition movingObjectPosition) {
        this.component = component;
        this.movingObjectPosition = movingObjectPosition;
    }

    public double getDistanceTo(Vec3 origin) {
        if (this.movingObjectPosition == null || origin == null) {
            return Double.MAX_VALUE;
        }
        return this.movingObjectPosition.field_72307_f.func_72436_e(origin);
    }
}

