/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.TextField;
import codechicken.nei.recipe.StackInfo;
import net.minecraft.item.ItemStack;

public class ItemQuantityField
extends TextField {
    public ItemQuantityField(String ident) {
        super(ident);
        this.centered = true;
        this.field.func_146204_h(-13619152);
    }

    public int intValue() {
        return this.intValue(this.text());
    }

    public int intValue(String s) {
        try {
            return Math.max(0, Integer.parseInt(s));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static ItemStack prepareStackWithQuantity(ItemStack stack, long amount) {
        if (stack == null) {
            return null;
        }
        if (amount == 0L) {
            long l = amount = NEIClientConfig.showItemQuantityWidget() ? (long)NEIClientConfig.getItemQuantity() : 0L;
            if (amount == 0L) {
                amount = StackInfo.itemStackToNBT(stack).func_74764_b("gtFluidName") ? 144L : (long)stack.func_77976_d();
            }
        }
        return StackInfo.withAmount(stack, amount);
    }

    @Override
    public void gainFocus() {
        if (this.text().equals("0")) {
            this.setText("");
        }
    }

    @Override
    public void loseFocus() {
        this.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
    }

    @Override
    public void onTextChange(String oldText) {
        NEIClientUtils.setItemQuantity(this.intValue());
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (!this.focused() && this.intValue() == 0) {
            this.field.func_146180_a(NEIClientUtils.translate("itempanel.quantity.default", new Object[0]));
            this.field.func_146196_d();
            this.field.func_146184_c(false);
            super.draw(mousex, mousey);
            this.field.func_146184_c(true);
            this.field.func_146180_a("0");
        } else {
            super.draw(mousex, mousey);
        }
    }

    @Override
    public boolean onMouseWheel(int i, int mx, int my) {
        if (!this.contains(mx, my)) {
            return false;
        }
        int multiplier = 1;
        if (NEIClientUtils.shiftKey()) {
            multiplier = 10;
        } else if (NEIClientUtils.controlKey()) {
            multiplier = 64;
        }
        int quantity = this.intValue() + i * multiplier;
        this.setText(Integer.toString(quantity));
        return true;
    }
}

