/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.Button;
import codechicken.nei.CollapsibleItems;
import codechicken.nei.ItemHistoryPanel;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemsGrid;
import codechicken.nei.ItemsPanelGrid;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PanelWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ItemPanel
extends PanelWidget<ItemsPanelGrid> {
    @Deprecated
    private int itemsPerPage = 0;
    @Deprecated
    public static ArrayList<ItemStack> items = new ArrayList();
    @Deprecated
    public ArrayList<ItemStack> realItems = new ArrayList();
    public ItemHistoryPanel historyPanel = new ItemHistoryPanel();
    public Button toggleGroups;

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        return super.getStackMouseOver(mousex, mousey);
    }

    public ItemPanel() {
        this.grid = new ItemsPanelGrid();
    }

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        ((ItemsPanelGrid)ItemPanels.itemPanel.getGrid()).setItems(newItems);
        ItemPanels.itemPanel.realItems = newItems;
    }

    @Override
    public void init() {
        super.init();
        this.toggleGroups = new Button("G"){

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("itempanel.collapsed.button.tip", new Object[0]);
            }

            @Override
            public boolean onButtonPress(boolean rightclick) {
                CollapsibleItems.toggleGroups(rightclick ? Boolean.valueOf(false) : null);
                ItemList.updateFilter.restart();
                return true;
            }
        };
    }

    @Override
    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        return ItemPanelSlot.of((ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey));
    }

    @Override
    public String getLabelText() {
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    @Override
    protected String getPositioningSettingName() {
        return "world.panels.items";
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return (gui.field_146294_l + gui.field_146999_f) / 2 + 2;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2 - 4;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 2;
    }

    @Override
    protected int resizeHeader(GuiContainer gui) {
        int marginTop = super.resizeHeader(gui);
        this.toggleGroups.w = this.pageNext.w;
        this.toggleGroups.h = this.pageNext.h;
        this.toggleGroups.y = this.pageNext.y;
        this.toggleGroups.x = this.pageNext.x - this.toggleGroups.w - 2;
        return marginTop;
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        if (!NEIClientConfig.showItemQuantityWidget() && NEIClientConfig.isSearchWidgetCentered() && !NEIClientConfig.showHistoryPanelWidget()) {
            return 0;
        }
        if (NEIClientConfig.showHistoryPanelWidget()) {
            this.historyPanel.x = this.x;
            this.historyPanel.w = this.w;
            this.historyPanel.h = 8 + ItemsGrid.SLOT_SIZE * NEIClientConfig.getIntSetting("inventory.history.useRows");
            if (NEIClientConfig.showItemQuantityWidget() || !NEIClientConfig.isSearchWidgetCentered()) {
                this.historyPanel.y = LayoutManager.quantity.y - this.historyPanel.h - 2;
                return LayoutManager.quantity.h + this.historyPanel.h + 4;
            }
            this.historyPanel.y = this.y + this.h - this.historyPanel.h;
            return this.historyPanel.h + 2;
        }
        return LayoutManager.quantity.h + 2;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (((ItemsPanelGrid)this.grid).getPerPage() > 0) {
            if (!CollapsibleItems.isEmpty() && !((ItemsPanelGrid)this.grid).isEmpty()) {
                LayoutManager.addWidget(this.toggleGroups);
            }
            if (!(!NEIClientConfig.showHistoryPanelWidget() || ((ItemsPanelGrid)this.grid).isEmpty() && this.historyPanel.isEmpty())) {
                LayoutManager.addWidget(this.historyPanel);
            }
        }
    }

    @Override
    public void resize(GuiContainer gui) {
        super.resize(gui);
        this.historyPanel.resize(gui);
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(ItemStack itemStack) {
        return ItemQuantityField.prepareStackWithQuantity(itemStack, 0L);
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        ItemsPanelGrid.ItemsPanelGridSlot hoverSlot;
        if (!(((ItemsPanelGrid)this.grid).forceExpand || currenttip.isEmpty() || (hoverSlot = (ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey)) == null || hoverSlot.groupIndex < 0 || !NEIClientConfig.getBooleanSetting("inventory.collapsibleItems.customName") || hoverSlot.extended || "".equals(hoverSlot.displayName))) {
            currenttip.clear();
            currenttip.add(hoverSlot.displayName + "\u00a7h");
        }
        return super.handleItemTooltip(gui, itemstack, mousex, mousey, currenttip);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        ItemsPanelGrid.ItemsPanelGridSlot hoverSlot;
        if (button == 0 && !((ItemsPanelGrid)this.grid).forceExpand && NEIClientUtils.altKey() && (hoverSlot = (ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey)) != null && hoverSlot.groupIndex >= 0) {
            CollapsibleItems.setExpanded(hoverSlot.groupIndex, !hoverSlot.extended);
            ((ItemsPanelGrid)this.grid).setItems(((ItemsPanelGrid)this.grid).rawItems);
            NEIClientUtils.playClickSound();
            return true;
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        ItemsPanelGrid.ItemsPanelGridSlot hoverSlot = (ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey);
        if (!((ItemsPanelGrid)this.grid).forceExpand && hoverSlot != null && hoverSlot.groupIndex >= 0 && hoverSlot.groupSize > 1) {
            String message = hoverSlot.extended ? "itempanel.collapsed.hint.collapse" : "itempanel.collapsed.hint.expand";
            hotkeys.put(NEIClientUtils.getKeyName(0x8000000, 0), NEIClientUtils.translate(message, hoverSlot.groupSize));
        }
        return hotkeys;
    }

    @Deprecated
    public static class ItemPanelSlot
    extends ItemsPanelGrid.ItemsPanelGridSlot {
        @Deprecated
        public ItemPanelSlot(int idx, ItemStack item) {
            this(idx, 0, item);
        }

        @Deprecated
        public ItemPanelSlot(int idx) {
            this(idx, 0, ((ItemsPanelGrid)ItemPanels.itemPanel.getGrid()).getItem(idx));
        }

        private ItemPanelSlot(int slotIndex, int itemIndex, ItemStack item) {
            super(slotIndex, itemIndex, item);
        }

        protected static ItemPanelSlot of(ItemsPanelGrid.ItemsPanelGridSlot slot) {
            if (slot != null) {
                ItemPanelSlot customSlot = new ItemPanelSlot(slot.slotIndex, slot.itemIndex, slot.item);
                customSlot.groupIndex = slot.groupIndex;
                customSlot.displayName = slot.displayName;
                customSlot.bgItemStack = slot.bgItemStack;
                customSlot.groupSize = slot.groupSize;
                customSlot.extended = slot.extended;
                customSlot.bgColor = slot.bgColor;
                return customSlot;
            }
            return null;
        }
    }
}

