/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class FormattedTextField
extends GuiTextField {
    protected FontRenderer fontRenderer;
    protected String rawText = "";
    protected String formattedText = "";
    protected boolean editable = true;
    protected int editableColor = 0xE0E0E0;
    protected int notEditableColor = 0x707070;
    protected TextFormatter formatter = TextFormatter.DEFAULT;
    protected int field_146225_q = 0;
    protected int frame = 0;

    public FormattedTextField(FontRenderer fontRenderer, int xPosition, int yPosition, int width, int height) {
        super(fontRenderer, xPosition, yPosition, width, height);
        this.fontRenderer = fontRenderer;
    }

    public void setFormatter(TextFormatter formatter) {
        this.formatter = formatter;
    }

    public void func_146178_a() {
        super.func_146178_a();
        ++this.frame;
    }

    public void func_146195_b(boolean focus) {
        if (focus && !this.func_146206_l()) {
            this.frame = 0;
        }
        super.func_146195_b(focus);
    }

    public void func_146199_i(int p_146199_1_) {
        String text = this.func_146179_b();
        int j = text.length();
        super.func_146199_i(p_146199_1_);
        p_146199_1_ = Math.max(0, Math.min(p_146199_1_, j));
        if (this.fontRenderer != null) {
            if (this.field_146225_q > j) {
                this.field_146225_q = j;
            }
            int k = this.func_146200_o();
            String s = this.fontRenderer.func_78269_a(text.substring(this.field_146225_q), k);
            int l = s.length() + this.field_146225_q;
            if (p_146199_1_ == this.field_146225_q) {
                this.field_146225_q -= this.fontRenderer.func_78262_a(text, k, true).length();
            }
            if (p_146199_1_ > l) {
                this.field_146225_q += p_146199_1_ - l;
            } else if (p_146199_1_ <= this.field_146225_q) {
                this.field_146225_q -= this.field_146225_q - p_146199_1_;
            }
            this.field_146225_q = Math.max(0, Math.min(this.field_146225_q, j));
        }
    }

    public void func_146193_g(int p_146193_1_) {
        super.func_146193_g(p_146193_1_);
        this.editableColor = p_146193_1_;
    }

    public void func_146204_h(int p_146204_1_) {
        super.func_146204_h(p_146204_1_);
        this.notEditableColor = p_146204_1_;
    }

    public void func_146184_c(boolean p_146184_1_) {
        super.func_146184_c(p_146184_1_);
        this.editable = p_146184_1_;
    }

    public void func_146191_b(String p_146191_1_) {
        String newText = "";
        String substr = ChatAllowedCharacters.func_71565_a((String)p_146191_1_);
        int cursorPosition = this.func_146198_h();
        int maxStringLength = this.func_146208_g();
        String text = this.func_146179_b();
        if (text.isEmpty()) {
            newText = substr.substring(0, Math.min(maxStringLength, substr.length()));
            cursorPosition = newText.length();
        } else {
            int selectionEnd = this.func_146186_n();
            String textStart = text.substring(0, Math.min(cursorPosition, selectionEnd));
            String textEnd = text.substring(Math.max(cursorPosition, selectionEnd));
            newText = textStart + substr + textEnd;
            if (newText.length() > maxStringLength) {
                newText = newText.substring(0, maxStringLength);
            }
            cursorPosition = Math.min(textStart.length() + substr.length(), newText.length());
        }
        this.func_146180_a(newText);
        this.func_146190_e(cursorPosition);
    }

    public int func_146183_a(int p_146183_1_, int p_146183_2_) {
        return this.func_146197_a(p_146183_1_, p_146183_2_, true);
    }

    public void func_146194_f() {
        if (this.func_146176_q()) {
            if (this.func_146181_i()) {
                FormattedTextField.func_73734_a((int)(this.field_146209_f - 1), (int)(this.field_146210_g - 1), (int)(this.field_146209_f + this.field_146218_h + 1), (int)(this.field_146210_g + this.field_146219_i + 1), (int)-6250336);
                FormattedTextField.func_73734_a((int)this.field_146209_f, (int)this.field_146210_g, (int)(this.field_146209_f + this.field_146218_h), (int)(this.field_146210_g + this.field_146219_i), (int)-16777216);
            }
            if (!this.rawText.equals(this.func_146179_b())) {
                this.rawText = this.func_146179_b();
                this.formattedText = this.formatter.format(this.rawText);
                if (!EnumChatFormatting.func_110646_a((String)this.formattedText).toLowerCase().equals(this.rawText.toLowerCase())) {
                    this.formattedText = this.rawText;
                }
            }
            int firstCharacterIndex = this.getFormattedTextShift(this.field_146225_q);
            String rawTextClipped = this.fontRenderer.func_78269_a(this.rawText.substring(this.field_146225_q), this.func_146200_o());
            String textClipped = this.formattedText.substring(firstCharacterIndex, this.getFormattedTextShift(this.field_146225_q + rawTextClipped.length()));
            int cursorPosition = this.getFormattedTextShift(this.func_146198_h());
            int selectionEnd = this.getFormattedTextShift(this.func_146186_n());
            int color = this.editable ? this.editableColor : this.notEditableColor;
            int cursorA = cursorPosition - firstCharacterIndex;
            int cursorB = selectionEnd - firstCharacterIndex;
            boolean flag = cursorA >= 0 && cursorA <= textClipped.length();
            boolean flag1 = this.func_146206_l() && this.frame / 6 % 2 == 0 && flag;
            boolean flag2 = this.func_146198_h() < this.rawText.length() || this.rawText.length() >= this.func_146208_g();
            int x = this.func_146181_i() ? this.field_146209_f + 4 : this.field_146209_f;
            int y = this.func_146181_i() ? this.field_146210_g + (this.field_146219_i - 8) / 2 : this.field_146210_g;
            int x2 = x;
            if (cursorB > textClipped.length()) {
                cursorB = textClipped.length();
            }
            if (textClipped.length() > 0) {
                String s1 = flag ? textClipped.substring(0, cursorA) : textClipped;
                String colorA = this.getPreviousColor(firstCharacterIndex);
                x2 = this.fontRenderer.func_78261_a(colorA + s1, x, y, color);
            }
            int k1 = x2;
            if (!flag) {
                k1 = cursorA > 0 ? x + this.field_146218_h : x;
            } else if (flag2) {
                k1 = x2 - 1;
                --x2;
            }
            if (textClipped.length() > 0 && flag && cursorA < textClipped.length()) {
                String colorB = this.getPreviousColor(firstCharacterIndex + cursorA);
                this.fontRenderer.func_78261_a(colorB + textClipped.substring(cursorA), x2, y, color);
            }
            if (flag1) {
                if (flag2) {
                    Gui.func_73734_a((int)k1, (int)(y - 1), (int)(k1 + 1), (int)(y + 1 + this.fontRenderer.field_78288_b), (int)-3092272);
                } else {
                    this.fontRenderer.func_78261_a("_", k1, y, color);
                }
            }
            if (cursorB != cursorA) {
                int l1 = x + this.fontRenderer.func_78256_a(textClipped.substring(0, cursorB));
                this.drawCursorVertical(k1, y - 1, l1 - 1, y + 1 + this.fontRenderer.field_78288_b);
            }
        }
    }

    private void drawCursorVertical(int x1, int y1, int x2, int y2) {
        int i1;
        if (x1 < x2) {
            i1 = x1;
            x1 = x2;
            x2 = i1;
        }
        if (y1 < y2) {
            i1 = y1;
            y1 = y2;
            y2 = i1;
        }
        if (x2 > this.field_146209_f + this.field_146218_h) {
            x2 = this.field_146209_f + this.field_146218_h;
        }
        if (x1 > this.field_146209_f + this.field_146218_h) {
            x1 = this.field_146209_f + this.field_146218_h;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x1, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    private int getFormattedTextShift(int position) {
        int shift = 0;
        for (int i = 0; i < position; ++i) {
            while (this.formattedText.length() > i + shift && this.formattedText.charAt(i + shift) == '\u00a7') {
                shift += 2;
            }
        }
        return position + shift;
    }

    private String getPreviousColor(int position) {
        while (position >= 0) {
            if (this.formattedText.charAt(position) == '\u00a7') {
                return this.formattedText.substring(position, position + 2);
            }
            --position;
        }
        return "";
    }

    public static interface TextFormatter {
        public static final TextFormatter DEFAULT = text -> text;

        public String format(String var1);
    }
}

