/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.api.IAdvancedCardSettings;
import shedar.mods.ic2.nuclearcontrol.api.ICardGui;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.IPanelMultiCard;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.gui.GuiInfoPanel;
import shedar.mods.ic2.nuclearcontrol.gui.GuiPanelSlope;
import shedar.mods.ic2.nuclearcontrol.gui.GuiScreenColor;
import shedar.mods.ic2.nuclearcontrol.gui.controls.GuiInfoPanelCheckBox;
import shedar.mods.ic2.nuclearcontrol.gui.controls.IconButton;
import shedar.mods.ic2.nuclearcontrol.panel.CardSettingsWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanel;

@SideOnly(value=Side.CLIENT)
public class GuiAdvancedInfoPanel
extends GuiInfoPanel {
    private static final String TEXTURE_FILE = "nuclearcontrol:textures/gui/GUIAdvancedInfoPanel.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("nuclearcontrol:textures/gui/GUIAdvancedInfoPanel.png");
    private static final int ID_LABELS = 1;
    private static final int ID_SLOPE = 2;
    private static final int ID_COLORS = 3;
    private static final int ID_POWER = 4;
    private static final int ID_SETTINGS = 5;
    private static final int ID_TRANSPARENCY = 6;
    private static final int ID_ROTATELEFT = 7;
    private static final int ID_ROTATERIGHT = 8;
    private byte activeTab;
    private boolean initialized;

    public GuiAdvancedInfoPanel(Container container) {
        super(container);
        this.field_147000_g = 228;
        this.activeTab = 0;
        this.initialized = false;
        this.name = StatCollector.func_74838_a((String)"tile.blockAdvancedInfoPanel.name");
        this.isColored = this.container.panel.getColored();
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE_LOCATION);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(left + 24, top + 62 + this.activeTab * 14, 182, 0, 1, 15);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
    }

    @Override
    protected void initControls() {
        ItemStack card = this.getActiveCard();
        if (card == null && this.prevCard == null && this.initialized || card != null && card.equals(this.prevCard)) {
            return;
        }
        this.initialized = true;
        int h = this.field_146289_q.field_78288_b + 1;
        this.field_146292_n.clear();
        this.prevCard = card;
        this.field_146292_n.add(new IconButton(1, this.field_147003_i + 80 + 36, this.field_147009_r + 42 + 18, 16, 16, TEXTURE_LOCATION, 176, this.getIconLabelsTopOffset(this.container.panel.getShowLabels())));
        this.field_146292_n.add(new IconButton(2, this.field_147003_i + 80 + 54, this.field_147009_r + 42 + 18, 16, 16, TEXTURE_LOCATION, 192, 15));
        this.field_146292_n.add(new IconButton(3, this.field_147003_i + 80 + 36, this.field_147009_r + 42, 16, 16, TEXTURE_LOCATION, 192, 31));
        this.field_146292_n.add(new IconButton(4, this.field_147003_i + 80 + 54, this.field_147009_r + 42, 16, 16, TEXTURE_LOCATION, 176, this.getIconPowerTopOffset(((TileEntityAdvancedInfoPanel)this.container.panel).getPowerMode())));
        this.field_146292_n.add(new IconButton(6, this.field_147003_i + 80 + 72, this.field_147009_r + 42 + 18, 16, 16, TEXTURE_LOCATION, 192, 63));
        this.field_146292_n.add(new IconButton(7, this.field_147003_i + 80 + 18, this.field_147009_r + 42, 16, 16, TEXTURE_LOCATION, 192, 79));
        this.field_146292_n.add(new IconButton(8, this.field_147003_i + 80 + 18, this.field_147009_r + 42 + 18, 16, 16, TEXTURE_LOCATION, 192, 95));
        if (card != null && card.func_77973_b() instanceof IPanelDataSource) {
            byte slot = this.container.panel.getIndexOfCard(card);
            IPanelDataSource source = (IPanelDataSource)card.func_77973_b();
            if (source instanceof IAdvancedCardSettings) {
                this.field_146292_n.add(new IconButton(5, this.field_147003_i + 80 + 72, this.field_147009_r + 42, 16, 16, TEXTURE_LOCATION, 192, 47));
            }
            List<PanelSetting> settingsList = card.func_77973_b() instanceof IPanelMultiCard ? ((IPanelMultiCard)((Object)source)).getSettingsList(new CardWrapperImpl(card, this.activeTab)) : source.getSettingsList();
            int hy = this.field_146289_q.field_78288_b + 1;
            int x = this.field_147003_i + 30;
            int hpos = this.field_147009_r + 60;
            if (settingsList != null) {
                for (int i = 0; i < settingsList.size(); ++i) {
                    PanelSetting panelSetting = settingsList.get(i);
                    if (i >= 42) break;
                    int column = i < 24 ? i / 8 : (i - 24) / 6 + 3;
                    int row = i < 24 ? i % 8 : (i - 24) % 6;
                    int xpos = x + column * 23;
                    int ypos = i < 24 ? hpos + row * hy : hpos + row * hy + hy * 2;
                    this.field_146292_n.add(new GuiInfoPanelCheckBox(0, xpos, ypos, panelSetting, this.container.panel, slot, this.field_146289_q));
                }
            }
            if (!this.modified) {
                this.textboxTitle = new GuiTextField(this.field_146289_q, 7, 16, 162, 18);
                this.textboxTitle.func_146195_b(true);
                this.textboxTitle.func_146180_a(new CardWrapperImpl(card, this.activeTab).getTitle());
            }
        } else {
            this.modified = false;
            this.textboxTitle = null;
        }
    }

    @Override
    protected ItemStack getActiveCard() {
        return this.container.panel.getCards().get(this.activeTab);
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.initialized = false;
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    private int getIconLabelsTopOffset(boolean checked) {
        return checked ? 15 : 31;
    }

    private int getIconPowerTopOffset(byte mode) {
        switch (mode) {
            case 0: {
                return 47;
            }
            case 1: {
                return 63;
            }
            case 2: {
                return 79;
            }
            case 3: {
                return 95;
            }
        }
        return 47;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 3: {
                GuiScreenColor colorGui = new GuiScreenColor(this, this.container.panel);
                this.field_146297_k.func_147108_a((GuiScreen)colorGui);
                break;
            }
            case 5: {
                ItemStack card = this.getActiveCard();
                if (card == null) {
                    return;
                }
                if (!(card.func_77973_b() instanceof IAdvancedCardSettings)) break;
                CardWrapperImpl helper = new CardWrapperImpl(card, this.activeTab);
                ICardGui guiObject = ((IAdvancedCardSettings)card.func_77973_b()).getSettingsScreen(helper);
                if (!(guiObject instanceof GuiScreen)) {
                    IC2NuclearControl.logger.warn("Invalid card, getSettingsScreen method should return GuiScreen object");
                    return;
                }
                GuiScreen gui = (GuiScreen)guiObject;
                CardSettingsWrapperImpl wrapper = new CardSettingsWrapperImpl(card, this.container.panel, this, this.activeTab);
                ((ICardGui)gui).setCardSettingsHelper(wrapper);
                this.field_146297_k.func_147108_a(gui);
                break;
            }
            case 1: {
                boolean checked;
                boolean bl = checked = !this.container.panel.getShowLabels();
                if (button instanceof IconButton) {
                    IconButton iButton = (IconButton)button;
                    iButton.textureTop = this.getIconLabelsTopOffset(checked);
                }
                int value = checked ? -1 : -2;
                this.container.panel.setShowLabels(checked);
                ((NetworkManager)IC2.network.get()).initiateClientTileEntityEvent((TileEntity)this.container.panel, value);
                break;
            }
            case 4: {
                byte mode = ((TileEntityAdvancedInfoPanel)this.container.panel).getNextPowerMode();
                if (button instanceof IconButton) {
                    IconButton iButton = (IconButton)button;
                    iButton.textureTop = this.getIconPowerTopOffset(mode);
                }
                ((NetworkManager)IC2.network.get()).initiateClientTileEntityEvent((TileEntity)this.container.panel, (int)mode);
                break;
            }
            case 2: {
                GuiPanelSlope slopeGui = new GuiPanelSlope(this, (TileEntityAdvancedInfoPanel)this.container.panel);
                this.field_146297_k.func_147108_a((GuiScreen)slopeGui);
                break;
            }
            case 6: {
                ((NetworkManager)IC2.network.get()).initiateClientTileEntityEvent((TileEntity)this.container.panel, 6);
                break;
            }
            case 7: {
                ((NetworkManager)IC2.network.get()).initiateClientTileEntityEvent((TileEntity)this.container.panel, 7);
                break;
            }
            case 8: {
                ((NetworkManager)IC2.network.get()).initiateClientTileEntityEvent((TileEntity)this.container.panel, 8);
            }
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        if (x >= this.field_147003_i + 7 && x <= this.field_147003_i + 24 && y >= this.field_147009_r + 62 && y <= this.field_147009_r + 104) {
            byte newTab = (byte)((y - this.field_147009_r - 62) / 14);
            if (newTab > 2) {
                newTab = 2;
            }
            if (newTab != this.activeTab && this.modified) {
                this.updateTitle();
            }
            this.activeTab = newTab;
        }
    }
}

