/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui;

import com.creativemd.creativecore.common.container.ContainerSub;
import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import java.util.ArrayList;
import javax.vecmath.Vector2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerSub
extends GuiContainer {
    public static final ResourceLocation background = new ResourceLocation("creativecore:textures/gui/GUI.png");
    protected ArrayList<SubGui> layers;

    public GuiContainerSub(EntityPlayer player, SubGui gui, SubContainer container) {
        super((Container)new ContainerSub(player, container));
        ((ContainerSub)this.field_147002_h).gui = this;
        this.layers = new ArrayList();
        gui.container = container;
        gui.gui = this;
        this.layers.add(gui);
        gui.initGui();
        this.resize();
        SubGui.itemRender = GuiScreen.field_146296_j;
    }

    public ArrayList<SubGui> getLayers() {
        return this.layers;
    }

    public void removeLayer(SubGui layer) {
        this.layers.remove(layer);
        ((ContainerSub)this.field_147002_h).layers.remove(layer.container);
        this.resize();
    }

    public void addLayer(SubGui layer) {
        this.layers.add(layer);
        ((ContainerSub)this.field_147002_h).layers.add(layer.container);
        this.resize();
    }

    public void resize() {
        this.field_146999_f = 0;
        this.field_147000_g = 0;
        for (int i = 0; i < this.layers.size(); ++i) {
            if (this.layers.get((int)i).width > this.field_146999_f) {
                this.field_146999_f = this.layers.get((int)i).width;
            }
            if (this.layers.get((int)i).height <= this.field_147000_g) continue;
            this.field_147000_g = this.layers.get((int)i).height;
        }
    }

    public int getWidth() {
        return this.field_146999_f;
    }

    public int getHeight() {
        return this.field_147000_g;
    }

    public int getMaxScale(Minecraft mc) {
        int scaleFactor;
        int k = 1000;
        for (scaleFactor = 1; scaleFactor < k && this.field_146999_f * (scaleFactor + 1) <= mc.field_71443_c && this.field_147000_g * (scaleFactor + 1) <= mc.field_71440_d; ++scaleFactor) {
        }
        return scaleFactor;
    }

    public void func_146276_q_() {
    }

    public void func_146979_b(int par1, int par2) {
        for (int i = 0; i < this.layers.size(); ++i) {
            GL11.glPushMatrix();
            int k = this.field_147003_i;
            int l = this.field_147009_r;
            GL11.glTranslatef((float)(-k), (float)(-l), (float)0.0f);
            this.func_146270_b(0);
            int offX = (this.field_146294_l - this.layers.get((int)i).width) / 2 - k;
            int offY = (this.field_146295_m - this.layers.get((int)i).height) / 2 - l;
            GL11.glTranslatef((float)k, (float)l, (float)0.0f);
            GL11.glTranslatef((float)offX, (float)offY, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.layers.get(i).drawBackground();
            RenderHelper.func_74520_c();
            int short1 = 240;
            int short2 = 240;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.layers.get(i).drawForeground(this.field_146289_q);
            GL11.glTranslatef((float)(-offX), (float)(-offY), (float)0.0f);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public boolean hasTopLayer() {
        return this.layers.size() > 0;
    }

    public SubGui getTopLayer() {
        if (this.hasTopLayer()) {
            return this.layers.get(this.layers.size() - 1);
        }
        return null;
    }

    public void func_73869_a(char character, int key) {
        if (this.getTopLayer() != null && !this.getTopLayer().keyTyped(character, key)) {
            super.func_73869_a(character, key);
        }
    }

    public void func_146269_k() {
        if (Mouse.isCreated()) {
            this.handleScrolling();
            Vector2d mouse = GuiControl.getMousePos(this.field_146294_l, this.field_146295_m);
            this.getTopLayer().mouseMove((int)mouse.x, (int)mouse.y, 0);
        }
        super.func_146269_k();
    }

    public void handleScrolling() {
        int j = Mouse.getDWheel();
        if (j != 0) {
            Vector2d mouse = GuiControl.getMousePos(this.field_146294_l, this.field_146295_m);
            this.getTopLayer().mouseScrolled((int)mouse.x, (int)mouse.y, j);
        }
    }

    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.getTopLayer().mousePressed(x, y, button);
    }

    public void func_146273_a(int x, int y, int button, long time) {
        super.func_146273_a(x, y, button, time);
        this.getTopLayer().mouseDragged(x, y, button, time);
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.onMouseReleased(x, y, button);
    }

    public void onMouseMove(int x, int y, int button) {
        this.getTopLayer().mouseMove(x, y, button);
    }

    public void onMouseReleased(int x, int y, int button) {
        this.getTopLayer().mouseReleased(x, y, button);
    }

    public void func_146281_b() {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).onGuiClose();
        }
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
    }
}

