/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.utils.BlockMeta;
import com.recursive_pineapple.matter_manipulator.common.utils.ImmutableBlockMeta;
import com.recursive_pineapple.matter_manipulator.common.utils.Lazy;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Objects;
import net.minecraft.block.Block;

public class LazyBlock
extends Lazy<ImmutableBlockMeta> {
    public final Mods mod;
    public final String blockName;

    public LazyBlock(Mods mod, String blockName, int meta) {
        super(() -> {
            if (!mod.isModLoaded()) {
                return null;
            }
            Block block = GameRegistry.findBlock((String)mod.ID, (String)blockName);
            Objects.requireNonNull(block, "could not find block: " + mod.ID + ":" + blockName);
            return new BlockMeta(block, meta);
        });
        this.mod = mod;
        this.blockName = blockName;
    }

    public LazyBlock(Mods mod, String blockName) {
        this(mod, blockName, 0);
    }

    public boolean isLoaded() {
        return this.mod.isModLoaded();
    }

    public boolean matches(Block other, int metaOther) {
        if (!this.isLoaded()) {
            return false;
        }
        ImmutableBlockMeta bm = (ImmutableBlockMeta)this.get();
        return bm == null ? false : bm.matches(other, metaOther);
    }

    public boolean matches(ImmutableBlockSpec spec) {
        return this.matches(spec.getBlock(), spec.getBlockMeta());
    }
}

