/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.data;

import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import it.unimi.dsi.fastutil.objects.ObjectIntMutablePair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;

public class WeightedSpecList {
    public ArrayList<ObjectIntMutablePair<BlockSpec>> specs = new ArrayList();

    public WeightedSpecList(BlockSpec ... values) {
        for (BlockSpec spec : values) {
            this.add(spec);
        }
    }

    public void add(BlockSpec spec) {
        for (ObjectIntMutablePair<BlockSpec> p : this.specs) {
            if (!Objects.equals(p.first(), spec)) continue;
            p.right(p.rightInt() + 1);
            return;
        }
        this.specs.add((ObjectIntMutablePair<BlockSpec>)ObjectIntMutablePair.of((Object)spec, (int)1));
    }

    public ImmutableBlockSpec get(Random rng) {
        if (this.specs.isEmpty()) {
            return BlockSpec.AIR;
        }
        int sum = 0;
        for (ObjectIntMutablePair<BlockSpec> p : this.specs) {
            sum += p.rightInt();
        }
        if (sum == 0) {
            return BlockSpec.AIR;
        }
        int selector = rng.nextInt(sum);
        for (ObjectIntMutablePair<BlockSpec> p : this.specs) {
            if (selector < p.rightInt()) {
                return (ImmutableBlockSpec)p.left();
            }
            selector -= p.rightInt();
        }
        return BlockSpec.AIR;
    }

    public boolean contains(BlockSpec spec) {
        for (ObjectIntMutablePair<BlockSpec> p : this.specs) {
            if (!Objects.equals(p.first(), spec)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ObjectIntMutablePair<BlockSpec> p : this.specs) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(((BlockSpec)p.left()).getDisplayName());
            if (p.rightInt() <= 1) continue;
            sb.append(" x ").append(p.rightInt());
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.specs == null ? 0 : this.specs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeightedSpecList other = (WeightedSpecList)obj;
        return !(this.specs == null ? other.specs != null : !this.specs.equals(other.specs));
    }
}

