/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.compat;

import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.BooleanProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.DirectionBlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.IntegerProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.MetaBlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.Orientation;
import com.recursive_pineapple.matter_manipulator.common.compat.OrientationBlockProperty;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.tileentity.TileEntitySmallFloodlight;
import gcewing.architecture.common.tile.TileArchitecture;
import ic2.api.tile.IWrenchable;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPropertyRegistry {
    public static final Object2ObjectOpenHashMap<Block, Object2ObjectArrayMap<String, BlockProperty<?>>> SPECIFIC_BLOCK_PROPERTIES = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Class<?>, Object2ObjectArrayMap<String, BlockProperty<?>>> BLOCK_IFACE_PROPERTIES = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Class<?>, Object2ObjectArrayMap<String, BlockProperty<?>>> TILE_IFACE_PROPERTIES = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Class<?>, Object2ObjectArrayMap<String, BlockProperty<?>>> CACHED_PROPERTIES = new Object2ObjectOpenHashMap();

    private BlockPropertyRegistry() {
    }

    public static void registerProperty(Block block, BlockProperty<?> property) {
        ((Object2ObjectArrayMap)SPECIFIC_BLOCK_PROPERTIES.computeIfAbsent((Object)block, x -> new Object2ObjectArrayMap())).put((Object)property.getName(), property);
    }

    public static void registerProperty(Collection<Block> blocks, BlockProperty<?> property) {
        for (Block block : blocks) {
            ((Object2ObjectArrayMap)SPECIFIC_BLOCK_PROPERTIES.computeIfAbsent((Object)block, x -> new Object2ObjectArrayMap())).put((Object)property.getName(), property);
        }
    }

    public static void registerBlockInterfaceProperty(Class<?> iface, BlockProperty<?> property) {
        ((Object2ObjectArrayMap)BLOCK_IFACE_PROPERTIES.computeIfAbsent(iface, x -> new Object2ObjectArrayMap())).put((Object)property.getName(), property);
    }

    public static void registerTileEntityInterfaceProperty(Class<?> iface, BlockProperty<?> property) {
        ((Object2ObjectArrayMap)TILE_IFACE_PROPERTIES.computeIfAbsent(iface, x -> new Object2ObjectArrayMap())).put((Object)property.getName(), property);
    }

    private static Map<String, BlockProperty<?>> cacheBlockProperties(Block block) {
        Class<?> clazz = block.getClass();
        Object2ObjectArrayMap cache = new Object2ObjectArrayMap();
        CACHED_PROPERTIES.put(clazz, (Object)cache);
        Object2ObjectArrayMap props = (Object2ObjectArrayMap)SPECIFIC_BLOCK_PROPERTIES.get((Object)block);
        if (props != null) {
            cache.putAll((Map)props);
        }
        for (Object2ObjectMap.Entry e : BLOCK_IFACE_PROPERTIES.object2ObjectEntrySet()) {
            if (!((Class)e.getKey()).isAssignableFrom(clazz)) continue;
            ((Object2ObjectArrayMap)e.getValue()).forEach((name, prop) -> {
                if (prop.appliesTo(block)) {
                    cache.put(name, prop);
                }
            });
        }
        return cache;
    }

    private static Map<String, BlockProperty<?>> cacheTileProperties(TileEntity tile) {
        Class<?> clazz = tile.getClass();
        Object2ObjectArrayMap cache = new Object2ObjectArrayMap();
        CACHED_PROPERTIES.put(clazz, (Object)cache);
        for (Object2ObjectMap.Entry e : TILE_IFACE_PROPERTIES.object2ObjectEntrySet()) {
            if (!((Class)e.getKey()).isAssignableFrom(clazz)) continue;
            ((Object2ObjectArrayMap)e.getValue()).forEach((name, prop) -> {
                if (prop.appliesTo(tile)) {
                    cache.put(name, prop);
                }
            });
        }
        return cache;
    }

    public static void getProperties(World world, int x, int y, int z, Map<String, BlockProperty<?>> properties) {
        TileEntity tile;
        Block block = world.func_147439_a(x, y, z);
        Map<String, BlockProperty<?>> props = (Map<String, BlockProperty<?>>)CACHED_PROPERTIES.get(block.getClass());
        if (props == null) {
            props = BlockPropertyRegistry.cacheBlockProperties(block);
        }
        properties.putAll(props);
        if (block.hasTileEntity(world.func_72805_g(x, y, z)) && (tile = world.func_147438_o(x, y, z)) != null) {
            props = (Map<String, BlockProperty<?>>)CACHED_PROPERTIES.get(tile.getClass());
            if (props == null) {
                props = BlockPropertyRegistry.cacheTileProperties(tile);
            }
            properties.putAll(props);
        }
    }

    public static BlockProperty<?> getProperty(World world, int x, int y, int z, String name) {
        TileEntity tile;
        BlockProperty<?> prop;
        Block block = world.func_147439_a(x, y, z);
        Map<String, BlockProperty<?>> props = (Map<String, BlockProperty<?>>)CACHED_PROPERTIES.get(block.getClass());
        if (props == null) {
            props = BlockPropertyRegistry.cacheBlockProperties(block);
        }
        if ((prop = props.get(name)) != null) {
            return prop;
        }
        if (block.hasTileEntity(world.func_72805_g(x, y, z)) && (tile = world.func_147438_o(x, y, z)) != null) {
            props = (Map<String, BlockProperty<?>>)CACHED_PROPERTIES.get(tile.getClass());
            if (props == null) {
                props = BlockPropertyRegistry.cacheTileProperties(tile);
            }
            if ((prop = props.get(name)) != null) {
                return prop;
            }
        }
        return null;
    }

    public static void init() {
        BlockPropertyRegistry.initVanilla();
        if (Mods.StorageDrawers.isModLoaded()) {
            BlockPropertyRegistry.initStorageDrawers();
        }
        if (Mods.IndustrialCraft2.isModLoaded()) {
            BlockPropertyRegistry.initIC2();
        }
        if (Mods.ArchitectureCraft.isModLoaded()) {
            BlockPropertyRegistry.initArch();
        }
        if (Mods.FloodLights.isModLoaded()) {
            BlockPropertyRegistry.initFloodLights();
        }
    }

    private static void initVanilla() {
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockLog.class, DirectionBlockProperty.facing(12, dir -> {
            int n;
            switch (dir) {
                case UP: 
                case DOWN: {
                    n = 0;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    n = 8;
                    break;
                }
                case WEST: 
                case EAST: {
                    n = 4;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 4: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 8: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UP;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerProperty(Blocks.field_150448_aq, new MetaBlockProperty<RailMode>(){

            @Override
            public String getName() {
                return "mode";
            }

            @Override
            public RailMode getValue(int meta) {
                return BlockPropertyRegistry.getRailMode(meta, true);
            }

            @Override
            public int getMeta(RailMode value, int existing) {
                return BlockPropertyRegistry.getRailMeta(value, BlockPropertyRegistry.getRailDirection(existing, true), true, false);
            }

            @Override
            public RailMode parse(String text) throws Exception {
                return RailMode.parse(text);
            }
        });
        BlockPropertyRegistry.registerProperty(Blocks.field_150448_aq, DirectionBlockProperty.facing((dir, existing) -> BlockPropertyRegistry.getRailMeta(BlockPropertyRegistry.getRailMode(existing, true), dir, true, false), meta -> BlockPropertyRegistry.getRailDirection(meta, true)));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), new MetaBlockProperty<RailMode>(){

            @Override
            public String getName() {
                return "mode";
            }

            @Override
            public RailMode getValue(int meta) {
                return BlockPropertyRegistry.getRailMode(meta, false);
            }

            @Override
            public int getMeta(RailMode value, int existing) {
                return BlockPropertyRegistry.getRailMeta(value, BlockPropertyRegistry.getRailDirection(existing, false), false, BlockPropertyRegistry.isRailPowered(existing));
            }

            @Override
            public RailMode parse(String text) throws Exception {
                return RailMode.parse(text);
            }
        });
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), DirectionBlockProperty.facing((dir, existing) -> BlockPropertyRegistry.getRailMeta(BlockPropertyRegistry.getRailMode(existing, false), dir, false, BlockPropertyRegistry.isRailPowered(existing)), meta -> BlockPropertyRegistry.getRailDirection(meta, false)));
        BooleanProperty.FlagBooleanProperty powered = BooleanProperty.flag("powered", 8);
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), powered);
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockButton.class, powered);
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockButton.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTorch.class, DirectionBlockProperty.facing(-1, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerProperty(Blocks.field_150429_aA, BooleanProperty.blocks("powered", Blocks.field_150437_az, Blocks.field_150429_aA));
        BlockPropertyRegistry.registerProperty(Blocks.field_150437_az, BooleanProperty.blocks("powered", Blocks.field_150437_az, Blocks.field_150429_aA));
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, powered);
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, new DirectionBlockProperty(){

            @Override
            public String getName() {
                return "forward";
            }

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                ForgeDirection forgeDirection;
                int meta = world.func_72805_g(x, y, z) & 7;
                switch (meta) {
                    case 5: {
                        forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    case 6: {
                        forgeDirection = ForgeDirection.EAST;
                        break;
                    }
                    case 0: {
                        forgeDirection = ForgeDirection.EAST;
                        break;
                    }
                    case 7: {
                        forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    default: {
                        forgeDirection = ForgeDirection.UNKNOWN;
                    }
                }
                return forgeDirection;
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                int meta = world.func_72805_g(x, y, z);
                int power = meta & 8;
                if ((meta &= 7) == 0 || meta == 7) {
                    int n = meta = value == ForgeDirection.EAST || value == ForgeDirection.WEST ? 0 : 7;
                }
                if (meta == 5 || meta == 6) {
                    meta = value == ForgeDirection.EAST || value == ForgeDirection.WEST ? 6 : 5;
                }
                world.func_72921_c(x, y, z, meta + power, 2);
            }
        });
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, DirectionBlockProperty.facing((dir, existing) -> {
            int n;
            switch (dir) {
                case NORTH: {
                    n = 3;
                    break;
                }
                case SOUTH: {
                    n = 4;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case UP: {
                    if (existing % 8 == 7) {
                        n = 7;
                        break;
                    }
                    n = 0;
                    break;
                }
                case DOWN: {
                    if (existing % 8 == 6) {
                        n = 6;
                        break;
                    }
                    n = 5;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return (existing & 8) + n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta & 7) {
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 0: 
                case 7: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 5: 
                case 6: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UNKNOWN;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPistonBase.class, powered);
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPistonBase.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPistonExtension.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockSlab.class, new BooleanProperty.FlagBooleanProperty("top", 8){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean appliesTo(Object obj) {
                if (!(obj instanceof BlockSlab)) return false;
                BlockSlab slab = (BlockSlab)obj;
                if (slab.field_150004_a) return false;
                return true;
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockStairs.class, DirectionBlockProperty.facing(3, dir -> {
            int n;
            switch (dir) {
                case EAST: {
                    n = 0;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case SOUTH: {
                    n = 2;
                    break;
                }
                case NORTH: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockStairs.class, DirectionBlockProperty.facing(4, dir -> {
            int n;
            switch (dir) {
                case UP: {
                    n = 0;
                    break;
                }
                case DOWN: {
                    n = 4;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UP;
                }
            }
            return forgeDirection;
        }).setName("up"));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockChest.class, DirectionBlockProperty.facing(7, 2, 3, 4, 5, -1, -1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockAnvil.class, DirectionBlockProperty.facing(3, dir -> {
            int n;
            switch (dir) {
                case WEST: {
                    n = 0;
                    break;
                }
                case NORTH: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case SOUTH: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 3: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockAnvil.class, IntegerProperty.meta("damage", 12, 2).map(Arrays.asList("undamaged", "slightly_damaged", "very_damaged", "broken")));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150488_af, IntegerProperty.meta("power", 15, 0));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFurnace.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFurnace.class, BooleanProperty.blocks("lit", Blocks.field_150460_al, Blocks.field_150470_am));
        BlockPropertyRegistry.registerProperty(Blocks.field_150444_as, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(Blocks.field_150472_an, new IntegerProperty(){

            @Override
            public String getName() {
                return "rotation";
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                return world.func_72805_g(x, y, z) * 360 / 16;
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                int meta = value * 16 / 360;
                world.func_72921_c(x, y, z, meta, 2);
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntitySign.class, new BlockProperty<String>(){

            @Override
            public String getName() {
                return "text";
            }

            @Override
            public String getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySign)) {
                    return "";
                }
                TileEntitySign sign = (TileEntitySign)tileEntity;
                return String.join((CharSequence)"\n", sign.field_145915_a);
            }

            @Override
            public void setValue(World world, int x, int y, int z, String value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySign)) {
                    return;
                }
                TileEntitySign sign = (TileEntitySign)tileEntity;
                String[] text = value.split("\n");
                sign.field_145915_a = new String[4];
                for (int i = 0; i < 4; ++i) {
                    String line = MMUtils.getIndexSafe(text, i);
                    if (line == null) {
                        line = "";
                    }
                    if (line.length() > 15) {
                        line = line.substring(0, 15);
                    }
                    sign.field_145915_a[i] = line;
                }
                sign.func_70296_d();
                world.func_147471_g(x, y, z);
            }

            @Override
            public String parse(String text) throws Exception {
                return text;
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockDoor.class, new DirectionBlockProperty(){

            @Override
            public String getName() {
                return "facing";
            }

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                ForgeDirection forgeDirection;
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return ForgeDirection.UNKNOWN;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                switch (meta & 3) {
                    case 0: {
                        forgeDirection = ForgeDirection.WEST;
                        break;
                    }
                    case 1: {
                        forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    case 2: {
                        forgeDirection = ForgeDirection.EAST;
                        break;
                    }
                    case 3: {
                        forgeDirection = ForgeDirection.SOUTH;
                        break;
                    }
                    default: {
                        forgeDirection = ForgeDirection.NORTH;
                    }
                }
                return forgeDirection;
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                int n;
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                meta &= 0xFFFFFFFC;
                switch (value) {
                    case WEST: {
                        n = 0;
                        break;
                    }
                    case NORTH: {
                        n = 1;
                        break;
                    }
                    case EAST: {
                        n = 2;
                        break;
                    }
                    case SOUTH: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 1;
                    }
                }
                world.func_72921_c(x, y, z, meta |= n, 2);
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockDoor.class, new BooleanProperty(){

            @Override
            public String getName() {
                return "open";
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return false;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                return meta >= 4;
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                meta &= 0xFFFFFFFB;
                if (value) {
                    meta |= 4;
                }
                world.func_72921_c(x, y, z, meta, 2);
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockLadder.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockBasePressurePlate.class, BooleanProperty.flag("powered", 1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPumpkin.class, DirectionBlockProperty.facing(3, 2, 0, 1, 3, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), BooleanProperty.blocks("powered", (Block)Blocks.field_150413_aR, (Block)Blocks.field_150416_aS));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), IntegerProperty.meta("delay", 12, 2));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTrapDoor.class, DirectionBlockProperty.facing(3, 0, 1, 2, 3, -1, -1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTrapDoor.class, BooleanProperty.flag("open", 4));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTrapDoor.class, DirectionBlockProperty.facing(8, -1, -1, -1, -1, 8, 0).setName("up"));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockRedstoneLight.class, BooleanProperty.blocks("powered", Blocks.field_150379_bu, Blocks.field_150374_bv));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, powered);
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, BooleanProperty.flag("connected", 4));
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntitySkull.class, new IntegerProperty(){

            @Override
            public String getName() {
                return "rotation";
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySkull)) {
                    return 0;
                }
                TileEntitySkull skull = (TileEntitySkull)tileEntity;
                return skull.field_145910_i * 360 / 16;
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySkull)) {
                    return;
                }
                TileEntitySkull skull = (TileEntitySkull)tileEntity;
                skull.field_145910_i = value * 16 / 360;
                skull.func_70296_d();
                world.func_147471_g(x, y, z);
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockDispenser.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), BooleanProperty.flag("powered", 8));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), IntegerProperty.meta("mode", 4, 2).map(Arrays.asList("comparator", "subtractor")));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockHopper.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFenceGate.class, DirectionBlockProperty.facing(3, 2, 0, 1, 3, -1, -1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFenceGate.class, BooleanProperty.flag("open", 4));
    }

    private static RailMode getRailMode(int meta, boolean canTurn) {
        return canTurn && meta >= 6 ? RailMode.TURNED : (meta >= 2 ? RailMode.ASCENDING : RailMode.NONE);
    }

    private static ForgeDirection getRailDirection(int meta, boolean canTurn) {
        ForgeDirection forgeDirection;
        if (canTurn) {
            ForgeDirection forgeDirection2;
            switch (meta) {
                case 0: 
                case 4: 
                case 6: {
                    forgeDirection2 = ForgeDirection.NORTH;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    forgeDirection2 = ForgeDirection.WEST;
                    break;
                }
                case 2: 
                case 7: {
                    forgeDirection2 = ForgeDirection.EAST;
                    break;
                }
                case 5: 
                case 8: {
                    forgeDirection2 = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    forgeDirection2 = ForgeDirection.NORTH;
                }
            }
            return forgeDirection2;
        }
        switch (meta) {
            case 0: 
            case 4: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case 1: 
            case 3: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 2: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case 5: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.NORTH;
            }
        }
        return forgeDirection;
    }

    private static boolean isRailPowered(int meta) {
        return meta >= 8;
    }

    private static int getRailMeta(RailMode mode, ForgeDirection dir, boolean canTurn, boolean powered) {
        int n;
        if (canTurn && mode == RailMode.TURNED) {
            int n2;
            switch (dir) {
                case NORTH: {
                    n2 = 6;
                    break;
                }
                case WEST: {
                    n2 = 9;
                    break;
                }
                case EAST: {
                    n2 = 7;
                    break;
                }
                case SOUTH: {
                    n2 = 8;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            return n2;
        }
        if (mode == RailMode.ASCENDING) {
            int n3;
            switch (dir) {
                case NORTH: {
                    n3 = 4;
                    break;
                }
                case WEST: {
                    n3 = 3;
                    break;
                }
                case EAST: {
                    n3 = 2;
                    break;
                }
                case SOUTH: {
                    n3 = 5;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            return n3;
        }
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                n = 0;
                break;
            }
            case WEST: 
            case EAST: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Optional(value={"StorageDrawers"})
    private static void initStorageDrawers() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(clazz, BlockPropertyRegistry.methodIntDirectionTile(clazz, "getDirection", "setDirection"));
    }

    @Optional(value={"IC2"})
    private static void initIC2() {
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(IWrenchable.class, new DirectionBlockProperty.AbstractDirectionBlockProperty("facing"){

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof IWrenchable)) {
                    return ForgeDirection.UNKNOWN;
                }
                IWrenchable wrenchable = (IWrenchable)tileEntity;
                return ForgeDirection.getOrientation((int)wrenchable.getFacing());
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof IWrenchable)) {
                    return;
                }
                IWrenchable wrenchable = (IWrenchable)tileEntity;
                wrenchable.setFacing((short)value.ordinal());
            }
        });
    }

    private static void initArch() {
        final ForgeDirection[][] FORWARDS = new ForgeDirection[][]{{ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.WEST}, {ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}, {ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.WEST}, {ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.UP, ForgeDirection.EAST}, {ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.UP, ForgeDirection.SOUTH}, {ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.UP, ForgeDirection.NORTH}};
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileArchitecture.class, new OrientationBlockProperty(){

            @Override
            public String getName() {
                return "orientation";
            }

            @Override
            public Orientation getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileArchitecture)) {
                    return Orientation.NONE;
                }
                TileArchitecture tile = (TileArchitecture)tileEntity;
                return Orientation.getOrientation(ForgeDirection.getOrientation((int)tile.side), MMUtils.getIndexSafe((ForgeDirection[])MMUtils.getIndexSafe(FORWARDS, (int)tile.side), (int)tile.turn));
            }

            @Override
            public void setValue(World world, int x, int y, int z, Orientation value) {
                int index;
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileArchitecture)) {
                    return;
                }
                TileArchitecture tile = (TileArchitecture)tileEntity;
                if (value == null || value == Orientation.NONE || value.a == value.b || value.a.getOpposite() == value.b) {
                    value = Orientation.DOWN_NORTH;
                }
                if ((index = MMUtils.indexOf((ForgeDirection[])MMUtils.getIndexSafe(FORWARDS, value.a.ordinal()), value.b)) != -1) {
                    tile.turn = (byte)index;
                    tile.side = (byte)value.a.ordinal();
                } else {
                    for (int side = 0; side < FORWARDS.length; ++side) {
                        index = MMUtils.indexOf(FORWARDS[side], value);
                        if (index == -1) continue;
                        tile.side = (byte)side;
                        tile.turn = (byte)index;
                        break;
                    }
                }
                tile.func_70296_d();
                world.func_147471_g(x, y, z);
            }
        });
    }

    private static void initFloodLights() {
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new DirectionBlockProperty.AbstractDirectionBlockProperty("facing"){

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return ForgeDirection.UNKNOWN;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getOrientation();
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection forgeDirection) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                floodlight.setOrientation(forgeDirection);
                if (!(floodlight instanceof TileEntitySmallFloodlight)) {
                    world.func_72921_c(x, y, z, forgeDirection.ordinal(), 2);
                } else {
                    world.func_147471_g(x, y, z);
                }
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new BooleanProperty(){

            @Override
            public String getName() {
                return "inverted";
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return false;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getInverted();
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                if (floodlight.getInverted() != value) {
                    floodlight.toggleInverted();
                }
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new IntegerProperty(){

            @Override
            public String getName() {
                return "mode";
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return 0;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getMode();
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                floodlight.setMode(value);
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new IntegerProperty(){

            @Override
            public String getName() {
                return "color";
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return 0;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getColor();
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                floodlight.setColor(value);
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntitySmallFloodlight.class, new BooleanProperty(){

            @Override
            public String getName() {
                return "rotation_state";
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySmallFloodlight)) {
                    return false;
                }
                TileEntitySmallFloodlight floodlight = (TileEntitySmallFloodlight)tileEntity;
                return floodlight.getRotationState();
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySmallFloodlight)) {
                    return;
                }
                TileEntitySmallFloodlight floodlight = (TileEntitySmallFloodlight)tileEntity;
                floodlight.setRotationState(value);
                world.func_147471_g(x, y, z);
            }
        });
    }

    public static DirectionBlockProperty methodIntDirectionTile(Class<?> clazz, String getterName, String setterName) {
        try {
            Method getter = clazz.getDeclaredMethod(getterName, new Class[0]);
            Method setter = clazz.getDeclaredMethod(setterName, Integer.TYPE);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle getterHandle = lookup.unreflect(getter);
            MethodHandle setterHandle = lookup.unreflect(setter);
            static interface Getter {
                public int get(Object var1);
            }
            final Getter getterFn = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(Getter.class), MethodType.methodType(Integer.TYPE, Object.class), getterHandle, getterHandle.type()).getTarget().invokeExact();
            static interface Setter {
                public void set(Object var1, int var2);
            }
            final Setter setterFn = LambdaMetafactory.metafactory(lookup, "set", MethodType.methodType(Setter.class), MethodType.methodType(Void.TYPE, Object.class, Integer.TYPE), setterHandle, setterHandle.type()).getTarget().invokeExact();
            return new DirectionBlockProperty.AbstractDirectionBlockProperty("facing"){
                {
                    static interface Getter {
                        public int get(Object var1);
                    }
                    static interface Setter {
                        public void set(Object var1, int var2);
                    }
                    super(name);
                }

                @Override
                public ForgeDirection getValue(World world, int x, int y, int z) {
                    TileEntity tile = world.func_147438_o(x, y, z);
                    static interface Getter {
                        public int get(Object var1);
                    }
                    return ForgeDirection.getOrientation((int)getterFn.get(tile));
                }

                @Override
                public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                    TileEntity tile = world.func_147438_o(x, y, z);
                    static interface Setter {
                        public void set(Object var1, int var2);
                    }
                    setterFn.set(tile, value.ordinal());
                    tile.func_70296_d();
                    world.func_147471_g(x, y, z);
                }
            };
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static enum RailMode {
        NONE,
        ASCENDING,
        TURNED;


        public String toString() {
            String string;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    string = "none";
                    break;
                }
                case ASCENDING: {
                    string = "ascending";
                    break;
                }
                case TURNED: {
                    string = "turned";
                }
            }
            return string;
        }

        public static RailMode parse(String name) throws Exception {
            if ("turned".equals(name)) {
                return TURNED;
            }
            if ("ascending".equals(name)) {
                return ASCENDING;
            }
            if ("none".equals(name)) {
                return NONE;
            }
            throw new Exception("illegal rail mode: '" + name + "'");
        }
    }
}

