/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.google.gson.annotations.SerializedName;
import com.recursive_pineapple.matter_manipulator.common.building.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.building.IPseudoInventory;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PortableItemStack
implements IItemProvider {
    @SerializedName(value="id")
    public GameRegistry.UniqueIdentifier item;
    @SerializedName(value="m")
    public Integer metadata;
    @SerializedName(value="a")
    public Integer amount;
    @SerializedName(value="nbt")
    public NBTTagCompound nbt;
    public transient Item itemRef;
    public transient Block blockRef;
    public transient ItemStack itemStack;

    public PortableItemStack() {
    }

    public PortableItemStack(Item item, int metadata) {
        this.item = GameRegistry.findUniqueIdentifierFor((Item)item);
        this.metadata = metadata == 0 ? null : Integer.valueOf(metadata);
        this.amount = null;
    }

    public PortableItemStack(Item item, int metadata, NBTTagCompound nbt) {
        this.item = GameRegistry.findUniqueIdentifierFor((Item)item);
        this.metadata = metadata == 0 ? null : Integer.valueOf(metadata);
        this.amount = null;
        this.nbt = nbt;
    }

    public PortableItemStack(ItemStack stack) {
        this.item = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        this.metadata = Items.field_151008_G.getDamage(stack);
        if (this.metadata == 0) {
            this.metadata = null;
        }
        this.amount = stack.field_77994_a == 1 ? null : Integer.valueOf(stack.field_77994_a);
    }

    public static PortableItemStack withoutStackSize(ItemStack stack) {
        stack = stack.func_77946_l();
        stack.field_77994_a = 1;
        return new PortableItemStack(stack);
    }

    public static PortableItemStack withNBT(ItemStack stack) {
        PortableItemStack portable = new PortableItemStack(stack);
        portable.nbt = stack.func_77978_p() == null ? null : (NBTTagCompound)stack.func_77978_p().func_74737_b();
        return portable;
    }

    public int getMeta() {
        return this.metadata == null ? 0 : this.metadata;
    }

    public Item getItem() {
        if (this.blockRef == null) {
            this.itemRef = GameRegistry.findItem((String)this.item.modId, (String)this.item.name);
        }
        return this.itemRef;
    }

    public ItemStack toStack() {
        if (this.itemStack == null) {
            Item item = this.getItem();
            if (item == null) {
                return null;
            }
            this.itemStack = new ItemStack(item, this.amount == null ? 1 : this.amount, this.metadata == null ? 0 : this.metadata);
            if (this.nbt != null) {
                this.itemStack.func_77982_d((NBTTagCompound)this.nbt.func_74737_b());
            }
        }
        return this.itemStack.func_77946_l();
    }

    public Block getBlock() {
        if (this.blockRef == null) {
            this.blockRef = GameRegistry.findBlock((String)this.item.modId, (String)this.item.name);
        }
        return this.blockRef;
    }

    @Override
    public ItemStack getStack(IPseudoInventory inv, boolean consume) {
        ItemStack stack = this.toStack();
        if (!consume) {
            return stack;
        }
        if (!inv.tryConsumeItems(stack)) {
            return null;
        }
        return stack;
    }

    public String toString() {
        return this.toStack().func_82833_r() + (this.amount == null || this.amount == 1 ? "" : " x " + this.amount);
    }

    @Override
    public PortableItemStack clone() {
        PortableItemStack dup = new PortableItemStack();
        dup.item = this.item;
        dup.metadata = this.metadata;
        dup.amount = this.amount;
        dup.nbt = this.nbt == null ? null : (NBTTagCompound)this.nbt.func_74737_b();
        dup.itemRef = this.itemRef;
        dup.blockRef = this.blockRef;
        dup.itemStack = this.itemStack;
        return dup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.nbt == null ? 0 : this.nbt.hashCode());
        result = 31 * result + (this.itemStack == null ? 0 : this.itemStack.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortableItemStack other = (PortableItemStack)obj;
        if (this.item == null ? other.item != null : !this.item.equals((Object)other.item)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.nbt == null ? other.nbt != null : !this.nbt.equals((Object)other.nbt)) {
            return false;
        }
        return !(this.itemStack == null ? other.itemStack != null : !this.itemStack.equals(other.itemStack));
    }
}

