/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverBehaviorBase;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.util.ForgeDirection;

public class CoverData {
    public PortableItemStack cover;
    public NBTBase coverData;
    public Integer tickRateAddition;
    private static final MethodHandle COVER_LOAD_FROM_NBT = MMUtils.exposeMethod(CoverBehaviorBase.class, MethodType.methodType(ISerializableObject.class, NBTBase.class), "loadFromNbt");

    public CoverData() {
    }

    public CoverData(PortableItemStack cover, NBTBase coverData, int tickRateAddition) {
        this.cover = cover;
        this.coverData = coverData;
        this.tickRateAddition = tickRateAddition == 0 ? null : Integer.valueOf(tickRateAddition);
    }

    public ItemStack getCoverStack() {
        return this.cover.toStack();
    }

    public ISerializableObject getCoverData(Cover cover) {
        return COVER_LOAD_FROM_NBT.invokeExact((CoverBehaviorBase)cover, this.coverData);
    }

    public CoverData clone() {
        CoverData dup = new CoverData();
        dup.cover = this.cover.clone();
        dup.coverData = this.coverData.func_74737_b();
        dup.tickRateAddition = this.tickRateAddition;
        return dup;
    }

    public static CoverData fromMachine(ICoverable coverable, ForgeDirection dir) {
        if (!coverable.hasCoverAtSide(dir)) {
            return null;
        }
        Cover cover = coverable.getCoverAtSide(dir);
        return new CoverData(PortableItemStack.withNBT(coverable.getCoverItemAtSide(dir)), cover.getCoverData().saveDataToNBT(), cover.getTickRateAddition());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cover == null ? 0 : this.cover.hashCode());
        result = 31 * result + (this.coverData == null ? 0 : this.coverData.hashCode());
        result = 31 * result + (this.tickRateAddition == null ? 0 : this.tickRateAddition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoverData other = (CoverData)obj;
        if (this.cover == null ? other.cover != null : !this.cover.equals(other.cover)) {
            return false;
        }
        if (this.coverData == null ? other.coverData != null : !this.coverData.equals((Object)other.coverData)) {
            return false;
        }
        return !(this.tickRateAddition == null ? other.tickRateAddition != null : !this.tickRateAddition.equals(other.tickRateAddition));
    }
}

