/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import dev.rndmorris.salisarcana.api.IVariableInfusionStabilizer;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.config.modules.EnhancementsModule;
import dev.rndmorris.salisarcana.config.settings.BlockItemListSetting;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import thaumcraft.api.crafting.IInfusionStabiliser;
import thaumcraft.common.tiles.TilePedestal;

public class InfusionMatrixLogic {
    static final int rangeHorizontal = 12;
    static final int rangeUp = 5;
    static final int rangeDown = 10;
    static final int pedestalRange = 8;

    public static MatrixSurroundingsResult checkMatrixSurroundings(World world, int x, int y, int z) {
        MatrixOrigin matrix = new MatrixOrigin(world, x, y, z);
        MatrixSurroundingsResult result = new MatrixSurroundingsResult();
        int stabilizerModifier = 0;
        for (int dX = -12; dX <= 12; ++dX) {
            for (int dZ = -12; dZ <= 12; ++dZ) {
                boolean pedestalInColumn = false;
                for (int dY = -5; dY <= 10; ++dY) {
                    if (dX == 0 && dZ == 0) continue;
                    if (!pedestalInColumn && InfusionMatrixLogic.checkForAndHandlePedestal(matrix, result, dX, dY, dZ)) {
                        pedestalInColumn = true;
                        continue;
                    }
                    stabilizerModifier += InfusionMatrixLogic.getStabilityModifierAt(matrix, dX, dY, dZ);
                }
            }
        }
        result.symmetry += stabilizerModifier / 100;
        return result;
    }

    public static boolean isStabilizer(World world, int x, int y, int z) {
        IInfusionStabiliser stabilizer;
        boolean isRegularStabilizer;
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        BlockItemListSetting<Integer> additions = ConfigModuleRoot.enhancements.stabilizerAdditions;
        if (additions.isEnabled() && additions.hasEntry(block, metadata)) {
            return true;
        }
        boolean bl = isRegularStabilizer = block == Blocks.field_150465_bP || block instanceof IInfusionStabiliser && (stabilizer = (IInfusionStabiliser)block).canStabaliseInfusion(world, x, y, z);
        if (!isRegularStabilizer) {
            return false;
        }
        BlockItemListSetting<Object> exclusions = ConfigModuleRoot.enhancements.stabilizerExclusions;
        return !exclusions.isEnabled() || !exclusions.hasEntry(block, metadata);
    }

    private static boolean checkForAndHandlePedestal(MatrixOrigin matrix, MatrixSurroundingsResult result, int dX, int dY, int dZ) {
        int[] twin;
        TileEntity tileEntity;
        boolean itemsInPair;
        if (Math.abs(dX) > 8 || Math.abs(dZ) > 8) {
            return false;
        }
        int x = matrix.xCoord + dX;
        int y = matrix.yCoord - dY;
        int z = matrix.zCoord + dZ;
        World world = matrix.world;
        TileEntity tileEntity2 = world.func_147438_o(x, y, z);
        if (!(tileEntity2 instanceof TilePedestal)) {
            return false;
        }
        TilePedestal pedestal = (TilePedestal)tileEntity2;
        result.pedestals.add(new ChunkCoordinates(x, y, z));
        result.symmetry += 2;
        boolean bl = itemsInPair = pedestal.func_70301_a(0) != null;
        if (itemsInPair) {
            ++result.symmetry;
        }
        if ((tileEntity = world.func_147438_o((twin = InfusionMatrixLogic.getTwinnedCoord(matrix, x, z))[0], y, twin[1])) instanceof TilePedestal) {
            TilePedestal twinPedestal = (TilePedestal)tileEntity;
            result.symmetry -= 2;
            if (itemsInPair && twinPedestal.func_70301_a(0) != null) {
                --result.symmetry;
            }
        }
        return true;
    }

    private static int getStabilityModifierAt(MatrixOrigin matrix, int dX, int dY, int dZ) {
        int x = matrix.xCoord + dX;
        int y = matrix.yCoord - dY;
        int z = matrix.zCoord + dZ;
        World world = matrix.world;
        if (!InfusionMatrixLogic.isStabilizer(world, x, y, z)) {
            return 0;
        }
        int strength = InfusionMatrixLogic.strengthForBlock(world, x, y, z);
        int[] twin = InfusionMatrixLogic.getTwinnedCoord(matrix, x, z);
        return InfusionMatrixLogic.isStabilizer(world, twin[0], y, twin[1]) ? strength * -1 : strength;
    }

    private static int strengthForBlock(World world, int x, int y, int z) {
        EnhancementsModule module = ConfigModuleRoot.enhancements;
        if (!module.stabilizerStrength.isEnabled()) {
            return module.stabilizerStrength.getDefaultValue();
        }
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        BlockItemListSetting.GetDataResult additionData = module.stabilizerAdditions.getData(block, metadata);
        if (additionData.containedKeys) {
            return additionData.data != null ? ((Integer)additionData.data).intValue() : module.stabilizerStrength.getValueOrDefault();
        }
        if (block instanceof IVariableInfusionStabilizer) {
            IVariableInfusionStabilizer stabilizer = (IVariableInfusionStabilizer)block;
            return stabilizer.getStabilizerStrength(world, x, y, z);
        }
        return module.stabilizerStrength.getValueOrDefault();
    }

    private static int[] getTwinnedCoord(MatrixOrigin matrix, int x, int z) {
        return new int[]{matrix.xCoord + (matrix.xCoord - x), matrix.zCoord + (matrix.zCoord - z)};
    }

    private static final class MatrixOrigin {
        private final World world;
        private final int xCoord;
        private final int yCoord;
        private final int zCoord;

        private MatrixOrigin(World world, int xCoord, int yCoord, int zCoord) {
            this.world = world;
            this.xCoord = xCoord;
            this.yCoord = yCoord;
            this.zCoord = zCoord;
        }

        public String toString() {
            return "MatrixOrigin[" + "world=" + this.world + "," + "xCoord=" + this.xCoord + "," + "yCoord=" + this.yCoord + "," + "zCoord=" + this.zCoord + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.world != null ? this.world.hashCode() : 0);
            result = 31 * result + this.xCoord;
            result = 31 * result + this.yCoord;
            result = 31 * result + this.zCoord;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((MatrixOrigin)arg0).world, this.world)) {
                return false;
            }
            if (((MatrixOrigin)arg0).xCoord != this.xCoord) {
                return false;
            }
            if (((MatrixOrigin)arg0).yCoord != this.yCoord) {
                return false;
            }
            return ((MatrixOrigin)arg0).zCoord == this.zCoord;
            {
            }
        }

        public World world() {
            return this.world;
        }

        public int xCoord() {
            return this.xCoord;
        }

        public int yCoord() {
            return this.yCoord;
        }

        public int zCoord() {
            return this.zCoord;
        }
    }

    public static class MatrixSurroundingsResult {
        public final ArrayList<ChunkCoordinates> pedestals = new ArrayList();
        public int symmetry = 0;
    }
}

