/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.settings;

import dev.rndmorris.salisarcana.config.IEnabler;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;

public abstract class Setting
implements IEnabler {
    public static final String defaultCategory = "general";
    @Nullable
    protected final WeakReference<IEnabler> dependencyRef;
    protected boolean enabled = true;
    @Nullable
    private String category;

    public Setting(IEnabler dependency) {
        this.dependencyRef = new WeakReference<IEnabler>(dependency);
    }

    public <T extends Setting> T setCategory(String category) {
        this.category = category;
        return (T)this;
    }

    public String getCategory() {
        if (this.category == null) {
            return defaultCategory;
        }
        return this.category;
    }

    @Override
    public boolean isEnabled() {
        if (!this.enabled) {
            return false;
        }
        if (this.dependencyRef == null) {
            return true;
        }
        IEnabler dependency = (IEnabler)this.dependencyRef.get();
        return dependency != null && dependency.isEnabled();
    }

    public <T extends Setting> T setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (T)this;
    }

    public abstract void loadFromConfiguration(Configuration var1);
}

