/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.settings;

import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.config.settings.Setting;
import net.minecraftforge.common.config.Configuration;

public class IntSetting
extends Setting {
    private final String name;
    private final String comment;
    private final int defaultValue;
    private int value;
    private int maxValue = Integer.MAX_VALUE;
    private int minValue = Integer.MIN_VALUE;

    public IntSetting(IEnabler dependency, String name, String comment, int defaultValue) {
        super(dependency);
        this.name = name;
        this.comment = comment;
        this.defaultValue = defaultValue;
    }

    @Override
    public void loadFromConfiguration(Configuration configuration) {
        this.value = configuration.getInt(this.name, this.getCategory(), this.defaultValue, this.minValue, this.maxValue, this.comment);
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueOrDefault() {
        return this.enabled ? this.value : this.defaultValue;
    }

    public IntSetting setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public IntSetting setMinValue(int minValue) {
        this.minValue = minValue;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.value != this.defaultValue && super.isEnabled();
    }
}

