/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.modules;

import dev.rndmorris.salisarcana.config.modules.BaseConfigModule;
import dev.rndmorris.salisarcana.config.settings.BeaconBlockFixSetting;
import dev.rndmorris.salisarcana.config.settings.Setting;
import dev.rndmorris.salisarcana.config.settings.ToggleSetting;
import javax.annotation.Nonnull;

public class BugfixesModule
extends BaseConfigModule {
    public final BeaconBlockFixSetting beaconBlockFixSetting;
    public final ToggleSetting candleRendererCrashes;
    public final ToggleSetting deadMobsDontAttack;
    public final ToggleSetting fixEFRRecipes;
    public final ToggleSetting infernalFurnaceDupeFix;
    public final ToggleSetting integerInfusionMatrixMath;
    public final ToggleSetting itemMetadataSafetyCheck;
    public final ToggleSetting itemShardColor;
    public final ToggleSetting warpFakePlayerCheck;
    public final ToggleSetting crimsonRitesFakePlayerCheck;
    public final ToggleSetting renderRedstoneFix;
    public final ToggleSetting slabBurnTimeFix;
    public final ToggleSetting strictInfusionMatrixInputChecks;
    public final ToggleSetting unOredictGoldCoin;
    public final ToggleSetting staffFocusEffectFix;
    public final ToggleSetting arcaneWorkbenchGhostItemFix;
    public final ToggleSetting arcaneWorkbenchAllowRechargeCrafting;
    public final ToggleSetting arcaneWorkbenchMultiContainer;
    public final ToggleSetting negativeBossSpawnCount;
    public final ToggleSetting useForgeFishingLists;
    public final ToggleSetting focalManipulatorForbidSwaps;

    public BugfixesModule() {
        Setting[] settingArray = new Setting[21];
        this.beaconBlockFixSetting = new BeaconBlockFixSetting(this);
        settingArray[0] = this.beaconBlockFixSetting;
        this.candleRendererCrashes = new ToggleSetting(this, "candleMetadataCrash", "Fixes several crashes with invalid candle metadata");
        settingArray[1] = this.candleRendererCrashes;
        this.deadMobsDontAttack = new ToggleSetting(this, "deadMobsDontAttack", "Prevents eldritch crabs, all taintacles, and thaumic slimes from attacking during their death animation.");
        settingArray[2] = this.deadMobsDontAttack;
        this.fixEFRRecipes = new ToggleSetting(this, "fixEFRRecipes", "Fixes several recipes to work with EFR versions of blocks, like trapdoors, if EFR is installed");
        settingArray[3] = this.fixEFRRecipes;
        this.infernalFurnaceDupeFix = new ToggleSetting(this, "infernalFurnaceDupeFix", "Fixes a smelting duplication glitch with the Infernal Furnace");
        settingArray[4] = this.infernalFurnaceDupeFix;
        this.integerInfusionMatrixMath = new ToggleSetting(this, "integerInfusionMatrixMath", "Calculate infusion stabilizers with integer math instead of floating-point math. This eliminates a rounding error that sometimes makes an infusion altar slightly less stable than it should be. Also corrects a logic error causing the Infusion Matrix to check the wrong coordinates for a symmetrical stabilizer.");
        settingArray[5] = this.integerInfusionMatrixMath;
        this.itemMetadataSafetyCheck = new ToggleSetting(this, "itemMetadataFix", "Add a safety check to several Thaumcraft items to prevent crashes when creating those items with invalid metadata.");
        settingArray[6] = this.itemMetadataSafetyCheck;
        this.itemShardColor = new ToggleSetting(this, "shardMetadataCrash", "Fixes a crash with invalid shard metadata");
        settingArray[7] = this.itemShardColor;
        this.warpFakePlayerCheck = new ToggleSetting(this, "warpFakePlayerCheck", "Adds a safety check to prevent warp effects from trying to send packets to fake players.");
        settingArray[8] = this.warpFakePlayerCheck;
        this.crimsonRitesFakePlayerCheck = new ToggleSetting(this, "crimsonRitesFakePlayerCheck", "Adds a safety check in case of a fake player not being castable to EntityPlayerMP.");
        settingArray[9] = this.crimsonRitesFakePlayerCheck;
        this.renderRedstoneFix = new ToggleSetting(this, "renderRedstoneFix", "Fixes an issue with ores where they don't get rendered as normal blocks, not allowing you to push a redstone signal through them.");
        settingArray[10] = this.renderRedstoneFix;
        this.slabBurnTimeFix = new ToggleSetting(this, "slabBurnTimeFix", "Reduce the burn time of Thaumcraft's greatwood and silverwood slabs to match that of Minecraft's wooden slabs.");
        settingArray[11] = this.slabBurnTimeFix;
        this.strictInfusionMatrixInputChecks = new ToggleSetting(this, "strictInfusionMatrixInputChecks", "Check the infusion matrix's center item more strictly. Prevents an exploit with infusion enchanting.");
        settingArray[12] = this.strictInfusionMatrixInputChecks;
        this.unOredictGoldCoin = (ToggleSetting)new ToggleSetting(this, "unOredictGoldCoin", "Remove gold coins from the gold nugget ore dictionary.").setEnabled(false);
        settingArray[13] = this.unOredictGoldCoin;
        this.staffFocusEffectFix = new ToggleSetting(this, "staffFocusEffectFix", "Fixes a graphical error where focus effects would appear below the tip of a staff.");
        settingArray[14] = this.staffFocusEffectFix;
        this.arcaneWorkbenchGhostItemFix = new ToggleSetting(this, "arcaneWorkbenchGhostItemFix", "Fixes ghost items being crafted in the arcane workbench after the wand runs out of vis during a shift-click craft.");
        settingArray[15] = this.arcaneWorkbenchGhostItemFix;
        this.arcaneWorkbenchAllowRechargeCrafting = new ToggleSetting(this, "arcaneWorkbenchAllowRechargeCrafting", "Allows players to craft after the wand in the GUI runs out of vis and is recharged by a Vis Charge Relay.");
        settingArray[16] = this.arcaneWorkbenchAllowRechargeCrafting;
        this.arcaneWorkbenchMultiContainer = new ToggleSetting(this, "arcaneWorkbenchMultiContainer", "Prevents bugs related to multiple players opening an Arcane Workbench's GUI at the same time.");
        settingArray[17] = this.arcaneWorkbenchMultiContainer;
        this.negativeBossSpawnCount = new ToggleSetting(this, "negativeBossSpawnCount", "Fixes a theoretical bug where, if billions of bosses were spawned, only the golem boss would be able to spawn.");
        settingArray[18] = this.negativeBossSpawnCount;
        this.useForgeFishingLists = new ToggleSetting(this, "useForgeFishingLists", "Use Forge's fishing lists to determine what a fishing golem catches.");
        settingArray[19] = this.useForgeFishingLists;
        this.focalManipulatorForbidSwaps = new ToggleSetting(this, "focalManipulatorForbidSwaps", "Prevents players from putting on conflicting or out-of-order upgrades onto a focus by swapping the focus being modified during the upgrade process.");
        settingArray[20] = this.focalManipulatorForbidSwaps;
        this.addSettings(settingArray);
    }

    @Override
    @Nonnull
    public String getModuleId() {
        return "bugfixes";
    }

    @Override
    @Nonnull
    public String getModuleComment() {
        return "Fixes for bugs in TC4";
    }
}

