/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.recipes;

import dev.rndmorris.salisarcana.api.IMultipleResearchArcaneRecipe;
import dev.rndmorris.salisarcana.common.CustomResearch;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.lib.AspectHelper;
import dev.rndmorris.salisarcana.lib.WandHelper;
import dev.rndmorris.salisarcana.lib.WandType;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ReplaceWandCoreRecipe
implements IArcaneRecipe,
IMultipleResearchArcaneRecipe {
    public boolean matches(IInventory tableInv, World world, EntityPlayer player) {
        if (!ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.getResearch())) {
            return false;
        }
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return false;
        }
        return ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)scanResult.newRod().getResearch());
    }

    public ItemStack getCraftingResult(IInventory tableInv) {
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return null;
        }
        ItemWandCasting wandInstance = scanResult.wandInstance();
        if (wandInstance == null) {
            return null;
        }
        ItemStack outputItem = scanResult.wandItem().func_77946_l();
        wandInstance.setRod(outputItem, scanResult.newRod());
        if (ConfigModuleRoot.enhancements.preserveWandVis.isEnabled()) {
            int maxVis = wandInstance.getMaxVis(outputItem);
            AspectList newVis = new AspectList();
            AspectList originalVis = wandInstance.getAllVis(outputItem);
            for (Map.Entry entry : originalVis.aspects.entrySet()) {
                newVis.add((Aspect)entry.getKey(), Integer.min(maxVis, (Integer)entry.getValue()));
            }
            wandInstance.storeAllVis(outputItem, newVis);
        } else {
            wandInstance.storeAllVis(outputItem, AspectHelper.primalList(0));
        }
        return outputItem;
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public AspectList getAspects() {
        return null;
    }

    public AspectList getAspects(IInventory tableInv) {
        AspectList empty = new AspectList();
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return null;
        }
        ItemWandCasting wandInstance = scanResult.wandInstance();
        if (wandInstance == null) {
            return null;
        }
        int cost = scanResult.wandType().getCraftingVisCost(scanResult.wandCaps(), scanResult.newRod());
        if (cost < 0) {
            return empty;
        }
        return AspectHelper.primalList(cost);
    }

    public String getResearch() {
        return CustomResearch.replaceCoreResearch.key;
    }

    @Nullable
    private InvScanResult scanTable(IInventory tableInv) {
        ItemStack wandItem = null;
        WandRod newRod = null;
        for (int slot = 0; slot < tableInv.func_70302_i_() && slot < 9; ++slot) {
            ItemStack slotItem = tableInv.func_70301_a(slot);
            WandRod maybeRod = WandHelper.getWandRodFromItem(slotItem);
            if (maybeRod != null) {
                if (newRod != null) {
                    return null;
                }
                newRod = maybeRod;
                continue;
            }
            ItemWandCasting maybeWand = WandHelper.getWandItem(slotItem);
            if (maybeWand != null) {
                if (wandItem != null) {
                    return null;
                }
                wandItem = slotItem;
                continue;
            }
            if (slotItem == null) continue;
            return null;
        }
        return new InvScanResult(wandItem, newRod);
    }

    @Override
    public String[] salisArcana$getResearches(IInventory inv, World world, EntityPlayer player) {
        InvScanResult scan = this.scanTable(inv);
        if (scan == null || scan.invalidInputs()) {
            return new String[]{this.getResearch()};
        }
        return new String[]{this.getResearch(), scan.newRod.getResearch()};
    }

    private static final class InvScanResult {
        private final ItemStack wandItem;
        private final WandRod newRod;

        private InvScanResult(ItemStack wandItem, WandRod newRod) {
            this.wandItem = wandItem;
            this.newRod = newRod;
        }

        public boolean invalidInputs() {
            if (this.wandItem == null) {
                return true;
            }
            if (ConfigModuleRoot.enhancements.enforceWandCoreTypes.isEnabled() && !this.wandType().isCoreSuitable(this.newRod)) {
                return true;
            }
            WandRod oldRod = this.oldRod();
            if (this.newRod == null || oldRod == null) {
                return true;
            }
            return this.newRod == oldRod;
        }

        @Nullable
        public WandCap wandCaps() {
            return WandHelper.getWandCapFromWand(this.wandItem);
        }

        @Nullable
        public ItemWandCasting wandInstance() {
            return WandHelper.getWandItem(this.wandItem);
        }

        @Nullable
        public WandRod oldRod() {
            return WandHelper.getWandRodFromWand(this.wandItem);
        }

        @Nonnull
        public WandType wandType() {
            return WandType.getWandType(this.wandItem);
        }

        public String toString() {
            return "InvScanResult[" + "wandItem=" + this.wandItem + "," + "newRod=" + this.newRod + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.wandItem != null ? this.wandItem.hashCode() : 0);
            result = 31 * result + (this.newRod != null ? this.newRod.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((InvScanResult)arg0).wandItem, this.wandItem)) {
                return false;
            }
            return Objects.equals(((InvScanResult)arg0).newRod, this.newRod);
            {
            }
        }

        public ItemStack wandItem() {
            return this.wandItem;
        }

        public WandRod newRod() {
            return this.newRod;
        }
    }
}

