/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.recipes;

import dev.rndmorris.salisarcana.api.IMultipleResearchArcaneRecipe;
import dev.rndmorris.salisarcana.common.CustomResearch;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.lib.AspectHelper;
import dev.rndmorris.salisarcana.lib.WandHelper;
import dev.rndmorris.salisarcana.lib.WandType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ReplaceWandCapsRecipe
implements IArcaneRecipe,
IMultipleResearchArcaneRecipe {
    public boolean matches(IInventory tableInv, World world, EntityPlayer player) {
        if (!ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.getResearch())) {
            return false;
        }
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return false;
        }
        return ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)scanResult.newCaps.getResearch());
    }

    public ItemStack getCraftingResult(IInventory tableInv) {
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return null;
        }
        ItemWandCasting wandInstance = scanResult.wandInstance();
        if (wandInstance == null) {
            return null;
        }
        ItemStack outputItem = scanResult.wandItem().func_77946_l();
        wandInstance.setCap(outputItem, scanResult.newCaps());
        if (!ConfigModuleRoot.enhancements.preserveWandVis.isEnabled()) {
            wandInstance.storeAllVis(outputItem, AspectHelper.primalList(0));
        }
        return outputItem;
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public AspectList getAspects() {
        return null;
    }

    public AspectList getAspects(IInventory tableInv) {
        AspectList empty = new AspectList();
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return null;
        }
        ItemWandCasting wandInstance = scanResult.wandInstance();
        if (wandInstance == null) {
            return null;
        }
        int cost = scanResult.wandType().getCraftingVisCost(scanResult.newCaps(), scanResult.wandRod());
        if (cost < 0) {
            return empty;
        }
        return AspectHelper.primalList(cost);
    }

    public String getResearch() {
        return CustomResearch.replaceCapsResearch.key;
    }

    @Nullable
    private InvScanResult scanTable(IInventory tableInv) {
        ItemStack wandItem = null;
        WandCap newCaps = null;
        int newCapsFound = 0;
        for (int slot = 0; slot < tableInv.func_70302_i_() && slot < 9; ++slot) {
            ItemStack slotItem = tableInv.func_70301_a(slot);
            WandCap maybeCap = WandHelper.getWandCapFromItem(slotItem);
            if (maybeCap != null) {
                if (newCaps == null) {
                    newCaps = maybeCap;
                }
                if (newCaps != maybeCap) {
                    return null;
                }
                ++newCapsFound;
                continue;
            }
            ItemWandCasting maybeWand = WandHelper.getWandItem(slotItem);
            if (maybeWand != null) {
                if (wandItem != null) {
                    return null;
                }
                wandItem = slotItem;
                continue;
            }
            if (slotItem == null) continue;
            return null;
        }
        return new InvScanResult(wandItem, newCaps, newCapsFound);
    }

    @Override
    public String[] salisArcana$getResearches(IInventory inv, World world, EntityPlayer player) {
        InvScanResult scanResult = this.scanTable(inv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return new String[]{this.getResearch()};
        }
        return new String[]{this.getResearch(), scanResult.newCaps.getResearch()};
    }

    private static final class InvScanResult {
        private final ItemStack wandItem;
        private final WandCap newCaps;
        private final int newCapsFound;

        private InvScanResult(ItemStack wandItem, WandCap newCaps, int newCapsFound) {
            this.wandItem = wandItem;
            this.newCaps = newCaps;
            this.newCapsFound = newCapsFound;
        }

        public boolean invalidInputs() {
            if (this.wandItem == null) {
                return true;
            }
            if (this.wandType().getRequiredCaps() != this.newCapsFound) {
                return true;
            }
            WandCap oldCaps = this.oldCaps();
            if (this.newCaps == null || oldCaps == null) {
                return true;
            }
            return this.newCaps == oldCaps;
        }

        @Nullable
        public WandCap oldCaps() {
            return WandHelper.getWandCapFromWand(this.wandItem);
        }

        @Nullable
        public ItemWandCasting wandInstance() {
            return WandHelper.getWandItem(this.wandItem);
        }

        @Nullable
        public WandRod wandRod() {
            return WandHelper.getWandRodFromWand(this.wandItem);
        }

        @Nonnull
        public WandType wandType() {
            return WandType.getWandType(this.wandItem);
        }

        public String toString() {
            return "InvScanResult[" + "wandItem=" + this.wandItem + "," + "newCaps=" + this.newCaps + "," + "newCapsFound=" + this.newCapsFound + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.wandItem != null ? this.wandItem.hashCode() : 0);
            result = 31 * result + (this.newCaps != null ? this.newCaps.hashCode() : 0);
            result = 31 * result + this.newCapsFound;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((InvScanResult)arg0).wandItem, this.wandItem)) {
                return false;
            }
            if (!Objects.equals(((InvScanResult)arg0).newCaps, this.newCaps)) {
                return false;
            }
            return ((InvScanResult)arg0).newCapsFound == this.newCapsFound;
            {
            }
        }

        public ItemStack wandItem() {
            return this.wandItem;
        }

        public WandCap newCaps() {
            return this.newCaps;
        }

        public int newCapsFound() {
            return this.newCapsFound;
        }
    }
}

