/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import cpw.mods.fml.common.registry.GameRegistry;
import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.CommandErrors;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.FlagArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IntHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.ItemHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.ResearchHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.flag.FlagHandler;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.lib.ArrayHelper;
import dev.rndmorris.salisarcana.lib.EnumHelper;
import dev.rndmorris.salisarcana.lib.ResearchHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;

public class PrerequisitesCommand
extends ArcanaCommandBase<Arguments> {
    private Map<String, List<CacheEntry>> recipeOutputCache;

    public PrerequisitesCommand() {
        super(ConfigModuleRoot.commands.prerequisites);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        this.buildOutputCache();
        IntHandler depthHandler = new IntHandler(-1, Integer.MAX_VALUE, 3);
        ItemHandler itemhandler = new ItemHandler(this.recipeOutputCache.keySet());
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{ResearchHandler.INSTANCE, FlagHandler.INSTANCE, depthHandler, itemhandler});
    }

    private void buildOutputCache() {
        this.recipeOutputCache = new TreeMap<String, List<CacheEntry>>();
        for (Object recipe : ThaumcraftApi.getCraftingRecipes()) {
            ItemStack recipeOutput;
            InfusionRecipe infusion;
            Object output;
            ItemStack recipeOutput2;
            if (recipe instanceof IArcaneRecipe) {
                IArcaneRecipe arcane = (IArcaneRecipe)recipe;
                recipeOutput2 = arcane.getRecipeOutput();
                if (recipeOutput2 == null || recipeOutput2.func_77973_b() == null) continue;
                this.addToCache(arcane.getResearch(), recipeOutput2);
                continue;
            }
            if (recipe instanceof CrucibleRecipe) {
                CrucibleRecipe crucible = (CrucibleRecipe)recipe;
                recipeOutput2 = crucible.getRecipeOutput();
                if (recipeOutput2 == null || recipeOutput2.func_77973_b() == null) continue;
                this.addToCache(crucible.key, recipeOutput2);
                continue;
            }
            if (!(recipe instanceof InfusionRecipe) || !((output = (infusion = (InfusionRecipe)recipe).getRecipeOutput()) instanceof ItemStack) || (recipeOutput = (ItemStack)output).func_77973_b() == null) continue;
            this.addToCache(infusion.getResearch(), recipeOutput);
        }
    }

    private void addToCache(String researchKey, ItemStack recipeOutput) {
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)recipeOutput.func_77973_b());
        if (id == null) {
            SalisArcana.LOG.error("Could not find unique id for item {}", new Object[]{recipeOutput.toString()});
            return;
        }
        String itemId = this.formatItemId(id);
        List<CacheEntry> cacheEntries = this.recipeOutputCache.get(itemId);
        if (cacheEntries == null) {
            cacheEntries = new ArrayList<CacheEntry>();
            this.recipeOutputCache.put(itemId, cacheEntries);
        }
        boolean needNewCacheEntry = true;
        for (CacheEntry entry : cacheEntries) {
            if (!entry.itemStack.func_77969_a(recipeOutput)) continue;
            entry.researchKeys.add(researchKey);
            needNewCacheEntry = false;
            break;
        }
        if (needNewCacheEntry) {
            cacheEntries.add(new CacheEntry(recipeOutput, researchKey));
        }
    }

    private String formatItemId(GameRegistry.UniqueIdentifier id) {
        return String.format("%s:%s", id.modId, id.name);
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        if (arguments.research != null) {
            this.sendPrereqsForResearch(sender, arguments.research, arguments.allResearch);
            return;
        }
        if (arguments.itemStack != null) {
            this.sendPrereqsForItem(sender, arguments.itemStack);
            return;
        }
        CommandErrors.invalidSyntax();
    }

    private void sendPrereqsForResearch(ICommandSender sender, @Nonnull ResearchItem research, boolean allResearch) {
        Set<String> playerKnowledge = this.getPlayerKnowledge(sender);
        boolean isKnown = playerKnowledge.contains(research.key);
        if (!allResearch && isKnown) {
            this.sendAlreadyKnown(sender, research);
            return;
        }
        sender.func_145747_a(new ChatComponentText("").func_150257_a(new ChatComponentTranslation("salisarcana:command.prereqs.header", new Object[0]).func_150255_a(this.color(EnumChatFormatting.LIGHT_PURPLE))).func_150258_a(" ").func_150257_a(ResearchHelper.formatResearch(research)));
        IChatComponent scanPrereqs = this.buildScanPrereqs(research);
        if (scanPrereqs != null) {
            sender.func_145747_a(scanPrereqs);
        }
        sender.func_145747_a(this.buildResearchMessage(research, allResearch, playerKnowledge));
    }

    private void sendPrereqsForItem(ICommandSender sender, ItemStack item) {
        TreeSet<String> matchingResearchKeys = this.findResearch(item);
        if (matchingResearchKeys.isEmpty()) {
            sender.func_145747_a(new ChatComponentTranslation("salisarcana:command.prereqs.item_not_found", new Object[]{item.func_151000_E()}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.BLUE)));
            return;
        }
        IChatComponent message = new ChatComponentText("").func_150257_a(new ChatComponentTranslation("salisarcana:command.prereqs.header_item", new Object[]{item.func_151000_E()}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.BLUE)));
        sender.func_145747_a(message);
        ChatComponentText listMessage = new ChatComponentText("");
        Iterator<String> keyIterator = matchingResearchKeys.iterator();
        while (keyIterator.hasNext()) {
            ResearchItem research = ResearchCategories.getResearch((String)keyIterator.next());
            listMessage.func_150257_a(ResearchHelper.formatResearchClickCommand(research));
            if (!keyIterator.hasNext()) continue;
            listMessage.func_150258_a(", ");
        }
        sender.func_145747_a((IChatComponent)listMessage);
    }

    private TreeSet<String> findResearch(ItemStack item) {
        TreeSet<String> foundResearch = new TreeSet<String>();
        GameRegistry.UniqueIdentifier itemUid = GameRegistry.findUniqueIdentifierFor((Item)item.func_77973_b());
        if (itemUid == null) {
            SalisArcana.LOG.error("Could not find unique id for item {}", new Object[]{item.toString()});
            return foundResearch;
        }
        String id = this.formatItemId(itemUid);
        List<CacheEntry> caches = this.recipeOutputCache.get(id);
        if (caches == null) {
            return foundResearch;
        }
        for (CacheEntry cache : caches) {
            if (!cache.itemStack.func_77969_a(item)) continue;
            foundResearch.addAll(cache.researchKeys);
        }
        return foundResearch;
    }

    private Set<String> getPlayerKnowledge(ICommandSender sender) {
        ArrayList knowledgeList = (ArrayList)Thaumcraft.proxy.getPlayerKnowledge().researchCompleted.get(sender.func_70005_c_());
        if (knowledgeList == null) {
            return Collections.emptySet();
        }
        return new TreeSet<String>(knowledgeList);
    }

    private void sendAlreadyKnown(ICommandSender sender, ResearchItem research) {
        ChatComponentTranslation message = new ChatComponentTranslation("salisarcana:command.prereqs.already_known", new Object[]{ResearchHelper.formatResearch(research)});
        message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_PURPLE));
        sender.func_145747_a((IChatComponent)message);
    }

    private IChatComponent buildScanPrereqs(ResearchItem research) {
        List<Aspect> aspectTriggers = ArrayHelper.toList(research.getAspectTriggers());
        List<String> entityTriggers = ArrayHelper.toList(research.getEntityTriggers());
        List<ItemStack> itemTriggers = ArrayHelper.toList(research.getItemTriggers());
        IChatComponent aspectsMessage = this.buildAspectsMessage(aspectTriggers);
        IChatComponent entitiesMessage = this.buildEntitiesMessage(entityTriggers);
        IChatComponent itemsMessage = this.buildItemsMessage(itemTriggers);
        if (aspectsMessage == null && entitiesMessage == null && itemsMessage == null) {
            return null;
        }
        IChatComponent message = new ChatComponentText("").func_150257_a(new ChatComponentTranslation("salisarcana:command.prereqs.triggers", new Object[0]).func_150255_a(this.blue())).func_150258_a(" ");
        IChatComponent lastMessage = null;
        if (aspectsMessage != null) {
            message.func_150257_a(aspectsMessage);
            lastMessage = aspectsMessage;
        }
        if (entitiesMessage != null) {
            if (lastMessage != null) {
                message.func_150257_a(this.orText());
            }
            message.func_150257_a(entitiesMessage);
            lastMessage = entitiesMessage;
        }
        if (itemsMessage != null) {
            if (lastMessage != null) {
                message.func_150257_a(this.orText());
            }
            message.func_150257_a(itemsMessage);
        }
        return message;
    }

    private IChatComponent orText() {
        return new ChatComponentText(" ").func_150257_a(new ChatComponentTranslation("salisarcana:command.prereqs.triggers_or", new Object[0]).func_150255_a(this.italicBlue())).func_150258_a(" ");
    }

    @Nullable
    private IChatComponent buildAspectsMessage(List<Aspect> aspectTriggers) {
        IChatComponent message = new ChatComponentText("").func_150257_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.prereqs.triggers_aspects", new Object[0])).func_150258_a(" ");
        boolean anyAspects = false;
        Iterator<Aspect> aspects$ = aspectTriggers.iterator();
        while (aspects$.hasNext()) {
            EnumChatFormatting color;
            Aspect aspect = aspects$.next();
            if (aspect == null) continue;
            anyAspects = true;
            ChatComponentText aspectChat = new ChatComponentText(String.format("[%s]", aspect.getName()));
            String aspectColor = aspect.getChatcolor();
            if (aspectColor != null && !aspectColor.isEmpty() && (color = EnumHelper.findByFormattingCode(aspectColor.charAt(0))) != null) {
                aspectChat.func_150255_a(new ChatStyle().func_150238_a(color));
            }
            message.func_150257_a((IChatComponent)aspectChat);
            if (!aspects$.hasNext()) continue;
            message.func_150258_a(", ");
        }
        return anyAspects ? message : null;
    }

    @Nullable
    private IChatComponent buildEntitiesMessage(List<String> entityTriggers) {
        IChatComponent message = new ChatComponentText("").func_150257_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.prereqs.triggers_entities", new Object[0])).func_150258_a(" ");
        boolean noEntities = true;
        Iterator<String> entities$ = entityTriggers.iterator();
        while (entities$.hasNext()) {
            String entity = entities$.next();
            if (entity == null) continue;
            noEntities = false;
            IChatComponent component = new ChatComponentText("[").func_150255_a(new ChatStyle().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(entity)))).func_150257_a((IChatComponent)new ChatComponentTranslation(String.format("entity.%s.name", entity), new Object[0])).func_150258_a("]");
            message.func_150257_a(component);
            if (!entities$.hasNext()) continue;
            message.func_150258_a(", ");
        }
        if (noEntities) {
            return null;
        }
        return message;
    }

    @Nullable
    private IChatComponent buildItemsMessage(List<ItemStack> itemTriggers) {
        IChatComponent message = new ChatComponentText("").func_150257_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.prereqs.triggers_items", new Object[0])).func_150258_a(" ");
        boolean noItems = true;
        Iterator<ItemStack> items$ = itemTriggers.iterator();
        while (items$.hasNext()) {
            ItemStack item = items$.next();
            if (item == null || item.func_77973_b() == null) continue;
            noItems = false;
            message.func_150257_a(item.func_151000_E());
            if (!items$.hasNext()) continue;
            message.func_150258_a(", ");
        }
        if (noItems) {
            return null;
        }
        return message;
    }

    @Nonnull
    private IChatComponent buildResearchMessage(ResearchItem research, boolean allResearch, Set<String> playerKnowledge) {
        TreeSet<String> visited = new TreeSet<String>();
        ArrayDeque<String> todo = new ArrayDeque<String>();
        visited.add(research.key);
        this.queueParents(research, visited, todo);
        IChatComponent message = null;
        while (!todo.isEmpty()) {
            String currentKey = todo.pop();
            visited.add(currentKey);
            if (!allResearch && playerKnowledge.contains(currentKey)) continue;
            ResearchItem currentResearch = ResearchCategories.getResearch((String)currentKey);
            IChatComponent researchText = ResearchHelper.formatResearchClickCommand(currentResearch, this.researchColor(playerKnowledge.contains(currentKey)));
            if (message != null) {
                message.func_150258_a(" ").func_150257_a(researchText);
            } else {
                message = researchText;
            }
            this.queueParents(currentResearch, visited, todo);
        }
        IChatComponent header = new ChatComponentText("").func_150257_a(new ChatComponentTranslation("salisarcana:command.prereqs.parents", new Object[0]).func_150255_a(this.blue())).func_150258_a(" ");
        if (message == null) {
            return header.func_150257_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.prereqs.parents_none", new Object[0]));
        }
        return header.func_150257_a(message);
    }

    private void queueParents(ResearchItem research, Set<String> visited, Deque<String> todo) {
        if (research.parents != null) {
            Arrays.stream(research.parents).filter(p -> !visited.contains(p)).forEach(p -> {
                visited.add((String)p);
                todo.add((String)p);
            });
        }
        if (research.parentsHidden != null) {
            Arrays.stream(research.parentsHidden).filter(p -> !visited.contains(p)).forEach(p -> {
                visited.add((String)p);
                todo.add((String)p);
            });
        }
    }

    private EnumChatFormatting researchColor(boolean isKnown) {
        return isKnown ? EnumChatFormatting.DARK_PURPLE : EnumChatFormatting.DARK_RED;
    }

    private ChatStyle color(EnumChatFormatting color) {
        return new ChatStyle().func_150238_a(color);
    }

    private ChatStyle blue() {
        return this.color(EnumChatFormatting.BLUE);
    }

    private ChatStyle italicBlue() {
        return this.blue().func_150217_b(Boolean.valueOf(true));
    }

    @Override
    protected int minimumRequiredArgs() {
        return 1;
    }

    public static class Arguments {
        @NamedArg(name="--research", excludes={"--item"}, handler=ResearchHandler.class, descLangKey="research")
        public ResearchItem research;
        @FlagArg(name="--completed", excludes={"--item"}, descLangKey="all")
        public boolean allResearch;
        @NamedArg(name="--item", handler=ItemHandler.class, excludes={"--research", "--completed"}, descLangKey="item")
        public ItemStack itemStack;
    }

    private static class CacheEntry {
        public final ItemStack itemStack;
        public final Set<String> researchKeys = new TreeSet<String>();

        public CacheEntry(@Nonnull ItemStack item, String firstKey) {
            this.itemStack = item;
            this.researchKeys.add(firstKey);
        }
    }
}

