/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.CoordinateArgument;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.PositionalArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.CoordinateHandler;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.lib.InfusionMatrixLogic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import thaumcraft.common.tiles.TileInfusionMatrix;

public class InfusionSymmetryCommand
extends ArcanaCommandBase<Arguments> {
    public InfusionSymmetryCommand() {
        super(ConfigModuleRoot.commands.infusionSymmetry);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{CoordinateHandler.INSTANCE});
    }

    @Override
    protected int minimumRequiredArgs() {
        return 0;
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        TileInfusionMatrix matrix;
        EntityPlayerMP player = InfusionSymmetryCommand.func_71521_c((ICommandSender)sender);
        if (arguments.coordinates != null) {
            matrix = this.getFromCoordinates(player.func_130014_f_(), arguments.coordinates);
            if (matrix == null) {
                throw new CommandException("salisarrcana:command.infusion-symmetry.not_found_coords", new Object[0]);
            }
        } else {
            matrix = this.getNearest((EntityPlayer)player);
            if (matrix == null) {
                throw new CommandException("salisarrcana:command.infusion-symmetry.not_found_nearby", new Object[0]);
            }
        }
        int symmetry = this.getMatrixSymmetry(matrix);
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarrcana:command.infusion-symmetry.found", new Object[]{-symmetry}));
    }

    @Nullable
    private TileInfusionMatrix getFromCoordinates(@Nonnull World world, @Nonnull CoordinateArgument coords) {
        TileInfusionMatrix matrix;
        TileEntity tile = world.func_147438_o(coords.x, coords.y, coords.z);
        return tile instanceof TileInfusionMatrix ? (matrix = (TileInfusionMatrix)tile) : null;
    }

    @Nullable
    private TileInfusionMatrix getNearest(@Nonnull EntityPlayer player) {
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        double nearestDist = Double.MAX_VALUE;
        TileInfusionMatrix nearest = null;
        for (TileEntity tile : player.field_70170_p.field_147482_g) {
            TileInfusionMatrix matrix;
            double dist;
            if (!(tile instanceof TileInfusionMatrix) || !((dist = (matrix = (TileInfusionMatrix)tile).func_145835_a(x, y, z)) <= 64.0) || !(dist < nearestDist)) continue;
            nearestDist = dist;
            nearest = matrix;
        }
        return nearest;
    }

    private int getMatrixSymmetry(TileInfusionMatrix matrix) {
        return InfusionMatrixLogic.checkMatrixSurroundings((World)matrix.func_145831_w(), (int)matrix.field_145851_c, (int)matrix.field_145848_d, (int)matrix.field_145849_e).symmetry;
    }

    public static class Arguments {
        @PositionalArg(index=0, handler=CoordinateHandler.class, descLangKey="coord")
        public CoordinateArgument coordinates;
    }
}

