/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.FlagArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.flag.FlagHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.AspectHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.PlayerHandler;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.PlayerKnowledge;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.BlockUtils;

public class ForgetScannedCommand
extends ArcanaCommandBase<Arguments> {
    public ForgetScannedCommand() {
        super(ConfigModuleRoot.commands.forgetScanned);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{PlayerHandler.INSTANCE, FlagHandler.INSTANCE, AspectHandler.INSTANCE});
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        MovingObjectPosition target;
        if (arguments.targetPlayer == null) {
            arguments.targetPlayer = ForgetScannedCommand.func_71521_c((ICommandSender)sender);
        }
        PlayerKnowledge playerKnowledge = Thaumcraft.proxy.getPlayerKnowledge();
        ArrayList<Map<String, ArrayList<String>>> toClear = new ArrayList<Map<String, ArrayList<String>>>(3);
        int removedCount = 0;
        if (arguments.hand && this.forgetSingle(sender, arguments.targetPlayer.func_70694_bm())) {
            ++removedCount;
        }
        if (arguments.inventory) {
            InventoryPlayer inventory = arguments.targetPlayer.field_71071_by;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!this.forgetSingle(sender, inventory.func_70301_a(i))) continue;
                ++removedCount;
            }
        }
        if (arguments.looking) {
            ItemStack item;
            target = this.getLookingAt((EntityPlayer)arguments.targetPlayer);
            Block block = arguments.targetPlayer.field_70170_p.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
            if (block != null && this.forgetSingle(sender, item = new ItemStack(block, 1, arguments.targetPlayer.field_70170_p.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d)))) {
                ++removedCount;
            }
        }
        if (arguments.container) {
            target = this.getLookingAt((EntityPlayer)arguments.targetPlayer);
            TileEntity tile = arguments.targetPlayer.field_70170_p.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
            if (tile instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (!this.forgetSingle(sender, inventory.func_70301_a(i))) continue;
                    ++removedCount;
                }
            }
        }
        if (arguments.all || arguments.objects) {
            toClear.add(playerKnowledge.objectsScanned);
        }
        if (arguments.all || arguments.entities) {
            toClear.add(playerKnowledge.entitiesScanned);
        }
        if (arguments.all || arguments.nodes) {
            toClear.add(playerKnowledge.phenomenaScanned);
        }
        String playerName = arguments.targetPlayer.func_70005_c_();
        if (!toClear.isEmpty()) {
            removedCount = this.forget(playerName, toClear);
        }
        if (removedCount > 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.forget-scanned.success", new Object[]{removedCount, playerName}));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.forget-scanned.failure", new Object[]{playerName}));
        }
    }

    private int forget(String playerName, List<Map<String, ArrayList<String>>> toClear) {
        int count = 0;
        for (Map<String, ArrayList<String>> map : toClear) {
            ArrayList<String> list;
            if (map == null || (list = map.get(playerName)) == null) continue;
            count += list.size();
            list.clear();
        }
        return count;
    }

    private boolean forgetSingle(ICommandSender sender, ItemStack item) {
        if (item == null) {
            return false;
        }
        PlayerKnowledge playerKnowledge = Thaumcraft.proxy.getPlayerKnowledge();
        String playerName = sender.func_70005_c_();
        ArrayList objectsScanned = (ArrayList)playerKnowledge.objectsScanned.get(playerName);
        String key = "@" + ScanManager.generateItemHash((Item)item.func_77973_b(), (int)item.func_77960_j());
        return objectsScanned != null && objectsScanned.remove(key);
    }

    private MovingObjectPosition getLookingAt(EntityPlayer player) {
        return BlockUtils.getTargetBlock((World)player.field_70170_p, (Entity)player, (boolean)false);
    }

    @Override
    protected int minimumRequiredArgs() {
        return 1;
    }

    public static class Arguments {
        @NamedArg(name="--player", handler=PlayerHandler.class, descLangKey="player")
        public EntityPlayerMP targetPlayer;
        @FlagArg(name="--objects", excludes={"--all"}, descLangKey="objects")
        public boolean objects;
        @FlagArg(name="--entities", excludes={"--all"}, descLangKey="entities")
        public boolean entities;
        @FlagArg(name="--nodes", excludes={"--all"}, descLangKey="nodes")
        public boolean nodes;
        @FlagArg(name="--all", excludes={"--objects", "--entities", "--nodes"}, descLangKey="all")
        public boolean all;
        @FlagArg(name="--hand", excludes={"--all"}, descLangKey="hand")
        public boolean hand;
        @FlagArg(name="--inventory", excludes={"--all"}, descLangKey="research")
        public boolean inventory;
        @FlagArg(name="--looking", excludes={"--all"}, descLangKey="looking")
        public boolean looking;
        @FlagArg(name="--container", excludes={"--all"}, descLangKey="container")
        public boolean container;
    }
}

