/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.FlagArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.flag.FlagHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.AspectHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.PlayerHandler;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.PlayerKnowledge;

public class ForgetAspectCommand
extends ArcanaCommandBase<Arguments> {
    public ForgetAspectCommand() {
        super(ConfigModuleRoot.commands.forgetAspects);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{AspectHandler.INSTANCE, FlagHandler.INSTANCE, PlayerHandler.INSTANCE});
    }

    @Override
    protected int minimumRequiredArgs() {
        return 2;
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        if (arguments.targetPlayer == null) {
            arguments.targetPlayer = ForgetAspectCommand.func_71521_c((ICommandSender)sender);
        }
        if (!arguments.reset && !arguments.forget) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.forget-aspect.no-action", new Object[0]));
            return;
        }
        PlayerKnowledge playerKnowledge = Thaumcraft.proxy.getPlayerKnowledge();
        int removedCount = 0;
        AspectList playerAspects = (AspectList)playerKnowledge.aspectsDiscovered.get(arguments.targetPlayer.func_70005_c_());
        if (playerAspects != null) {
            if (arguments.reset) {
                removedCount = this.resetAspects(playerAspects, arguments);
            } else if (arguments.forget) {
                removedCount = this.forgetAspects(playerAspects, arguments);
            }
        }
        String playerName = arguments.targetPlayer.func_70005_c_();
        if (removedCount > 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.forget-aspect.success", new Object[]{removedCount, playerName}));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.forget-aspect.failure", new Object[]{playerName}));
        }
    }

    private int resetAspects(AspectList aspects, Arguments arguments) {
        int removedCount;
        block3: {
            block2: {
                removedCount = 0;
                if (!arguments.all) break block2;
                for (Aspect aspect : aspects.getAspects()) {
                    aspects.aspects.put(aspect, 1);
                    ++removedCount;
                }
                break block3;
            }
            if (arguments.aspects == null || arguments.aspects.isEmpty()) break block3;
            for (Aspect aspect : arguments.aspects) {
                aspects.aspects.put(aspect, 1);
                ++removedCount;
            }
        }
        return removedCount;
    }

    private int forgetAspects(AspectList aspects, Arguments arguments) {
        int removedCount = 0;
        if (arguments.all) {
            removedCount = Math.max(aspects.size() - Aspect.getPrimalAspects().size(), 0);
            aspects.aspects.clear();
        } else if (arguments.aspects != null && !arguments.aspects.isEmpty()) {
            for (Aspect aspect : arguments.aspects) {
                if (aspects.aspects.remove(aspect) == null) continue;
                ++removedCount;
            }
        }
        return removedCount;
    }

    public static class Arguments {
        @NamedArg(name="--player", handler=PlayerHandler.class, descLangKey="player")
        public EntityPlayerMP targetPlayer;
        @FlagArg(name="--all", excludes={"--aspect"}, descLangKey="all")
        public boolean all;
        @NamedArg(name="--aspect", handler=AspectHandler.class, descLangKey="aspect", excludes={"--all"})
        public ArrayList<Aspect> aspects;
        @FlagArg(name="--reset", descLangKey="reset", excludes={"--forget"})
        public boolean reset;
        @FlagArg(name="--forget", descLangKey="forget", excludes={"--reset"})
        public boolean forget;
    }
}

