/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.CustomResearch;
import dev.rndmorris.salisarcana.common.DisenchantFocusUpgrade;
import dev.rndmorris.salisarcana.common.blocks.CustomBlocks;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.CreateNodeCommand;
import dev.rndmorris.salisarcana.common.commands.ForgetAspectCommand;
import dev.rndmorris.salisarcana.common.commands.ForgetResearchCommand;
import dev.rndmorris.salisarcana.common.commands.ForgetScannedCommand;
import dev.rndmorris.salisarcana.common.commands.HelpCommand;
import dev.rndmorris.salisarcana.common.commands.InfusionSymmetryCommand;
import dev.rndmorris.salisarcana.common.commands.ListResearchCommand;
import dev.rndmorris.salisarcana.common.commands.PrerequisitesCommand;
import dev.rndmorris.salisarcana.common.commands.UpdateNodeCommand;
import dev.rndmorris.salisarcana.common.commands.UpgradeFocusCommand;
import dev.rndmorris.salisarcana.common.compat.ModCompat;
import dev.rndmorris.salisarcana.common.item.PlaceholderItem;
import dev.rndmorris.salisarcana.common.recipes.CustomRecipes;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.config.settings.CommandSettings;
import dev.rndmorris.salisarcana.lib.R;
import dev.rndmorris.salisarcana.lib.ResearchHelper;
import dev.rndmorris.salisarcana.network.NetworkHandler;
import dev.rndmorris.salisarcana.notifications.StartupNotifications;
import dev.rndmorris.salisarcana.notifications.Updater;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.FishingHooks;
import thaumcraft.common.entities.ai.interact.AIFish;

public class CommonProxy {
    public CommonProxy() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (ConfigModuleRoot.enhancements.enableFocusDisenchanting.isEnabled()) {
            DisenchantFocusUpgrade.initialize();
        }
        CustomBlocks.registerBlocks();
        PlaceholderItem.registerPlaceholders();
        if (ConfigModuleRoot.bugfixes.useForgeFishingLists.isEnabled()) {
            this.fixGolemFishingLists();
        }
        FMLCommonHandler.instance().bus().register((Object)new Updater());
        FMLCommonHandler.instance().bus().register((Object)new StartupNotifications());
    }

    public void init(FMLInitializationEvent event) {
        ModCompat.init();
        CustomRecipes.registerRecipes();
        NetworkHandler.init();
    }

    public void postInit(FMLPostInitializationEvent event) {
        CustomRecipes.registerRecipesPostInit();
        CustomResearch.init();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        ResearchHelper.resetKnowItAll();
        this.maybeRegister(event, ConfigModuleRoot.commands.createNode, CreateNodeCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.forgetResearch, ForgetResearchCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.forgetScanned, ForgetScannedCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.forgetAspects, ForgetAspectCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.help, HelpCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.infusionSymmetry, InfusionSymmetryCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.prerequisites, PrerequisitesCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.playerResearch, ListResearchCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.updateNode, UpdateNodeCommand::new);
        this.maybeRegister(event, ConfigModuleRoot.commands.upgradeFocus, UpgradeFocusCommand::new);
    }

    private void maybeRegister(FMLServerStartingEvent event, CommandSettings settings, Supplier<ArcanaCommandBase<?>> init) {
        if (settings.isEnabled()) {
            event.registerServerCommand((ICommand)init.get());
        }
    }

    public boolean isSingleplayerClient() {
        return false;
    }

    private void fixGolemFishingLists() {
        try {
            R fishingHooks = new R(FishingHooks.class);
            R aiFish = new R(AIFish.class);
            aiFish.set("LOOTCRAP", fishingHooks.get("junk", ArrayList.class));
            aiFish.set("LOOTRARE", fishingHooks.get("treasure", ArrayList.class));
            aiFish.set("LOOTFISH", fishingHooks.get("fish", ArrayList.class));
        }
        catch (RuntimeException e) {
            SalisArcana.LOG.error("An error occurred updating golem fishing lists.", (Throwable)e);
        }
    }
}

