/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.mixin.interfaces.accessors.EntityPlayerMPAccessor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import tectech.mechanics.dataTransport.DataPacket;
import tectech.mechanics.pipe.IConnectsToDataPipe;

public abstract class MTEHatchDataConnector<T extends DataPacket<?>>
extends MTEHatch
implements IConnectsToDataPipe {
    public static Textures.BlockIcons.CustomIcon EM_D_SIDES;
    public static Textures.BlockIcons.CustomIcon EM_D_ACTIVE;
    public static Textures.BlockIcons.CustomIcon EM_D_CONN;
    private String clientLocale = "en_US";
    public T q;
    public short id = (short)-1;

    protected MTEHatchDataConnector(int aID, String aName, String aNameRegional, int aTier, String[] descr) {
        super(aID, aName, aNameRegional, aTier, 0, descr, new ITexture[0]);
    }

    protected MTEHatchDataConnector(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        EM_D_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_D_ACTIVE");
        EM_D_SIDES = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_D_SIDES");
        EM_D_CONN = new Textures.BlockIcons.CustomIcon("iconsets/EM_DATA_CONN");
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(EM_D_ACTIVE, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(EM_D_CONN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(EM_D_SIDES, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(EM_D_CONN)};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74777_a("eID", this.id);
        if (this.q != null) {
            aNBT.func_74782_a("eDATA", (NBTBase)((DataPacket)this.q).toNbt());
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.id = aNBT.func_74765_d("eID");
        if (aNBT.func_74764_b("eDATA")) {
            this.q = this.loadPacketFromNBT(aNBT.func_74775_l("eDATA"));
        }
    }

    protected abstract T loadPacketFromNBT(NBTTagCompound var1);

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && 4L == aTick % 20L) {
            if (this.q == null) {
                this.getBaseMetaTileEntity().setActive(false);
                this.resetHistory();
            } else {
                this.getBaseMetaTileEntity().setActive(true);
                this.moveAround(aBaseMetaTileEntity);
            }
        }
    }

    public abstract void moveAround(IGregTechTileEntity var1);

    protected void resetHistory() {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aPlayer instanceof EntityPlayerMPAccessor) {
            this.clientLocale = ((EntityPlayerMPAccessor)aPlayer).gt5u$getTranslator();
        }
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (this.id > 0) {
            return new String[]{StatCollector.func_74837_a((String)"tt.keyword.ID", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.id, StatCollector.func_74837_a((String)"tt.keyword.Content", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + (this.q != null ? ((DataPacket)this.q).getContentString() : Integer.valueOf(0)), StatCollector.func_74837_a((String)"tt.keyword.PacketHistory", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + (this.q != null ? ((DataPacket)this.q).getTraceSize() : 0)};
        }
        return new String[]{StatCollector.func_74837_a((String)"tt.keyword.Content", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + (this.q != null ? ((DataPacket)this.q).getContentString() : Integer.valueOf(0)), StatCollector.func_74837_a((String)"tt.keyword.PacketHistory", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + (this.q != null ? ((DataPacket)this.q).getTraceSize() : 0)};
    }

    @Override
    public byte getColorization() {
        return this.getBaseMetaTileEntity().getColorization();
    }
}

