/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.hatch;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gtnhlanth.common.beamline.BeamInformation;
import gtnhlanth.common.beamline.BeamLinePacket;
import gtnhlanth.common.beamline.IConnectsToBeamline;
import gtnhlanth.common.hatch.MTEHatchBeamlineConnector;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchInputBeamline
extends MTEHatchBeamlineConnector<BeamLinePacket> {
    private boolean delay = true;
    private static final String activeIconPath = "iconsets/OVERLAY_BI_ACTIVE";
    private static final String sideIconPath = "iconsets/OVERLAY_BI_SIDES";
    private static final String connIconPath = "iconsets/BI_CONN";
    private static final Textures.BlockIcons.CustomIcon activeIcon = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_BI_ACTIVE");
    private static final Textures.BlockIcons.CustomIcon sideIcon = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_BI_SIDES");
    private static final Textures.BlockIcons.CustomIcon connIcon = new Textures.BlockIcons.CustomIcon("iconsets/BI_CONN");

    public MTEHatchInputBeamline(int id, String name, String nameRegional, int tier) {
        super(id, name, nameRegional, tier, "");
    }

    public MTEHatchInputBeamline(String name, int tier, String[] desc, ITexture[][][] textures) {
        super(name, tier, desc, textures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(activeIcon, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(connIcon)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(sideIcon, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(connIcon)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity tile) {
        return new MTEHatchInputBeamline(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected BeamLinePacket loadPacketFromNBT(NBTTagCompound tag) {
        return new BeamLinePacket(tag);
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public boolean isOutputFacing(ForgeDirection aSide) {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public IConnectsToBeamline getNext(IConnectsToBeamline source) {
        return null;
    }

    @Override
    public String[] getDescription() {
        return null;
    }

    public void setContents(BeamLinePacket in) {
        if (in == null) {
            this.q = null;
        } else if (((BeamInformation)in.getContent()).getRate() > 0) {
            this.q = in;
            this.delay = true;
        } else {
            this.q = null;
        }
    }

    @Override
    public void moveAround(IGregTechTileEntity tile) {
        if (this.delay) {
            this.delay = false;
        } else {
            this.setContents(null);
        }
    }
}

