/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TurbineStatCalculator;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.MTELargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTELargeTurbineSCSteam
extends MTELargerTurbineBase {
    private boolean hasConsumedSteam;
    private boolean isUsingDenseSteam;

    public MTELargeTurbineSCSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbineSCSteam(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeTurbineSCSteam(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 15;
    }

    @Override
    public int getCasingTextureIndex() {
        return 1538;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        return 0;
    }

    @Override
    long fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        float denseFlow = 0.0f;
        float steamFlowForNextSteam = 0.0f;
        int steamInHatch = 0;
        this.realOptFlow = (float)this.getSpeedMultiplier() * (this.looseFit ? turbine.getOptimalLooseSteamFlow() : turbine.getOptimalSteamFlow());
        int remainingFlow = MathUtils.safeInt((long)(this.realOptFlow * 1.25));
        float remainingDenseFlow = 0.0f;
        this.storedFluid = 0;
        FluidStack tSCSteam = FluidRegistry.getFluidStack((String)"supercriticalsteam", (int)1);
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            String fluidName = aFluids.get(i).getFluid().getUnlocalizedName(aFluids.get(i));
            if (GTUtility.areFluidsEqual(aFluids.get(i), tSCSteam, true)) {
                if (!this.hasConsumedSteam) {
                    this.hasConsumedSteam = true;
                    this.isUsingDenseSteam = false;
                } else if (this.isUsingDenseSteam) continue;
                flow = Math.min(aFluids.get((int)i).amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluids.get(i), flow));
                this.storedFluid += aFluids.get((int)i).amount;
                remainingFlow -= flow;
                totalFlow += flow;
                continue;
            }
            if (!fluidName.equals("fluid.densesupercriticalsteam")) continue;
            if (!this.hasConsumedSteam) {
                this.hasConsumedSteam = true;
                this.isUsingDenseSteam = true;
            } else if (!this.isUsingDenseSteam) continue;
            steamInHatch = aFluids.get((int)i).amount;
            remainingDenseFlow = (float)remainingFlow / 1000.0f;
            denseFlow = Math.min((float)steamInHatch, remainingDenseFlow);
            this.depleteInput(new FluidStack(aFluids.get(i), (int)denseFlow));
            this.storedFluid += aFluids.get((int)i).amount;
            remainingFlow = (int)((float)remainingFlow - denseFlow * 1000.0f);
            totalFlow = (int)((float)totalFlow + denseFlow * 1000.0f);
            steamFlowForNextSteam += denseFlow;
        }
        if (totalFlow <= 0) {
            return 0L;
        }
        tEU = totalFlow;
        if (this.isUsingDenseSteam) {
            this.addOutput(Materials.DenseSuperheatedSteam.getGas((long)steamFlowForNextSteam));
        } else {
            this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)totalFlow));
        }
        if ((double)totalFlow != this.realOptFlow) {
            float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)this.realOptFlow) / (float)this.realOptFlow);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, MathUtils.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency()))));
        } else {
            tEU = MathUtils.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency())));
        }
        return tEU;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && GTPPCore.RANDOM.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public String getMachineType() {
        return "Large Supercritical Steam Turbine, XLSCT";
    }

    @Override
    protected String getTurbineType() {
        return "Supercritical Steam";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced SC Turbine Casing";
    }

    @Override
    protected boolean isDenseSteam() {
        return this.isUsingDenseSteam;
    }
}

