/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.MultiblockTooltipBuilder;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class MTESteamgate
extends MTEEnhancedMultiBlockBase<MTESteamgate>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    MTESteamgate linkedGate;

    public MTESteamgate(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTESteamgate(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamgate(this.mName);
    }

    @Override
    protected boolean explodesImmediately() {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        ITexture[] rTexture = side == facing ? new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.STEAMGATE_CASING).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_STEAMGATE_CONTROLLER).extFacing().glow().build()} : new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.STEAMGATE_CASING).build()};
        return rTexture;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 8, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 4, 8, 0, elementBudget, env, false, true);
    }

    @Override
    public IStructureDefinition<MTESteamgate> getStructureDefinition() {
        return StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"  AABAA  "}, {" BA   AB "}, {"AA     AA"}, {"A       A"}, {"B       B"}, {"A       A"}, {"AA     AA"}, {" BA   AB "}, {"  AA~AA  "}})).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)0)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)1)).build();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Impossible machine.").addInfo("Must be linked to another steamgate with a Steamgate Dialing Device.").addInfo("Left click to save steamgate data. Right click to link to another steamgate.").addInfo("Right click a linked steamgate to teleport.").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 8, 0);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        if (!this.mMachine) {
            return;
        }
        ItemStack device = aPlayer.field_71071_by.func_70448_g();
        if (ItemList.Steamgate_Dialing_Device.isStackEqual(device, false, true)) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("type", "SteamgateLinker");
            tag.func_74768_a("x", aBaseMetaTileEntity.getXCoord());
            tag.func_74768_a("y", (int)aBaseMetaTileEntity.getYCoord());
            tag.func_74768_a("z", aBaseMetaTileEntity.getZCoord());
            device.field_77990_d = tag;
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Saved Steamgate Dialing Data"));
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!this.mMachine) {
            return false;
        }
        if (this.linkedGate == null) {
            this.tryLinkDataStick(aPlayer);
        } else {
            BaseMetaTileEntity gate = (BaseMetaTileEntity)this.linkedGate.getBaseMetaTileEntity();
            aPlayer.func_70634_a((double)gate.getXCoord(), (double)(gate.getYCoord() + 2), (double)gate.getZCoord());
        }
        return true;
    }

    private void tryLinkDataStick(EntityPlayer aPlayer) {
        int z;
        int y;
        ItemStack device = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Steamgate_Dialing_Device.isStackEqual(device, false, true)) {
            return;
        }
        if (!device.func_77942_o() || !device.field_77990_d.func_74779_i("type").equals("SteamgateLinker")) {
            return;
        }
        NBTTagCompound nbt = device.field_77990_d;
        int x = nbt.func_74762_e("x");
        boolean result = this.trySetControllerFromCoord(x, y = nbt.func_74762_e("y"), z = nbt.func_74762_e("z"));
        if (result) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Steamgate dialed successfully"));
        } else {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Steamgate could not be dialed"));
        }
    }

    private boolean trySetControllerFromCoord(int x, int y, int z) {
        TileEntity tileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        if (!(tileEntity instanceof IGregTechTileEntity)) {
            return false;
        }
        IGregTechTileEntity gtTileEntity = (IGregTechTileEntity)tileEntity;
        IMetaTileEntity metaTileEntity = gtTileEntity.getMetaTileEntity();
        if (!(metaTileEntity instanceof MTESteamgate)) {
            return false;
        }
        if (metaTileEntity == this) {
            return false;
        }
        if (this.linkedGate != null) {
            this.linkedGate.linkedGate = null;
        }
        this.linkedGate = (MTESteamgate)metaTileEntity;
        this.linkedGate.linkedGate = this;
        return true;
    }
}

