/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESteamMegaWasher
extends MTESteamMultiBase<MTESteamMegaWasher>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private int casingTier = -1;
    private int tierPipeCasing = -1;
    private int casingAmount = 0;
    private static final IStructureDefinition<MTESteamMegaWasher> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"             ", "             ", "AAAAA   AAAAA", "AAAAA   AAAAA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "AAAAA   AAAAA", "AAAAA   AAAAA", "AAAAA   AAAAA"}, {"     AAA     ", "     AAA     ", "     A~A     ", "  B  AAA  B  ", "     AAA     "}, {"     AAA     ", "     A A     ", "     A A     ", "  BBBA ABBB  ", "     AAA     "}, {"     AAA     ", "     AAA     ", "     AAA     ", "  B  AAA  B  ", "     AAA     "}, {"             ", "             ", "AAAAA   AAAAA", "AAAAA   AAAAA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "A   A   A   A", "ACCCA   ACCCA", "AAAAA   AAAAA"}, {"             ", "             ", "AAAAA   AAAAA", "AAAAA   AAAAA", "AAAAA   AAAAA"}}).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamMegaWasher.buildSteamInput(MTESteamMegaWasher.class).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).build(), GTStructureUtility.buildHatchAdder(MTESteamMegaWasher.class).atLeast(MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam, HatchElement.OutputHatch, HatchElement.InputHatch).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).buildAndChain(StructureUtility.onElementPass(MTESteamMegaWasher::onCasingAdded, (IStructureElement)StructureUtility.ofBlocksTiered(MTESteamMegaWasher::getTierMachineCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, MTESteamMegaWasher::setCasingTier, MTESteamMegaWasher::getCasingTier)))})).addElement('B', StructureUtility.ofBlocksTiered(MTESteamMegaWasher::getTierPipeCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13)), (Object)-1, (t, m) -> {
        t.tierPipeCasing = m;
    }, t -> t.tierPipeCasing)).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150355_j), StructureUtility.ofBlockAnyMeta((Block)BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater))})).build();
    private int tierMachine = -1;
    private static final int MACHINEMODE_OREWASH = 0;
    private static final int MACHINEMODE_SIMPLEWASH = 1;

    public MTESteamMegaWasher(String aName) {
        super(aName);
    }

    public MTESteamMegaWasher(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamMegaWasher(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Washer";
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mOutputHatches) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mInputHatches) {
            h.updateTexture(this.getIndex());
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.casingTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && ((aValue & 0x80) == 0 || aValue == -1)) {
            this.casingTier = aValue;
        }
    }

    @Override
    protected ITexture getFrontOverlay() {
        return TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_WASHER).extFacing().build();
    }

    @Override
    protected ITexture getFrontOverlayActive() {
        return TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_WASHER_ACTIVE).extFacing().build();
    }

    private int getIndex() {
        if (this.casingTier <= 1) {
            return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
        }
        return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex())};
    }

    private int getCasingTextureID() {
        if (this.tierPipeCasing == 2 || this.casingTier == 2) {
            return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
        }
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    @Override
    public IStructureDefinition<MTESteamMegaWasher> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public static Integer getTierPipeCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 12 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 13 == meta) {
            return 2;
        }
        return null;
    }

    public static int getTierMachineCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && 10 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 0 == meta) {
            return 2;
        }
        return 0;
    }

    private void onCasingAdded() {
        ++this.casingAmount;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 6, 2, 7);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 6, 2, 7, realBudget, env, false, true);
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return true;
    }

    @Override
    public int nextMachineMode() {
        if (this.machineMode == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.clear();
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_WASHPLANT);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SIMPLEWASHER);
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_WASH_PLANT.mode." + this.machineMode));
    }

    @Override
    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GTPPRecipeMaps.simpleWasherRecipes, RecipeMaps.oreWasherRecipes);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tierMachine = -1;
        this.tierPipeCasing = -1;
        this.casingTier = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 6, 2, 7)) {
            return false;
        }
        if (this.tierPipeCasing == 1 && this.casingTier == 1) {
            this.updateHatchTexture();
            this.tierMachine = 1;
            return true;
        }
        if (this.tierPipeCasing == 2 && this.casingTier == 2) {
            this.updateHatchTexture();
            this.tierMachine = 2;
            return true;
        }
        return this.casingAmount >= 300;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        if (this.machineMode == 1) {
            return GTPPRecipeMaps.simpleWasherRecipes;
        }
        return RecipeMaps.oreWasherRecipes;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.casingTier = aValue;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(1.25 * (double)MTESteamMegaWasher.this.tierMachine).setDurationModifier(1.0f / (float)MTESteamMegaWasher.this.tierMachine);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 256;
    }

    @Override
    public int getTierRecipes() {
        return 1;
    }

    @Override
    protected MTESteamMultiBase.SteamTypes getSteamType() {
        return MTESteamMultiBase.SteamTypes.SC_STEAM;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Uses " + EnumChatFormatting.RED + "Supercritical Steam").addInfo("100% faster than using single block steam machines of the same pressure").addInfo("Only consumes steam at 62.5% of the L/s normally required").addInfo("Processes up to 256 items at once").addInfo("Minimum casing: 300").addInfo("Processing Speed & Steam Consumption is doubled under High Pressure").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Ideal for taking baths, washing dishes, or probably some other stuff").addInfo("Author: " + GTValues.AuthorSteamIsTheNumber).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Machine Tier: " + EnumChatFormatting.YELLOW + this.casingTier);
        info.add("Parallel: " + EnumChatFormatting.YELLOW + this.getTrueParallel());
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + MTESteamMegaWasher.getSteamTierTextForWaila(tag) + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_WASH_PLANT.mode." + tag.func_74762_e("mode"))) + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tierMachine", this.tierMachine);
        tag.func_74768_a("parallel", this.getTrueParallel());
        tag.func_74768_a("mode", this.machineMode);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierMachine", this.casingTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.casingTier = aNBT.func_74762_e("tierMachine");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MULTI_ORE_WASHER_PLANT_LOOP;
    }
}

