/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESteamMegaMacerator
extends MTESteamMultiBase<MTESteamMegaMacerator>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private int casingTier = -1;
    private int casingAmount = 0;
    private static final IStructureDefinition<MTESteamMegaMacerator> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAA~AAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA"}})).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamMegaMacerator.buildSteamInput(MTESteamMegaMacerator.class).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).build(), GTStructureUtility.buildHatchAdder(MTESteamMegaMacerator.class).atLeast(MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam, HatchElement.OutputHatch, HatchElement.InputHatch).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).buildAndChain(StructureUtility.onElementPass(MTESteamMegaMacerator::onCasingAdded, (IStructureElement)StructureUtility.ofBlocksTiered(MTESteamMegaMacerator::getTierMachineCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, MTESteamMegaMacerator::setCasingTier, MTESteamMegaMacerator::getCasingTier)))})).build();

    public MTESteamMegaMacerator(String aName) {
        super(aName);
    }

    public MTESteamMegaMacerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamMegaMacerator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Macerator";
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mOutputHatches) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mInputHatches) {
            h.updateTexture(this.getIndex());
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.casingTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && ((aValue & 0x80) == 0 || aValue == -1)) {
            this.casingTier = aValue;
        }
    }

    @Override
    protected ITexture getFrontOverlay() {
        return TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR).extFacing().build();
    }

    @Override
    protected ITexture getFrontOverlayActive() {
        return TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_ACTIVE).extFacing().build();
    }

    private int getIndex() {
        if (this.casingTier <= 1) {
            return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
        }
        return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex())};
    }

    @Override
    public IStructureDefinition<MTESteamMegaMacerator> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public static int getTierMachineCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && 10 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 0 == meta) {
            return 2;
        }
        return 0;
    }

    private void onCasingAdded() {
        ++this.casingAmount;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 7, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 7, 0, realBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingTier = -1;
        this.casingAmount = 0;
        this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 7, 0);
        this.updateHatchTexture();
        this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
        return this.casingTier > 0 && this.casingAmount >= 700 && !this.mSteamInputFluids.isEmpty();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.maceratorRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(1.25 * (double)MTESteamMegaMacerator.this.casingTier).setDurationModifier(1.6 / (double)MTESteamMegaMacerator.this.casingTier);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 256;
    }

    @Override
    public int getTierRecipes() {
        return 1;
    }

    @Override
    protected MTESteamMultiBase.SteamTypes getSteamType() {
        return MTESteamMultiBase.SteamTypes.SC_STEAM;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Uses " + EnumChatFormatting.RED + "Supercritical Steam").addInfo("25% faster than using single block steam machines of the same pressure").addInfo("Only consumes steam at 62.5% of the L/s normally required").addInfo("Processes up to 256 items at once").addInfo("Processing Speed & Steam Consumption is doubled under High Pressure").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Before your emperor, you are worthy. Before the Goddess of Justice,").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "you are worthy. Receive our blessings. Embrace our gifts. ").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "And rise, ascendant, for this is the ending that we all deserve.").beginStructureBlock(15, 15, 15, true).addController("Front center").addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).addInputHatch("Any casing", 1).addOutputHatch("Any casing", 1).addInputBus("Any casing", 1).addOutputBus("Any casing", 1).addStructureInfo(EnumChatFormatting.WHITE + "Steam Input Hatch " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing").addStructureInfo(EnumChatFormatting.BLUE + "Basic " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "70-800x" + EnumChatFormatting.GRAY + " Bronze Plated Bricks").addStructureInfo(EnumChatFormatting.BLUE + "High Pressure " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "700-800x" + EnumChatFormatting.GRAY + " Solid Steel Machine Casing").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Machine Tier: " + EnumChatFormatting.YELLOW + this.casingTier);
        info.add("Parallel: " + EnumChatFormatting.YELLOW + this.getTrueParallel());
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + MTESteamMegaMacerator.getSteamTierTextForWaila(tag) + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tierMachine", this.casingTier);
        tag.func_74768_a("parallel", this.getTrueParallel());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierMachine", this.casingTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.casingTier = aNBT.func_74762_e("tierMachine");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_MACERATOR_OP;
    }
}

