/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESteamMegaForgeHammer
extends MTESteamMultiBase<MTESteamMegaForgeHammer>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private int casingTier = -1;
    private int casingAmount = 0;
    private int tierPipeCasing = -1;
    private static final IStructureDefinition<MTESteamMegaForgeHammer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "    AAA    "}, {"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "     ~     ", "   AAAAA   "}, {"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "    AAA    ", "  AAAAAAA  "}, {"           ", "   AAAAA   ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "   AAAAA   ", " AAAAAAAAA "}, {"           ", " AAAAAAAAA ", "AA       AA", "A   CCC   A", "A   CCC   A", "A   CCC   A", "A         A", "A         A", "A         A", "A         A", "A AAAAAAA A", "AAAAAAAAAAA"}, {"     B     ", " AAAABAAAA ", "AA   B   AA", "A   CCC   A", "A   CCC   A", "A   CCC   A", "A         A", "A         A", "A         A", "A         A", "AAAAAAAAAAA", "AAAAAAAAAAA"}, {"           ", " AAAAAAAAA ", "AA       AA", "A   CCC   A", "A   CCC   A", "A   CCC   A", "A         A", "A         A", "A         A", "A         A", "A AAAAAAA A", "AAAAAAAAAAA"}, {"           ", "   AAAAA   ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "   AAAAA   ", " AAAAAAAAA "}, {"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "    AAA    ", "  AAAAAAA  "}, {"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "     A     ", "   AAAAA   "}, {"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "    AAA    "}}).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamMegaForgeHammer.buildSteamInput(MTESteamMegaForgeHammer.class).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).build(), GTStructureUtility.buildHatchAdder(MTESteamMegaForgeHammer.class).atLeast(MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam, HatchElement.OutputHatch, HatchElement.InputHatch).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).buildAndChain(StructureUtility.onElementPass(MTESteamMegaForgeHammer::onCasingAdded, (IStructureElement)StructureUtility.ofBlocksTiered(MTESteamMegaForgeHammer::getTierMachineCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, MTESteamMegaForgeHammer::setCasingTier, MTESteamMegaForgeHammer::getCasingTier)))})).addElement('B', StructureUtility.ofBlocksTiered(MTESteamMegaForgeHammer::getTierPipeCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13)), (Object)-1, (t, m) -> {
        t.tierPipeCasing = m;
    }, t -> t.tierPipeCasing)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)8)).build();
    private int tierMachine = -1;

    public MTESteamMegaForgeHammer(String aName) {
        super(aName);
    }

    public MTESteamMegaForgeHammer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamMegaForgeHammer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Macerator";
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mOutputHatches) {
            h.updateTexture(this.getIndex());
        }
        for (MTEHatch h : this.mInputHatches) {
            h.updateTexture(this.getIndex());
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.casingTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && ((aValue & 0x80) == 0 || aValue == -1)) {
            this.casingTier = aValue;
        }
    }

    @Override
    protected ITexture getFrontOverlay() {
        return TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_FORGE_HAMMER).extFacing().build();
    }

    @Override
    protected ITexture getFrontOverlayActive() {
        return TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_FORGE_HAMMER_ACTIVE).extFacing().build();
    }

    private int getIndex() {
        if (this.casingTier <= 1) {
            return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
        }
        return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex())};
    }

    @Override
    public IStructureDefinition<MTESteamMegaForgeHammer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public static Integer getTierPipeCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 12 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 13 == meta) {
            return 2;
        }
        return null;
    }

    public static int getTierMachineCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && 10 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 0 == meta) {
            return 2;
        }
        return 0;
    }

    private void onCasingAdded() {
        ++this.casingAmount;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 10, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 5, 10, 1, realBudget, env, false, true);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.hammerRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(1.25 * (double)MTESteamMegaForgeHammer.this.casingTier).setDurationModifier(1.0f / (float)MTESteamMegaForgeHammer.this.casingTier);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 256;
    }

    @Override
    public int getTierRecipes() {
        return 1;
    }

    @Override
    protected MTESteamMultiBase.SteamTypes getSteamType() {
        return MTESteamMultiBase.SteamTypes.SC_STEAM;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Uses " + EnumChatFormatting.RED + "Supercritical Steam").addInfo("100% faster than using single block steam machines of the same pressure").addInfo("Only consumes steam at 62.5% of the L/s normally required").addInfo("Processes up to 256 items at once").addInfo("Minimum casing: 150").addInfo("Processing Speed & Steam Consumption is doubled under High Pressure").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Smashing plates, smashing ores, smashing dreams").addInfo("Author: " + GTValues.AuthorSteamIsTheNumber).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Machine Tier: " + EnumChatFormatting.YELLOW + this.casingTier);
        info.add("Parallel: " + EnumChatFormatting.YELLOW + this.getTrueParallel());
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + MTESteamMegaForgeHammer.getSteamTierTextForWaila(tag) + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tierMachine", this.casingTier);
        tag.func_74768_a("parallel", this.getTrueParallel());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierMachine", this.casingTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.casingTier = aNBT.func_74762_e("tierMachine");
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tierMachine = -1;
        this.tierPipeCasing = -1;
        this.casingTier = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 10, 1)) {
            return false;
        }
        if (this.tierPipeCasing == 1 && this.casingTier == 1) {
            this.updateHatchTexture();
            this.tierMachine = 1;
            return true;
        }
        if (this.tierPipeCasing == 2 && this.casingTier == 2) {
            this.updateHatchTexture();
            this.tierMachine = 2;
            return true;
        }
        return this.casingAmount >= 150;
    }
}

