/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.recipe.metadata.SteamFusionTierKey;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasingsSteam;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEBetterSteamMultiBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTESteamFusionReactor
extends MTEBetterSteamMultiBase<MTESteamFusionReactor>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";

    public MTESteamFusionReactor(String aName) {
        super(aName);
    }

    public MTESteamFusionReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public String getMachineType() {
        return "High Pressure Reactor";
    }

    @Override
    public IStructureDefinition<MTESteamFusionReactor> getStructureDefinition() {
        return StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"               ", "      DDD      ", "               "}, {"      CCC      ", "    DDBBBDD    ", "      CCC      "}, {"    CC   CC    ", "   ABBDDDBBA   ", "    CC   CC    "}, {"   C       C   ", "  ABAD   DABA  ", "   C       C   "}, {"  C         C  ", " DBA       ABD ", "  C         C  "}, {"  C         C  ", " DBD       DBD ", "  C         C  "}, {" C           C ", "DBD         DBD", " C           C "}, {" C           C ", "DBD         DBD", " C           C "}, {" C           C ", "DBD         DBD", " C           C "}, {"  C         C  ", " DBD       DBD ", "  C         C  "}, {"  C         C  ", " DBA       ABD ", "  C         C  "}, {"   C       C   ", "  ABAD   DABA  ", "   C       C   "}, {"    CC   CC    ", "   ABBA~ABBA   ", "    CC   CC    "}, {"      CCC      ", "    DDBBBDD    ", "      CCC      "}, {"               ", "      DDD      ", "               "}}).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamFusionReactor.buildSteamInput(MTESteamFusionReactor.class).casingIndex(((BlockCasingsSteam)GregTechAPI.sBlockCasingsSteam).getTextureIndex(11)).dot(1).build(), GTStructureUtility.buildHatchAdder(MTESteamFusionReactor.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(((BlockCasingsSteam)GregTechAPI.sBlockCasingsSteam).getTextureIndex(11)).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)11)})).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)7)).addElement('D', GTStructureUtility.chainAllGlasses()).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)11)).build();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 1, 12);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 1, 12, elementBudget, env, false, true);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.getMetadataOrDefault(SteamFusionTierKey.INSTANCE, 0) != 0) {
                    return SimpleCheckRecipeResult.ofFailure("metadata.steamfusion");
                }
                return super.validateRecipe(recipe);
            }
        };
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.steamFusionReactorRecipes;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_FUSION_LOOP;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Combines Steam with hot fluids in order to reach higher temperatures").addInfo("Requires Steam to work? No, but kinda.").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "What's this? Fusion? HAHAHA, tell another joke silly!").addInputHatch("1-8, Blocks Adjacent to Glass", 1).addOutputHatch("1-8, Blocks Adjacent to Glass", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] rTexture = side == facing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 11)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_ACTIVE).extFacing().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 11)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR).extFacing().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 11))};
        return rTexture;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 1, 12);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamFusionReactor(this.mName);
    }
}

