/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTESteamExtractinator
extends MTESteamMultiBase<MTESteamExtractinator>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private IStructureDefinition<MTESteamExtractinator> STRUCTURE_DEFINITION = null;
    private static final int HORIZONTAL_OFF_SET = 1;
    private static final int VERTICAL_OFF_SET = 8;
    private static final int DEPTH_OFF_SET = 10;

    public MTESteamExtractinator(String aName) {
        super(aName);
    }

    public MTESteamExtractinator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTESteamExtractinator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Resource Extractor";
    }

    @Override
    protected ITexture getFrontOverlay() {
        return TextureFactory.of(Textures.BlockIcons.OVERLAY_EXTRACTINATOR);
    }

    @Override
    protected ITexture getFrontOverlayActive() {
        return TextureFactory.of(Textures.BlockIcons.OVERLAY_EXTRACTINATOR_ACTIVE);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10)), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10))};
    }

    @Override
    public IStructureDefinition<MTESteamExtractinator> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"               ", "               ", "       AA   AA ", "       A     A ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "       A     A ", "       AA   AA ", "               ", "               "}, {"               ", "               ", "       AAAAAAA ", "       A     A ", "       A     A ", "       A     A ", "       A     A ", "       A     A ", "       A     A ", "       A     A ", "EEE    A     A ", "EEE    A     A ", "EEE    A     A ", "       A     A ", "       AAAAAAA ", "               ", "               "}, {"          G    ", "               ", "        HHHHH  ", "       H     H ", "       H     H ", "       D     D ", "       H     H ", "       H     H ", "       H     H ", "       H     H ", "KKK    H     H ", "KCCCCCCD     D ", "KKK    H     H ", "       H     H ", "        HHHHH  ", "               ", "          G    "}, {"          B    ", "         BBB   ", "        ABBBA  ", "       AIIIIIA ", "      DDIIIIIDD", "      DDIIIIIDD", "      DDIIIIIDD", "       AIIIIIA ", "       AIIIIIA ", "       AIIIIIA ", "HHH   DDIIIIIDD", "HCH   DDIIIIIDD", "HHH   DDIIIIIDD", "       AIIIIIA ", "        ABBBA  ", "         BBB   ", "          B    "}, {"          G    ", "               ", "        HHHHH  ", "       H     H ", "      GH     HG", "       D     D ", "      GH     HG", "       H     H ", "       H     H ", "       H     H ", "MMM   GH     HG", "MCCCCCCD     D ", "MMM   GH     HG", "       H     H ", "        HHHHH  ", "               ", "          G    "}, {"          G    ", "               ", "       HGGGGGH ", "       H     H ", "      GH     HG", "       H     H ", "      G       G", "               ", "               ", "               ", "HHH   G       G", "HCH    H     H ", "HHH   GH     HG", "       H     H ", "       HGGGGGH ", "               ", "          G    "}, {"          G    ", "               ", "        HHHHH  ", "       H     H ", "      GH     HG", "       D     D ", "      GH     HG", "       H     H ", "       H     H ", "       H     H ", "MMM   GH     HG", "MCCCCCCD     D ", "MMM   GH     HG", "       H     H ", "        HHHHH  ", "               ", "          G    "}, {"          B    ", "         BBB   ", "        ABBBA  ", "       AIIIIIA ", "      DDIIIIIDD", "      DDIIIIIDD", "      DDIIIIIDD", "       AIIIIIA ", "       AIIIIIA ", "       AIIIIIA ", "HHH   DDIIIIIDD", "HCC   DDIIIIIDD", "HHH   DDIIIIIDD", "       AIIIIIA ", "        ABBBA  ", "         BBB   ", "          B    "}, {"          G    ", "               ", "        HHHHH  ", "       H     H ", "       H     H ", "       D     D ", "       H     H ", "       H     H ", "       H     H ", "       H     H ", "L~L    H     H ", "LCCCCCCD     D ", "LLL    H     H ", "       H     H ", "        HHHHH  ", "               ", "          G    "}, {"          G    ", "               ", "       JJJJJJJ ", "       JJJJJJJ ", "       JJJJJJJ ", "       JJJJJJJ ", "       JJJJJJJ ", "       JJJJJJJ ", "       JJJJJJJ ", "       JJJJJJJ ", "EEE    JJJJJJJ ", "EEE    JJJJJJJ ", "EEE    JJJJJJJ ", "       JJJJJJJ ", "       JJJJJJJ ", "               ", "          G    "}})).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)3)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)12)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)13)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)13)).addElement('G', GTStructureUtility.ofFrame(Materials.Steel)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)2)).addElement('I', StructureUtility.ofBlock((Block)GregTechAPI.sBlockGlass1, (int)5)).addElement('J', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)3)).addElement('K', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTESteamExtractinator.class).atLeast(HatchElement.InputHatch).casingIndex(10).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)})).addElement('L', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTESteamExtractinator.class).atLeast(MTESteamMultiBase.SteamHatchElement.OutputBus_Steam).casingIndex(10).dot(2).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)})).addElement('M', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamExtractinator.buildSteamInput(MTESteamExtractinator.class).casingIndex(10).dot(3).build(), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 8, 10);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 8, 10, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 8, 10)) {
            return false;
        }
        return this.checkHatches();
    }

    private boolean checkHatches() {
        return !this.mSteamInputFluids.isEmpty();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.steamExtractinatorRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setDurationModifier(1.0);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getTierRecipes() {
        return 8;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Uses " + EnumChatFormatting.GOLD + "Superheated Steam").addInfo("Vaporizes impurities in different soil slurries to generate usable materials").addInfo("Processes up to 4 recipes at once").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "From Steam to rocks, the power of the pressure may bring you infinite wealth!.").addInputHatch("Top Layer of Bronze Casings").addOutputHatch("Bottom Layer of Bronze Casings").addEnergyHatch("2 Middle Bronze Casing Layers").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected MTESteamMultiBase.SteamTypes getSteamType() {
        return MTESteamMultiBase.SteamTypes.SH_STEAM;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Parallel: " + EnumChatFormatting.YELLOW + this.getTrueParallel());
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("parallel", this.getTrueParallel());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_ELECTROFURNACE_LOOP;
    }
}

