/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasingsSteam;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEBetterSteamMultiBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTESteamBlastFurnace
extends MTEBetterSteamMultiBase<MTESteamBlastFurnace>
implements ISurvivalConstructable {
    FluidStack steam = FluidUtils.getSteam(10);
    FluidStack shSteam = FluidUtils.getSuperHeatedSteam(10);
    private final int randomTickOffset = (int)(Math.random() * 100.0 + 1.0);
    private static final String STRUCTURE_PIECE_MAIN = "main";

    public MTESteamBlastFurnace(String aName) {
        super(aName);
    }

    public MTESteamBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        return super.onRunningTick(aStack);
    }

    private void doProgress() {
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            FluidStack steamStack = tHatch.getFillableStack();
            if (steamStack == null) continue;
            int drain = Math.min(3200, steamStack.amount);
            drain = (int)((double)(drain / 80) * 80.0);
            tHatch.drain(drain, true);
            if (steamStack.isFluidEqual(this.steam)) {
                this.mProgresstime += drain / 80 * 20;
                continue;
            }
            if (steamStack.isFluidEqual(this.shSteam)) {
                this.mProgresstime += drain / 80 * 200;
                continue;
            }
            if (!steamStack.getFluid().getName().equals("supercriticalsteam")) continue;
            this.mProgresstime += drain / 80 * 2000;
        }
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mMaxProgresstime > 0) {
            if (this.onRunningTick(this.mInventory[1])) {
                this.func_70296_d();
                this.doProgress();
                if (this.mMaxProgresstime > 0 && this.mProgresstime >= this.mMaxProgresstime) {
                    if (this.mOutputItems != null) {
                        for (ItemStack tStack : this.mOutputItems) {
                            if (tStack == null) continue;
                            this.addOutput(tStack);
                        }
                        this.mOutputItems = null;
                    }
                    if (this.mOutputFluids != null) {
                        this.addFluidOutputs(this.mOutputFluids);
                        this.mOutputFluids = null;
                    }
                    this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
                    this.mOutputItems = null;
                    this.mProgresstime = 0;
                    this.mMaxProgresstime = 0;
                    this.mEfficiencyIncrease = 0;
                    this.mLastWorkingTick = this.mTotalRunTime;
                    if (aBaseMetaTileEntity.isAllowedToWork()) {
                        this.checkRecipe();
                    }
                }
            }
        } else if (aBaseMetaTileEntity.isAllowedToWork()) {
            if ((this.shouldCheckRecipeThisTick(aTick) || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) && this.checkRecipe()) {
                this.func_70296_d();
            }
            if (this.mMaxProgresstime <= 0) {
                this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
            }
        }
    }

    private boolean shouldCheckRecipeThisTick(long aTick) {
        long timeElapsed = this.mTotalRunTime - this.mLastWorkingTick;
        if (timeElapsed >= 100L) {
            return (this.mTotalRunTime + (long)this.randomTickOffset) % 100L == 0L;
        }
        if (!this.isBatchModeEnabled()) {
            return timeElapsed == 5L || timeElapsed == 12L || timeElapsed == 20L || timeElapsed == 30L || timeElapsed == 40L || timeElapsed == 55L || timeElapsed == 70L || timeElapsed == 85L;
        }
        return false;
    }

    @Override
    public String getMachineType() {
        return "";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Blast Furnace").addInfo("Faster than Bricked Blast Furnace and can be automated").addInfo("Consumes up to " + EnumChatFormatting.WHITE + "3200 L/t" + EnumChatFormatting.GRAY + " of steam (any variety)").addInfo("Recipe time is converted to total steam consumption").addInfo("Steam: " + EnumChatFormatting.WHITE + "80L = 1s").addInfo(EnumChatFormatting.GOLD + "Superheated Steam: " + EnumChatFormatting.WHITE + "80L = 10s").addInfo(EnumChatFormatting.RED + "Supercritical Steam: " + EnumChatFormatting.WHITE + "80L = 100s").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Blast furnaces are far too slow to create all of the steel you require.").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Using breel and stronze to efficiently channel steam should help!").addInfo("Author: " + GTValues.AuthorSteamIsTheNumber).toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 12, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 12, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.primitiveBlastRecipes;
    }

    @Override
    public IStructureDefinition<MTESteamBlastFurnace> getStructureDefinition() {
        return StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AA~AA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          "}, {"         AAAAAAA         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         AAAAAAA         "}, {"        AAAAAAAAA        ", "        A       A        ", "        A       A        ", "     A  A       A  A     ", " A  CCC A       A CCC  A ", "CCC CCC A       A CCC CCC", "CCC CCC A       A CCC CCC", "CCC CCC A       A CCC CCC", "CCC CCC AAAAAAAAA CCC CCC"}, {"        AAAAAAAAA        ", "  BBBBBBB       BBBBBBB  ", " BB  B  A       A  B  BB ", " B  ABA A       A ABA  B ", "ABA CBC A       A CBC ABA", "CBC CBC A       A CBC CBC", "CBC CBC A       A CBC CBC", "CBC CBC A       A CBC CBC", "CCC CCC AAAAAAAAA CCC CCC"}, {"        AAAAAAAAA        ", "        A       A        ", "        A       A        ", "     A  A       A  A     ", " A  CCC A       A CCC  A ", "CCC CCC A       A CCC CCC", "CCC CCC A       A CCC CCC", "CCC CCC A       A CCC CCC", "CCC CCC AAAAAAAAA CCC CCC"}, {"         AAAAAAA         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         A     A         ", "         AAAAAAA         "}, {"          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          ", "          AAAAA          "}}).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTESteamBlastFurnace.class).adder(MTEBetterSteamMultiBase::addToMachineList).hatchIds(31040, 15511).shouldReject(t -> !t.mSteamInputFluids.isEmpty()).casingIndex(((BlockCasingsSteam)GregTechAPI.sBlockCasingsSteam).getTextureIndex(8)).dot(1).build(), GTStructureUtility.buildHatchAdder(MTESteamBlastFurnace.class).atLeast(MTEBetterSteamMultiBase.SteamHatchElement.InputBus_Steam, MTEBetterSteamMultiBase.SteamHatchElement.OutputBus_Steam).casingIndex(((BlockCasingsSteam)GregTechAPI.sBlockCasingsSteam).getTextureIndex(8)).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)8)})).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)7)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)15)).build();
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return new String[0];
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 12, 4, 0);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamBlastFurnace(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 8)), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE_GLOW).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 8)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BBF_INACTIVE).extFacing().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 8))};
        return rTexture;
    }
}

