/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings1;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEBetterSteamMultiBase;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEMegaSolarBoiler
extends MTEBetterSteamMultiBase<MTEMegaSolarBoiler>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String[][] structure = StructureUtility.transpose((String[][])new String[][]{{" BBBBB         BBBBB ", "BAAAAAB       BAAAAAB", "BAAAAAB       BAAAAAB", "BAAAAAB       BAAAAAB", "BAAAAAB       BAAAAAB", "BAAAAAB       BAAAAAB", " BBBBB         BBBBB "}, {"  DDD           DDD  ", " FFFFF         FFFFF ", "DFFFFFD       DFFFFFD", "DFFFFFD       DFFFFFD", "DFFFFFD       DFFFFFD", " FFFFF         FFFFF ", "  DDD           DDD  "}, {"   B   CCCCCCC   B   ", " CCCCC CAAAAAC CCCCC ", " CBBBC CAAAAAC CBBBC ", "BCBBBCBCAAAAACBCBBBCB", " CBBBC CAAAAAC CBBBC ", " CCCCC CAAAAAC CCCCC ", "   B   CCCCCCC   B   "}, {"       C     C       ", "       CFFFFFC       ", "   EE  CFFFFFC  EE   ", "  EEEEECFFFFFCEEEE   ", "   EE  CFFFFFC  EE   ", "       CFFFFFC       ", "       CCCCCCC       "}, {"       C     C       ", "       CGG~GGC       ", "    EEECBBBBBCEEE    ", "   EEEECBBBBBCEEEE   ", "    EEECBBBBBCEEE    ", "       CBBBBBC       ", "       CGGGGGC       "}});
    private static final int HORIZONTAL_OFF_SET = 10;
    private static final int VERTICAL_OFF_SET = 4;
    private static final int DEPTH_OFF_SET = 1;
    private String state;

    public MTEMegaSolarBoiler(String aName) {
        super(aName);
    }

    public MTEMegaSolarBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTEMegaSolarBoiler(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Solar Boiler";
    }

    @Override
    public IStructureDefinition<MTEMegaSolarBoiler> getStructureDefinition() {
        return StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, structure).addElement('A', GTStructureUtility.chainAllGlasses()).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)).addElement('G', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEMegaSolarBoiler.class).atLeast(MTEBetterSteamMultiBase.SteamHatchElement.InputBus_Steam, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(10).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)})).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)12)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)13)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)9)).build();
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getCasingTextureID());
        }
    }

    private int getCasingTextureID() {
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] rTexture = side == facing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 9)), TextureFactory.builder().addIcon(Textures.BlockIcons.SOLAR_CELL_TOP).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.SOLAR_CELL_TOP).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 9)), TextureFactory.builder().addIcon(Textures.BlockIcons.SOLAR_CELL_TOP).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.SOLAR_CELL_TOP).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 9))};
        return rTexture;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 10, 4, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 10, 4, 1, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 10, 4, 1);
    }

    @Override
    public void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isAllowedToWork()) {
            if (aBaseMetaTileEntity.getWorld().func_72935_r() || !this.depleteInputReal(Materials.Water.getFluid(30L), true)) {
                this.addOutput(FluidUtils.getSteam(4800));
                this.depleteInputReal(Materials.Water.getFluid(30L));
                this.state = "Boiling! :D";
            } else {
                this.state = "Idle :(";
            }
        }
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget((Widget)new TextWidget().setStringSupplier(() -> EnumChatFormatting.GREEN + this.state).setTextAlignment(Alignment.CenterLeft))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.state, val -> {
            this.state = val;
        }));
    }

    public boolean depleteInputReal(FluidStack aLiquid) {
        return this.depleteInputReal(aLiquid, false);
    }

    public boolean depleteInputReal(FluidStack aLiquid, boolean simulate) {
        if (aLiquid == null) {
            return false;
        }
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            this.setHatchRecipeMap(tHatch);
            FluidStack tLiquid = tHatch.drain(ForgeDirection.UNKNOWN, aLiquid, false);
            if (tLiquid == null || tLiquid.amount < aLiquid.amount) continue;
            if (simulate) {
                return true;
            }
            tLiquid = tHatch.drain(ForgeDirection.UNKNOWN, aLiquid, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Solar Boiler").addInfo("Maybe an Eye of Harmony could provide enough silver for this monstrosity").addInfo("Produces 96.000 L/s of Steam").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "More steam/s than unplayed games in your steam library").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_MACERATOR_OP;
    }
}

