/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import cofh.asmhooks.block.BlockTickingWater;
import cofh.asmhooks.block.BlockWater;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEIndustrialWashPlant
extends GTPPMultiBlockBase<MTEIndustrialWashPlant>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<MTEIndustrialWashPlant> STRUCTURE_DEFINITION = null;
    private static final int MACHINEMODE_OREWASH = 0;
    private static final int MACHINEMODE_SIMPLEWASH = 1;
    private static final int MACHINEMODE_CHEMBATH = 2;

    public MTEIndustrialWashPlant(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialWashPlant(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialWashPlant(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Ore Washer, Simple Washer, Chemical Bath";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Can be configured with a screwdriver to also do Simple Washer and process Chemical Bathing").addInfo("400% faster than using single block machines of the same voltage").addInfo("Processes four item per voltage tier").addInfo("Always requires an Input Hatch full of water to refill structure").addInfo("Need to be filled with water.").addInfo("Will automatically fill water from input hatch.").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(5, 3, 7, true).addController("Front Center").addCasingInfoMin("Wash Plant Casings", 40, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialWashPlant> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CwwwC", "CwwwC", "CwwwC", "CwwwC", "CwwwC", "CCCCC"}, {"CC~CC", "CwwwC", "CwwwC", "CwwwC", "CwwwC", "CwwwC", "CCCCC"}, {"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialWashPlant.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())))).addElement('w', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), GTStructureUtility.ofAnyWater(true)})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 2, 1, 0) && this.mCasing >= 40 && this.checkHatch();
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCDIndustrialWashPlantActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCDIndustrialWashPlantActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCDIndustrialWashPlant;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCDIndustrialWashPlantGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getCasingTextureIndex();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        switch (this.machineMode) {
            case 0: {
                return RecipeMaps.oreWasherRecipes;
            }
            case 1: {
                return GTPPRecipeMaps.simpleWasherRecipes;
            }
        }
        return RecipeMaps.chemicalBathRecipes;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.oreWasherRecipes, GTPPRecipeMaps.simpleWasherRecipes, RecipeMaps.chemicalBathRecipes);
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (MTEIndustrialWashPlant.this.checkForWater()) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                return SimpleCheckRecipeResult.ofFailure("no_water");
            }
        }.setSpeedBonus(0.2f).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        if (this.machineMode == 2) {
            return PollutionConfig.pollutionPerSecondMultiIndustrialWashPlant_ModeChemBath;
        }
        return PollutionConfig.pollutionPerSecondMultiIndustrialWashPlant_ModeWasher;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings2Misc;
    }

    public byte getCasingMeta() {
        return 4;
    }

    public byte getCasingTextureIndex() {
        return (byte)TAE.GTPP_INDEX(11);
    }

    public boolean checkForWater() {
        boolean isValidWater;
        int mCurrentDirectionZ;
        int mCurrentDirectionX;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int mDirectionX = aBaseMetaTileEntity.getBackFacing().offsetX;
        int mOffsetX_Lower = 0;
        int mOffsetX_Upper = 0;
        int mOffsetZ_Lower = 0;
        int mOffsetZ_Upper = 0;
        if (mDirectionX == 0) {
            mCurrentDirectionX = 2;
            mCurrentDirectionZ = 3;
            mOffsetX_Lower = -2;
            mOffsetX_Upper = 2;
            mOffsetZ_Lower = -3;
            mOffsetZ_Upper = 3;
        } else {
            mCurrentDirectionX = 3;
            mCurrentDirectionZ = 2;
            mOffsetX_Lower = -3;
            mOffsetX_Upper = 3;
            mOffsetZ_Lower = -2;
            mOffsetZ_Upper = 2;
        }
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * mCurrentDirectionX;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * mCurrentDirectionZ;
        int tAmount = 0;
        for (int i = mOffsetX_Lower + 1; i <= mOffsetX_Upper - 1; ++i) {
            for (int j = mOffsetZ_Lower + 1; j <= mOffsetZ_Upper - 1; ++j) {
                for (int h = 0; h < 2; ++h) {
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if ((tBlock == Blocks.field_150350_a || tBlock == Blocks.field_150358_i || tBlock == Blocks.field_150355_j) && this.getStoredFluids() != null) {
                        for (FluidStack stored : this.getStoredFluids()) {
                            if (!stored.isFluidEqual(FluidUtils.getFluidStack("water", 1)) || stored.amount < 1000) continue;
                            stored.amount -= 1000;
                            Block fluidUsed = null;
                            if (tBlock == Blocks.field_150350_a || tBlock == Blocks.field_150358_i) {
                                fluidUsed = Blocks.field_150355_j;
                            }
                            if (tBlock == Blocks.field_150355_j) {
                                fluidUsed = BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater);
                            }
                            aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, fluidUsed);
                        }
                    }
                    if (tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) {
                        ++tAmount;
                        continue;
                    }
                    if (tBlock == BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater)) {
                        ++tAmount;
                        continue;
                    }
                    if (!Mods.COFHCore.isModLoaded() || !(tBlock instanceof BlockWater) && !(tBlock instanceof BlockTickingWater)) continue;
                    ++tAmount;
                }
            }
        }
        boolean bl = isValidWater = tAmount >= 30;
        if (isValidWater) {
            Logger.WARNING("Filled structure.");
        } else {
            Logger.WARNING("Did not fill structure.");
        }
        return isValidWater;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mChemicalMode")) {
            boolean aTempMode = aNBT.func_74767_n("mChemicalMode");
            this.machineMode = aTempMode ? 2 : 0;
            aNBT.func_82580_o("mChemicalMode");
        }
        if (aNBT.func_74764_b("mMode")) {
            this.machineMode = aNBT.func_74762_e("mMode");
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_WASH_PLANT.mode." + this.machineMode));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("mode", this.machineMode);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_WASH_PLANT.mode." + tag.func_74762_e("mode"))) + EnumChatFormatting.RESET);
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return true;
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.setMachineMode(this.nextMachineMode());
        PlayerUtils.messagePlayer(aPlayer, String.format(StatCollector.func_74838_a((String)"GT5U.MULTI_MACHINE_CHANGE"), this.getMachineModeName()));
    }

    @Override
    public int nextMachineMode() {
        if (this.machineMode == 0) {
            return 1;
        }
        if (this.machineMode == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.clear();
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_WASHPLANT);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SIMPLEWASHER);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_CHEMBATH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MULTI_ORE_WASHER_PLANT_LOOP;
    }
}

