/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.carving.Carving;

public class MTEAutoChisel
extends MTEBasicMachine {
    private ItemStack mInputCache;
    private ItemStack mOutputCache;
    private static final FallbackableUITexture progressBarTexture = GTUITextures.fallbackableProgressbar("auto_chisel", GTUITextures.PROGRESSBAR_COMPRESS);

    public MTEAutoChisel(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Chisels things, Gregtech style", 1, 1, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(TexturesGtBlock.Overlay_MatterFab_Active), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_MatterFab_Active_Glow).glow().build()), TextureFactory.of(TextureFactory.of(TexturesGtBlock.Overlay_MatterFab), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_MatterFab_Glow).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_GLOW).glow().build()));
    }

    public MTEAutoChisel(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAutoChisel(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"What you want to chisel goes in slot 1", "What you want to get goes in the special slot (bottom right)", "If special slot is empty, first chisel result is used"});
    }

    private boolean hasValidCache(ItemStack aStack, ItemStack aSpecialSlot, boolean aClearOnFailure) {
        if (this.mInputCache != null && this.mOutputCache != null && GTUtility.areStacksEqual(aStack, this.mInputCache) && GTUtility.areStacksEqual(aSpecialSlot, this.mOutputCache)) {
            return true;
        }
        if (aClearOnFailure) {
            this.mInputCache = null;
            this.mOutputCache = null;
        }
        return false;
    }

    private void cacheItem(ItemStack mInputItem, ItemStack mOutputItem) {
        this.mOutputCache = mOutputItem.func_77946_l();
        this.mInputCache = mInputItem.func_77946_l();
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.hasValidCache(aStack, this.getSpecialSlot(), false) || super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && MTEAutoChisel.hasChiselResults(aStack);
    }

    private static boolean canBeMadeFrom(ItemStack from, ItemStack to) {
        List<ItemStack> results = MTEAutoChisel.getItemsForChiseling(from);
        for (ItemStack s : results) {
            if (s.func_77973_b() != to.func_77973_b() || s.func_77960_j() != to.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChiselResults(ItemStack from) {
        List<ItemStack> results = MTEAutoChisel.getItemsForChiseling(from);
        return !results.isEmpty();
    }

    private static List<ItemStack> getItemsForChiseling(ItemStack aStack) {
        return Carving.chisel.getItemsForChiseling(aStack);
    }

    private static ItemStack getChiselOutput(ItemStack aInput, ItemStack aTarget) {
        Object tOutput = null;
        tOutput = aTarget != null && MTEAutoChisel.canBeMadeFrom(aInput, aTarget) ? aTarget : (aTarget != null && !MTEAutoChisel.canBeMadeFrom(aInput, aTarget) ? null : MTEAutoChisel.getItemsForChiseling(aInput).get(0));
        return tOutput;
    }

    @Override
    public int checkRecipe() {
        ItemStack tOutput = null;
        ItemStack aInput = this.getInputAt(0);
        ItemStack aTarget = this.getSpecialSlot();
        boolean tIsCached = this.hasValidCache(aInput, aTarget, true);
        if (aInput != null && MTEAutoChisel.hasChiselResults(aInput) && aInput.field_77994_a > 0) {
            ItemStack itemStack = tOutput = tIsCached ? this.mOutputCache.func_77946_l() : MTEAutoChisel.getChiselOutput(aInput, aTarget);
            if (tOutput != null) {
                tOutput = tOutput.func_77946_l();
                tOutput.field_77994_a = 1;
                if (this.canOutput(tOutput)) {
                    --this.getInputAt((int)0).field_77994_a;
                    this.calculateOverclockedNess(16, 20);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    if (!tIsCached) {
                        this.cacheItem(ItemUtils.getSimpleStack(aInput, 1), ItemUtils.getSimpleStack(tOutput, 1));
                    }
                    this.mOutputItems[0] = tOutput.func_77946_l();
                    return 2;
                }
                ++this.mOutputBlocked;
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(progressBarTexture).build();
    }

    @Override
    protected SlotWidget createItemInputSlot(int index, IDrawable[] backgrounds, Pos2d pos) {
        return (SlotWidget)super.createItemInputSlot(index, backgrounds, pos).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_COMPRESSOR});
    }

    @Override
    protected SlotWidget createSpecialSlot(IDrawable[] backgrounds, Pos2d pos, BasicUIProperties uiProperties) {
        return (SlotWidget)super.createSpecialSlot(backgrounds, pos, uiProperties).setGTTooltip(() -> this.mTooltipCache.getData("GTPP.machines.chisel_slot.tooltip", new Object[0]));
    }
}

