/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers;

import baubles.api.BaublesApi;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import gregtech.common.items.MetaGeneratedItem01;
import gregtech.common.items.MetaGeneratedItem02;
import gregtech.common.items.MetaGeneratedItem03;
import gregtech.common.items.MetaGeneratedTool01;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic.MTEWirelessCharger;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ChargingHelper {
    private static final Map<String, Pair<MTEWirelessCharger, Byte>> mValidPlayers = new HashMap<String, Pair<MTEWirelessCharger, Byte>>();
    protected static Map<BlockPos, MTEWirelessCharger> mChargerMap = new HashMap<BlockPos, MTEWirelessCharger>();
    private int mTickTimer = 0;
    private static final int mTickMultiplier = 20;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (++this.mTickTimer % 20 == 0 && Utils.isServer()) {
            for (EntityPlayer entityPlayer : PlayerUtils.getOnlinePlayers()) {
                this.doPlayerChargeTick(entityPlayer);
            }
        }
    }

    private void doPlayerChargeTick(EntityPlayer mPlayerMan) {
        block8: {
            try {
                IInventory baubleInv;
                if (mChargerMap.isEmpty() || !mValidPlayers.containsKey(mPlayerMan.getDisplayName())) break block8;
                InventoryPlayer mPlayerInventory = mPlayerMan.field_71071_by;
                ItemStack[] mArmourContents = (ItemStack[])mPlayerInventory.field_70460_b.clone();
                ItemStack[] mInventoryContents = (ItemStack[])mPlayerInventory.field_70462_a.clone();
                ItemStack[] baubleSlots = null;
                if (Mods.Baubles.isModLoaded() && (baubleInv = BaublesApi.getBaubles((EntityPlayer)mPlayerMan)) != null) {
                    baubleSlots = new ItemStack[baubleInv.func_70302_i_()];
                    for (int i = 0; i < baubleInv.func_70302_i_(); ++i) {
                        baubleSlots[i] = baubleInv.func_70301_a(i);
                    }
                }
                for (MTEWirelessCharger mEntityTemp : mChargerMap.values()) {
                    double mDistance;
                    long mMaxDistance;
                    long mVoltageCost;
                    if (mEntityTemp == null || mEntityTemp.getBaseMetaTileEntity() == null || !mEntityTemp.getBaseMetaTileEntity().isAllowedToWork() || mPlayerMan.func_130014_f_().field_73011_w.field_76574_g != mEntityTemp.getDimensionID()) continue;
                    long mVoltage = mEntityTemp.maxEUInput();
                    long mEuStored = mEntityTemp.getEUVar();
                    if (mVoltage <= 0L || mEuStored < mVoltage) continue;
                    Map<String, UUID> LR = mEntityTemp.getLongRangeMap();
                    Map<String, UUID> LO = mEntityTemp.getLocalMap();
                    long mStartingEu = mEntityTemp.getEUVar();
                    if (this.canCharge(mEntityTemp, mPlayerMan, LR, LO)) {
                        this.chargeItems(mEntityTemp, mArmourContents);
                        this.chargeItems(mEntityTemp, mInventoryContents);
                        this.chargeItems(mEntityTemp, baubleSlots);
                    }
                    if (mStartingEu - mEntityTemp.getEUVar() > 0L || (mVoltageCost = (long)MathUtils.findPercentageOfInt(mMaxDistance = mEntityTemp.getMode() == 0 ? 4L * GTValues.V[mEntityTemp.getTier()] : (mEntityTemp.getMode() == 1 ? (long)mEntityTemp.getTier() * 10L : 4L * GTValues.V[mEntityTemp.getTier()] / 2L), (float)(mDistance = this.calculateDistance(mEntityTemp, mPlayerMan)))) <= 0L) continue;
                    if (mVoltageCost > mEntityTemp.maxEUInput()) {
                        mEntityTemp.setEUVar(mEntityTemp.getEUVar() - mEntityTemp.maxEUInput());
                        continue;
                    }
                    mEntityTemp.setEUVar(mEntityTemp.getEUVar() - mVoltageCost);
                }
            }
            catch (Throwable t) {
                if (mChargerMap.isEmpty()) break block8;
                for (BlockPos aPos : mChargerMap.keySet()) {
                    MTEWirelessCharger r = mChargerMap.get(aPos);
                    if (r != null && !r.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
                    mChargerMap.remove(aPos);
                }
            }
        }
    }

    public static MTEWirelessCharger getEntry(BlockPos mPos) {
        return mChargerMap.get(mPos);
    }

    public static boolean addEntry(BlockPos mPos, MTEWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        mChargerMap.put(mPos, mEntity);
        return true;
    }

    public static boolean removeEntry(BlockPos mPos, MTEWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        if (mChargerMap.containsKey(mPos)) {
            return mChargerMap.remove(mPos, mEntity);
        }
        return false;
    }

    public static boolean addValidPlayer(EntityPlayer mPlayer, MTEWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        if (mValidPlayers.containsKey(mPlayer.getDisplayName())) {
            return false;
        }
        Pair mEntry = Pair.of((Object)mEntity, (Object)((byte)mEntity.getMode()));
        return mValidPlayers.put(mPlayer.getDisplayName(), (Pair<MTEWirelessCharger, Byte>)mEntry) == null;
    }

    public static boolean removeValidPlayer(EntityPlayer mPlayer, MTEWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        if (mValidPlayers.containsKey(mPlayer.getDisplayName())) {
            Pair mEntry = Pair.of((Object)mEntity, (Object)((byte)mEntity.getMode()));
            return mValidPlayers.remove(mPlayer.getDisplayName(), mEntry);
        }
        return false;
    }

    private boolean canCharge(MTEWirelessCharger charger, EntityPlayer chargeablePlayer, Map<String, UUID> longRangeChargers, Map<String, UUID> shortRangeChargers) {
        if (charger.getMode() == 0) {
            return !longRangeChargers.isEmpty() && longRangeChargers.containsKey(chargeablePlayer.getDisplayName());
        }
        if (charger.getMode() == 1) {
            return !shortRangeChargers.isEmpty() && shortRangeChargers.containsKey(chargeablePlayer.getDisplayName());
        }
        if (!longRangeChargers.isEmpty() && longRangeChargers.containsKey(chargeablePlayer.getDisplayName())) {
            return true;
        }
        return !shortRangeChargers.isEmpty() && shortRangeChargers.containsKey(chargeablePlayer.getDisplayName());
    }

    private double calculateDistance(MTEWirelessCharger mEntityTemp, EntityPlayer mPlayerMan) {
        if (mEntityTemp == null || mPlayerMan == null) {
            return 0.0;
        }
        return mEntityTemp.getDistanceBetweenTwoPositions(mEntityTemp.getTileEntityPosition(), mEntityTemp.getPositionOfEntity((Entity)mPlayerMan));
    }

    private void chargeItems(@Nonnull MTEWirelessCharger mEntity, ItemStack[] mItems) {
        if (mItems == null || mItems.length == 0) {
            return;
        }
        this.chargeItemsEx(mEntity, mItems);
    }

    private void chargeItemsEx(@Nonnull MTEWirelessCharger mEntity, ItemStack[] mItems) {
        if (mItems == null || mItems.length == 0) {
            return;
        }
        long mVoltage = mEntity.maxEUInput();
        long mEuStored = mEntity.getEUVar();
        for (ItemStack mTemp : mItems) {
            if (ChargingHelper.isItemValid(mTemp)) {
                int xDif;
                double mVoltageIncrease;
                int mMulti;
                int mMultiVoltage;
                double mItemEuTLimit = ((IElectricItem)mTemp.func_77973_b()).getTransferLimit(mTemp);
                if (!((double)mEuStored >= mItemEuTLimit)) continue;
                double mItemMaxCharge = ((IElectricItem)mTemp.func_77973_b()).getMaxCharge(mTemp);
                double mitemCurrentCharge = ElectricItem.manager.getCharge(mTemp);
                if (mitemCurrentCharge >= mItemMaxCharge) continue;
                if (mTemp.func_77973_b() instanceof MetaGeneratedTool01 || mTemp.func_77973_b() instanceof MetaGeneratedItem01 || mTemp.func_77973_b() instanceof MetaGeneratedItem02 || mTemp.func_77973_b() instanceof MetaGeneratedItem03 || mTemp.func_77973_b().getClass().getName().equalsIgnoreCase(MetaGeneratedTool01.class.getName())) {
                    if (!NBTUtils.hasKey(mTemp, "GT.ItemCharge")) {
                        if (!mTemp.func_82833_r().toLowerCase().contains("battery")) {
                            if (!GTModHandler.isElectricItem(mTemp)) {
                                continue;
                            }
                        } else {
                            mitemCurrentCharge = 0.0;
                        }
                    } else {
                        mitemCurrentCharge = NBTUtils.getLong(mTemp, "GT.ItemCharge");
                    }
                } else if (mTemp.func_77973_b() instanceof IElectricItem) {
                    mitemCurrentCharge = NBTUtils.getLong(mTemp, "charge");
                }
                if (mitemCurrentCharge + (double)(mMultiVoltage = (int)((double)(mMulti = mitemCurrentCharge + (mVoltageIncrease = mItemEuTLimit >= (double)mVoltage ? (double)mVoltage : (mItemEuTLimit < (double)mVoltage ? mItemEuTLimit : mItemEuTLimit)) * 20.0 <= mItemMaxCharge - mVoltageIncrease * 20.0 ? 20 : (mitemCurrentCharge + mVoltageIncrease * 10.0 <= mItemMaxCharge - mVoltageIncrease * 10.0 ? 10 : (mitemCurrentCharge + mVoltageIncrease * 5.0 <= mItemMaxCharge - mVoltageIncrease * 5.0 ? 5 : 1))) * mVoltageIncrease)) <= mItemMaxCharge) {
                    if (GTModHandler.chargeElectricItem(mTemp, mMultiVoltage, Integer.MAX_VALUE, true, false) > 0) {
                        for (int i = 0; i < mMulti; ++i) {
                            ElectricItem.manager.charge(mTemp, mVoltageIncrease, Integer.MAX_VALUE, false, false);
                        }
                    }
                    if (ElectricItem.manager.getCharge(mTemp) > mitemCurrentCharge) {
                        mEntity.setEUVar(mEuStored - mVoltage * (long)mMulti);
                        mEuStored = mEntity.getEUVar();
                    }
                }
                if (!((mitemCurrentCharge = ElectricItem.manager.getCharge(mTemp)) < mItemMaxCharge) || !(mitemCurrentCharge >= mItemMaxCharge - (double)mVoltage) || GTModHandler.chargeElectricItem(mTemp, xDif = (int)(mItemMaxCharge - mitemCurrentCharge), Integer.MAX_VALUE, true, false) < 0 || !(ElectricItem.manager.getCharge(mTemp) >= mItemMaxCharge)) continue;
                mEntity.setEUVar(mEntity.getEUVar() - (long)xDif);
                mEuStored = mEntity.getEUVar();
                continue;
            }
            if (!ChargingHelper.isItemValidRF(mTemp)) continue;
            try {
                IEnergyContainerItem rfItem = (IEnergyContainerItem)mTemp.func_77973_b();
                if (rfItem == null) continue;
                long chargedPower = Math.min((long)(rfItem.getMaxEnergyStored(mTemp) - rfItem.getEnergyStored(mTemp)), mEntity.getEUVar() * (long)GregTechAPI.mEUtoRF / 100L);
                chargedPower = rfItem.receiveEnergy(mTemp, chargedPower > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)chargedPower, false);
                chargedPower = chargedPower * 100L / (long)GregTechAPI.mEUtoRF;
                mEntity.setEUVar(Math.max(mEntity.getEUVar() - chargedPower, 0L));
                mEuStored = mEntity.getEUVar();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isItemValid(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (GTModHandler.isElectricItem(itemstack)) {
            return true;
        }
        return itemstack.func_77973_b() instanceof IElectricItem;
    }

    private static boolean isItemValidRF(ItemStack itemStack) {
        return itemStack != null && Mods.COFHCore.isModLoaded() && itemStack.func_77973_b() instanceof IEnergyContainerItem;
    }
}

