/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.covers;

import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverToggleVisual
extends CoverLegacyData {
    private static final Map<String, Integer> sConnectionStateForEntityMap = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, String> sPrefixMap = new ConcurrentHashMap<String, String>();
    private static final int VALUE_OFF = 0;
    private static final int VALUE_ON = 1;

    public CoverToggleVisual(CoverContext context) {
        super(context);
    }

    public static String generateUniqueKey(ForgeDirection side, ICoverable coverable) {
        try {
            if (coverable != null) {
                BlockPos aPos = new BlockPos(coverable.getIGregTechTileEntity(coverable.getXCoord(), coverable.getYCoord(), coverable.getZCoord()));
                return coverable.func_145825_b() + "." + aPos.getUniqueIdentifier() + side.name();
            }
        }
        catch (Throwable aPos) {
            // empty catch block
        }
        XSTR x = new XSTR();
        return "ERROR." + x.getSeed() + x.hashCode() + x.nextDouble() + ".ID";
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        PlayerUtils.messagePlayer(aPlayer, GTUtility.trans("756", "Connectable: ") + this.getConnectionState());
        return super.onCoverRightClick(aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean letsEnergyIn() {
        return this.getConnectionState();
    }

    @Override
    public boolean letsEnergyOut() {
        return this.getConnectionState();
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return this.getConnectionState();
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return this.getConnectionState();
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return this.getConnectionState();
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return this.getConnectionState();
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        try {
            String aKey = CoverToggleVisual.generateUniqueKey(this.coverSide, (ICoverable)this.coveredTile.get());
            Integer b = sConnectionStateForEntityMap.get(aKey);
            if (b != null && this.coverData != b) {
                this.coverData = b;
            }
            if (b == null) {
                b = this.coverData;
                sConnectionStateForEntityMap.put(aKey, b);
                this.coverData = b == 1 ? 1 : 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return this.getConnectionState();
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return this.getConnectionState();
    }

    @Override
    public byte getRedstoneInput(byte aInputRedstone) {
        if (!this.getConnectionState()) {
            return 0;
        }
        return super.getRedstoneInput(aInputRedstone);
    }

    @Override
    public void onPlayerAttach(EntityPlayer player, ItemStack coverItem) {
        String aKey = CoverToggleVisual.generateUniqueKey(this.coverSide, (ICoverable)this.coveredTile.get());
        boolean state = CoverToggleVisual.getCoverConnections(coverItem);
        sPrefixMap.put(aKey, coverItem.func_77977_a());
        Logger.INFO("Mapping key " + aKey + " to " + state);
        sConnectionStateForEntityMap.put(aKey, state ? 1 : 0);
        Logger.INFO("Key Value: " + (state ? 1 : 0));
    }

    @Override
    public void onCoverRemoval() {
        String aKey = CoverToggleVisual.generateUniqueKey(this.coverSide, (ICoverable)this.coveredTile.get());
        sConnectionStateForEntityMap.remove(aKey);
    }

    public boolean getConnectionState() {
        return this.coverData == 1;
    }

    public static boolean getConnectionState(ForgeDirection side, ICoverable aTile) {
        String aKey = CoverToggleVisual.generateUniqueKey(side, aTile);
        return CoverToggleVisual.getConnectionState(aKey);
    }

    public static boolean getConnectionState(String aKey) {
        Integer b = sConnectionStateForEntityMap.get(aKey);
        return b != null && b == 1;
    }

    public static boolean getCoverConnections(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("CustomCoverMeta")) != null) {
            return aNBT.func_74767_n("AllowConnections");
        }
        return false;
    }
}

