/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEFluidPipe;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.xmod.gregtech.registration.gregtech.GregtechConduits;
import net.minecraftforge.common.util.ForgeDirection;

public class GTPPMTEFluidPipe
extends MTEFluidPipe {
    public final GregtechConduits.PipeStats pipeStats;

    public GTPPMTEFluidPipe(int aID, String aName, String aNameRegional, float aThickNess, GregtechConduits.PipeStats pipeStats, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aID, aName, aNameRegional, aThickNess, pipeStats, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GTPPMTEFluidPipe(String aName, float aThickNess, GregtechConduits.PipeStats pipeStats, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aName, aThickNess, pipeStats, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GTPPMTEFluidPipe(int aID, String aName, String aNameRegional, float aThickNess, GregtechConduits.PipeStats pipeStats, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aID, aName, aNameRegional, aThickNess, null, aCapacity, aHeatResistance, aGasProof, aFluidTypes);
        this.mLastReceivedFrom = 0;
        this.oLastReceivedFrom = 0;
        this.pipeStats = pipeStats;
    }

    public GTPPMTEFluidPipe(String aName, float aThickNess, GregtechConduits.PipeStats pipeStats, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aName, aThickNess, null, aCapacity, aHeatResistance, aGasProof, aFluidTypes);
        this.mLastReceivedFrom = 0;
        this.oLastReceivedFrom = 0;
        this.pipeStats = pipeStats;
    }

    @Override
    public byte getTileEntityBaseType() {
        return 4;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GTPPMTEFluidPipe(this.mName, this.mThickNess, this.pipeStats, this.mCapacity, this.mHeatResistance, this.mGasProof);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int aColorIndex, boolean aConnected, boolean aRedstone) {
        float tThickNess = this.getThickness();
        if (this.mDisableInput == 0) {
            return new ITexture[]{aConnected ? this.getBaseTexture(tThickNess, this.mPipeAmount, aColorIndex) : TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.pipeStats.rgba))};
        }
        int tMask = 0;
        int[][] sRestrictionArray = new int[][]{{2, 3, 5, 4}, {2, 3, 5, 4}, {1, 0, 5, 4}, {1, 0, 4, 5}, {1, 0, 2, 3}, {1, 0, 2, 3}};
        if (side != ForgeDirection.UNKNOWN) {
            for (int i = 0; i < 4; ++i) {
                if (!this.isInputDisabledAtSide(ForgeDirection.getOrientation((int)sRestrictionArray[side.ordinal()][i]))) continue;
                tMask |= 1 << i;
            }
            if ((side == ForgeDirection.EAST || side == ForgeDirection.UP) && tMask > 3 && tMask < 12) {
                tMask ^= 0xC;
            }
        }
        return new ITexture[]{aConnected ? this.getBaseTexture(tThickNess, this.mPipeAmount, aColorIndex) : TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.pipeStats.rgba)), GTPPMTEFluidPipe.getRestrictorTexture(tMask)};
    }

    protected ITexture getBaseTexture(float aThickNess, int aPipeAmount, int colorIndex) {
        if (aPipeAmount >= 9) {
            return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipeNonuple.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
        }
        if (aPipeAmount >= 4) {
            return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipeQuadruple.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
        }
        if (aThickNess < 0.124f) {
            return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
        }
        if (aThickNess < 0.374f) {
            return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
        }
        if (aThickNess < 0.499f) {
            return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
        }
        if (aThickNess < 0.749f) {
            return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
        }
        if (aThickNess < 0.874f) {
            return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
        }
        return TextureFactory.of(this.pipeStats.iconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(colorIndex, this.pipeStats.rgba));
    }
}

