/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.items;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.Optional;
import gregtech.api.enchants.EnchantmentRadioactivity;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.creative.AddToCreativeTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="forestry.api.arboriculture.IToolGrafter", modid="Forestry"), @Optional.Interface(iface="mods.railcraft.api.core.items.IToolCrowbar", modid="Railcraft"), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft"), @Optional.Interface(iface="crazypants.enderio.api.tool.ITool", modid="EnderIO")})
public abstract class GTMetaTool
extends MetaGeneratedTool
implements IDamagableItem,
IToolCrowbar,
IToolWrench {
    public static final HashMap<String, GTMetaTool> sInstances = new HashMap();
    public final HashMap<Short, IToolStats> mToolStats = new HashMap();

    public GTMetaTool(String aUnlocalized) {
        super(aUnlocalized);
        GTModHandler.registerBoxableItemToToolBox(new ItemStack((Item)this));
        this.func_77637_a(AddToCreativeTab.tabMachines);
        this.func_77625_d(1);
        sInstances.put(this.func_77658_a(), this);
    }

    @Override
    public void onHarvestBlockEvent(ArrayList<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, int aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        if (this.isItemStackUsable(aStack) && this.getDigSpeed(aStack, aBlock, aMetaData) > 0.0f) {
            this.doDamage(aStack, tStats.convertBlockDrops(aDrops, aStack, aPlayer, aBlock, aX, aY, aZ, aMetaData, aFortune, aSilkTouch, aEvent) * tStats.getToolDamagePerDropConversion());
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || !this.isItemStackUsable(aStack)) {
            return true;
        }
        GTUtility.doSoundAtClient(tStats.getEntityHitSound(), 1, 1.0f);
        if (super.onLeftClickEntity(aStack, aPlayer, aEntity)) {
            return true;
        }
        if (aEntity.func_70075_an() && !aEntity.func_85031_j((Entity)aPlayer)) {
            float tMagicDamage = tStats.getMagicDamageAgainstEntity(aEntity instanceof EntityLivingBase ? EnchantmentHelper.func_77512_a((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0.0f, aEntity, aStack, aPlayer);
            float tDamage = tStats.getNormalDamageAgainstEntity((float)aPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + this.getToolCombatDamage(aStack), aEntity, aStack, aPlayer);
            if (tDamage + tMagicDamage > 0.0f) {
                boolean tCriticalHit;
                boolean bl = tCriticalHit = aPlayer.field_70143_R > 0.0f && !aPlayer.field_70122_E && !aPlayer.func_70617_f_() && !aPlayer.func_70090_H() && !aPlayer.func_70644_a(Potion.field_76440_q) && aPlayer.field_70154_o == null && aEntity instanceof EntityLivingBase;
                if (tCriticalHit && tDamage > 0.0f) {
                    tDamage *= 1.5f;
                }
                if (aEntity.func_70097_a(tStats.getDamageSource((EntityLivingBase)aPlayer, aEntity), tDamage += tMagicDamage)) {
                    int tKnockcack;
                    if (aEntity instanceof EntityLivingBase) {
                        aEntity.func_70015_d(EnchantmentHelper.func_90036_a((EntityLivingBase)aPlayer) * 4);
                    }
                    if ((tKnockcack = (aPlayer.func_70051_ag() ? 1 : 0) + (aEntity instanceof EntityLivingBase ? EnchantmentHelper.func_77507_b((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0)) > 0) {
                        aEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(aPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(aPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f));
                        aPlayer.field_70159_w *= 0.6;
                        aPlayer.field_70179_y *= 0.6;
                        aPlayer.func_70031_b(false);
                    }
                    if (tCriticalHit) {
                        aPlayer.func_71009_b(aEntity);
                    }
                    if (tMagicDamage > 0.0f) {
                        aPlayer.func_71047_c(aEntity);
                    }
                    if (tDamage >= 18.0f) {
                        aPlayer.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    aPlayer.func_130011_c(aEntity);
                    if (aEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)aEntity), (Entity)aPlayer);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)aPlayer, (Entity)aEntity);
                    if (aEntity instanceof EntityLivingBase) {
                        aPlayer.func_71064_a(StatList.field_75951_w, Math.round(tDamage * 10.0f));
                    }
                    aEntity.field_70172_ad = Math.max(1, tStats.getHurtResistanceTime(aEntity.field_70172_ad, aEntity));
                    aPlayer.func_71020_j(0.3f);
                    this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
                }
            }
        }
        if (aStack.field_77994_a <= 0) {
            aPlayer.func_71028_bD();
        }
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            aPlayer.func_71008_a(aStack, 72000);
        }
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public void addAdditionalToolTips(List aList, ItemStack aStack) {
        int tOffset;
        long tMaxDamage = GTMetaTool.getToolMaxDamage(aStack);
        Materials tMaterial = GTMetaTool.getPrimaryMaterial(aStack);
        IToolStats tStats = this.getToolStats(aStack);
        int n = tOffset = this.getElectricStats(aStack) != null ? 2 : 1;
        if (tStats != null) {
            String name = aStack.func_77977_a();
            if (name.equals("gt.metatool.01.170") || name.equals("gt.metatool.01.172") || name.equals("gt.metatool.01.174") || name.equals("gt.metatool.01.176")) {
                aList.add(tOffset + 0, EnumChatFormatting.WHITE + "Durability: " + EnumChatFormatting.GREEN + (tMaxDamage - GTMetaTool.getToolDamage(aStack)) + " / " + tMaxDamage + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.WHITE + tMaterial.mDefaultLocalName + EnumChatFormatting.YELLOW + " lvl " + this.getHarvestLevel(aStack, "") + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + "Turbine Efficency: " + EnumChatFormatting.BLUE + (50.0f + 10.0f * this.getToolCombatDamage(aStack)) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + "Optimal Steam flow: " + EnumChatFormatting.LIGHT_PURPLE + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 1000.0f) + EnumChatFormatting.GRAY + "L/sec");
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + "Optimal Gas flow(EU burnvalue per tick): " + EnumChatFormatting.LIGHT_PURPLE + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 25.0f) + EnumChatFormatting.GRAY + "EU/t");
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + "Optimal Plasma flow(Plasma energyvalue per tick): " + EnumChatFormatting.LIGHT_PURPLE + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 1000.0f) + EnumChatFormatting.GRAY + "EU/t");
            } else {
                aList.add(tOffset + 0, EnumChatFormatting.WHITE + "Durability: " + EnumChatFormatting.GREEN + (tMaxDamage - GTMetaTool.getToolDamage(aStack)) + " / " + tMaxDamage + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.WHITE + tMaterial.mDefaultLocalName + EnumChatFormatting.YELLOW + " lvl " + this.getHarvestLevel(aStack, "") + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + "Attack Damage: " + EnumChatFormatting.BLUE + this.getToolCombatDamage(aStack) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + "Mining Speed: " + EnumChatFormatting.LIGHT_PURPLE + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed) + EnumChatFormatting.GRAY);
            }
        }
    }

    public void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
        int tOffset;
        long tMaxDamage = GTMetaTool.getToolMaxDamage(aStack);
        Materials tMaterial = GTMetaTool.getPrimaryMaterial(aStack);
        IToolStats tStats = this.getToolStats(aStack);
        int n = tOffset = this.getElectricStats(aStack) != null ? 2 : 1;
        if (tStats != null) {
            String name = aStack.func_77977_a();
            if (name.equals("gt.metatool.01.170") || name.equals("gt.metatool.01.172") || name.equals("gt.metatool.01.174") || name.equals("gt.metatool.01.176")) {
                aList.add(tOffset + 0, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gtpp.tooltip.tool.durability") + " " + EnumChatFormatting.GREEN + (tMaxDamage - GTMetaTool.getToolDamage(aStack)) + " / " + tMaxDamage + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.WHITE + tMaterial.mDefaultLocalName + EnumChatFormatting.YELLOW + " lvl " + this.getHarvestLevel(aStack, "") + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gtpp.tooltip.tool.turbine_efficiency") + " " + EnumChatFormatting.BLUE + (50.0f + 10.0f * this.getToolCombatDamage(aStack)) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + StatCollector.func_74837_a((String)"gtpp.tooltip.tool.optimal_steam_flow", (Object[])new Object[]{Float.valueOf(Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 1000.0f))}));
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gtpp.tooltip.tool.optimal_gas_flow") + " " + EnumChatFormatting.LIGHT_PURPLE + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f) + EnumChatFormatting.GRAY + "EU/t");
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gtpp.tooltip.tool.optimal_plasma_flow") + " " + EnumChatFormatting.LIGHT_PURPLE + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 1000.0f) + EnumChatFormatting.GRAY + "EU/t");
            } else {
                aList.add(tOffset + 0, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gtpp.tooltip.tool.durability") + " " + EnumChatFormatting.GREEN + (tMaxDamage - GTMetaTool.getToolDamage(aStack)) + " / " + tMaxDamage + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.WHITE + tMaterial.mDefaultLocalName + EnumChatFormatting.YELLOW + " lvl " + this.getHarvestLevel(aStack, "") + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gtpp.tooltip.tool.attack_damage") + " " + EnumChatFormatting.BLUE + this.getToolCombatDamage(aStack) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gtpp.tooltip.tool.mining_speed") + " " + EnumChatFormatting.LIGHT_PURPLE + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed) + EnumChatFormatting.GRAY);
                NBTTagCompound aNBT = aStack.func_77978_p();
                if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null && aNBT.func_74764_b("Heat")) {
                    int tHeat = aNBT.func_74762_e("Heat");
                    long tWorldTime = aPlayer.func_130014_f_().func_72820_D();
                    if (aNBT.func_74764_b("HeatTime")) {
                        long tHeatTime = aNBT.func_74763_f("HeatTime");
                        if (tWorldTime > tHeatTime + 10L && (tHeat = (int)((long)tHeat - (tWorldTime - tHeatTime) / 10L)) < 300 && tHeat > -10000) {
                            tHeat = 300;
                        }
                        aNBT.func_74772_a("HeatTime", tWorldTime);
                        if (tHeat > -10000) {
                            aNBT.func_74768_a("Heat", tHeat);
                        }
                    }
                    aList.add(tOffset + 3, EnumChatFormatting.RED + StatCollector.func_74837_a((String)"GT5U.tooltip.tool.heat", (Object[])new Object[]{aNBT.func_74762_e("Heat")}) + EnumChatFormatting.GRAY);
                }
            }
        }
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return null;
    }

    @Override
    public Long[] getElectricStats(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null && aNBT.func_74767_n("Electric")) {
            return new Long[]{aNBT.func_74763_f("MaxCharge"), aNBT.func_74763_f("Voltage"), aNBT.func_74763_f("Tier"), aNBT.func_74763_f("SpecialData")};
        }
        return new Long[0];
    }

    @Override
    public float getToolCombatDamage(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return 0.0f;
        }
        return tStats.getBaseDamage() + (float)GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
    }

    @Override
    public float getDigSpeed(ItemStack aStack, Block aBlock, int aMetaData) {
        if (!this.isItemStackUsable(aStack)) {
            return 0.0f;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || Math.max(0, this.getHarvestLevel(aStack, "")) < aBlock.getHarvestLevel(aMetaData)) {
            return 0.0f;
        }
        return tStats.isMinableBlock(aBlock, aMetaData) ? Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GTMetaTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed) : 0.0f;
    }

    @Override
    public boolean func_150894_a(ItemStack aStack, World aWorld, Block aBlock, int aX, int aY, int aZ, EntityLivingBase aPlayer) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return false;
        }
        GTUtility.doSoundAtClient(tStats.getMiningSound(), 1, 1.0f);
        this.doDamage(aStack, (int)Math.max(1.0f, aBlock.func_149712_f(aWorld, aX, aY, aZ) * (float)tStats.getToolDamagePerBlockBreak()));
        return this.getDigSpeed(aStack, aBlock, aWorld.func_72805_g(aX, aY, aZ)) > 0.0f;
    }

    private ItemStack getContainerItem(ItemStack aStack, boolean playSound) {
        if (!this.isItemStackUsable(aStack)) {
            return null;
        }
        IToolStats tStats = this.getToolStats(aStack = GTUtility.copyAmount(1, aStack));
        if (tStats == null) {
            return null;
        }
        this.doDamage(aStack, tStats.getToolDamagePerContainerCraft());
        Object object = aStack = aStack.field_77994_a > 0 ? aStack : null;
        if (playSound) {
            // empty if block
        }
        return aStack;
    }

    @Override
    public IToolStats getToolStats(ItemStack aStack) {
        this.isItemStackUsable(aStack);
        return this.getToolStatsInternal(aStack);
    }

    private IToolStats getToolStatsInternal(ItemStack aStack) {
        return aStack == null ? null : this.mToolStats.get((short)aStack.func_77960_j());
    }

    @Override
    public boolean canWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    @Override
    public void onWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    @Override
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        if (player == null) {
            return false;
        }
        if (player.func_71045_bC() == null) {
            return false;
        }
        if (!this.isItemStackUsable(player.func_71045_bC())) {
            return false;
        }
        IToolStats tStats = this.getToolStats(player.func_71045_bC());
        return tStats != null && tStats.isWrench();
    }

    @Override
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        if (player == null) {
            return;
        }
        if (player.func_71045_bC() == null) {
            return;
        }
        IToolStats tStats = this.getToolStats(player.func_71045_bC());
        if (tStats != null) {
            this.doDamage(player.func_71045_bC(), tStats.getToolDamagePerEntityAttack());
        }
    }

    @Override
    public boolean canLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    @Override
    public void onLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    @Override
    public boolean canBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    @Override
    public void onBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    @Override
    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && aPlayer != null) {
            tStats.onToolCrafted(aStack, aPlayer);
        }
        super.func_77622_d(aStack, aWorld, aPlayer);
    }

    @Override
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (aStack.func_77960_j() % 2 == 1 || tStats == null) {
            NBTTagCompound aNBT = aStack.func_77978_p();
            if (aNBT != null) {
                aNBT.func_82580_o("ench");
            }
            return false;
        }
        Materials aMaterial = GTMetaTool.getPrimaryMaterial(aStack);
        HashMap<Integer, Integer> tMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> tResult = new HashMap<Integer, Integer>();
        if (aMaterial.mEnchantmentTools != null) {
            tMap.put(aMaterial.mEnchantmentTools.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            if (aMaterial.mEnchantmentTools == Enchantment.field_77346_s) {
                tMap.put(Enchantment.field_77335_o.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
            if (aMaterial.mEnchantmentTools == Enchantment.field_77337_m) {
                tMap.put(Enchantment.field_77345_t.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
            if (aMaterial.mEnchantmentTools == Enchantment.field_77334_n) {
                tMap.put(Enchantment.field_77343_v.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
        }
        Enchantment[] tEnchants = tStats.getEnchantments(aStack);
        int[] tLevels = tStats.getEnchantmentLevels(aStack);
        for (int i = 0; i < tEnchants.length; ++i) {
            if (tLevels[i] <= 0) continue;
            Integer tLevel = (Integer)tMap.get(tEnchants[i].field_77352_x);
            tMap.put(tEnchants[i].field_77352_x, tLevel == null ? tLevels[i] : (tLevel == tLevels[i] ? tLevel + 1 : Math.max(tLevel, tLevels[i])));
        }
        for (Map.Entry tEntry : tMap.entrySet()) {
            if ((Integer)tEntry.getKey() == 33 || (Integer)tEntry.getKey() == 20 && (Integer)tEntry.getValue() > 2 || (Integer)tEntry.getKey() == EnchantmentRadioactivity.INSTANCE.field_77352_x) {
                tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                continue;
            }
            switch (Enchantment.field_77331_b[((Integer)tEntry.getKey()).intValue()].field_77351_y) {
                case weapon: {
                    if (!tStats.isWeapon()) break;
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                    break;
                }
                case all: {
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                    break;
                }
                case armor: 
                case armor_feet: 
                case armor_head: 
                case armor_legs: 
                case armor_torso: {
                    break;
                }
                case bow: {
                    if (!tStats.isRangedWeapon()) break;
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                    break;
                }
                case breakable: {
                    break;
                }
                case fishing_rod: {
                    break;
                }
                case digger: {
                    if (!tStats.isMiningTool()) break;
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                }
            }
        }
        EnchantmentHelper.func_82782_a(tResult, (ItemStack)aStack);
        return true;
    }

    @Override
    public short getChargedMetaData(ItemStack aStack) {
        return (short)(aStack.func_77960_j() - aStack.func_77960_j() % 2);
    }

    @Override
    public short getEmptyMetaData(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            aNBT.func_82580_o("ench");
        }
        return (short)(aStack.func_77960_j() + 1 - aStack.func_77960_j() % 2);
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }
}

