/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.registry;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Arrays;
import java.util.function.Consumer;

public enum GTPP_BranchDefinition {
    LEGENDARY("gtpp.legendary", "Summa Potestas", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.END);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGER);
    });

    private static IAllele[] defaultTemplate;
    private final IClassification branch;
    private final Consumer<IAllele[]> mBranchProperties;

    private GTPP_BranchDefinition(String internal, String scientific, Consumer<IAllele[]> aBranchProperties) {
        this.branch = BeeManager.beeFactory.createBranch(internal.toLowerCase(), scientific);
        this.mBranchProperties = aBranchProperties;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERANT_FLYER, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }

    private void setBranchProperties(IAllele[] template) {
        this.mBranchProperties.accept(template);
    }

    public final IAllele[] getTemplate() {
        IAllele[] template = GTPP_BranchDefinition.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public final IClassification getBranch() {
        return this.branch;
    }
}

