/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.recipes;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.fluids.GTPPFluids;
import gtPlusPlus.core.util.reflect.AddGregtechRecipe;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CokeAndPyrolyseOven {
    public static void onLoadComplete() {
        CokeAndPyrolyseOven.convertPyroToCokeOven();
    }

    public static void postInit() {
        ArrayList aLogData = OreDictionary.getOres((String)"logWood");
        for (ItemStack stack : aLogData) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(20), GTUtility.copyAmount(20, stack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, Materials.Charcoal, 24L)).fluidInputs(GTModHandler.getSteam(1000L)).fluidOutputs(new FluidStack(GTPPFluids.CoalGas, 1440)).duration(1440).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.pyrolyseRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(22), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 16L)).itemOutputs(GTOreDictUnificator.get("fuelCoke", 10L)).fluidInputs(GTModHandler.getSteam(1000L)).fluidOutputs(new FluidStack(GTPPFluids.CoalGas, 2880)).duration(720).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.pyrolyseRecipes);
        CokeAndPyrolyseOven.addCokingRecipes(new ItemStack(Blocks.field_150434_aF, 20), GregtechItemList.CactusCharcoal.get(20L, new Object[0]), GregtechItemList.CactusCoke.get(20L, new Object[0]));
        CokeAndPyrolyseOven.addCokingRecipes(new ItemStack(Items.field_151120_aE, 20), GregtechItemList.SugarCharcoal.get(20L, new Object[0]), GregtechItemList.SugarCoke.get(20L, new Object[0]));
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 12L), GTOreDictUnificator.get("fuelCoke", 6L)).itemOutputs(GTOreDictUnificator.get("fuelCoke", 14L)).fluidInputs(GTModHandler.getSteam(2000L)).fluidOutputs(new FluidStack(GTPPFluids.CoalGas, 5040)).eut(240).duration(1200).addTo(GTPPRecipeMaps.cokeOvenRecipes);
    }

    private static void addCokingRecipes(ItemStack plant, ItemStack charcoal, ItemStack coke) {
        GTValues.RA.stdBuilder().itemInputs(plant, GTUtility.getIntegratedCircuit(3)).itemOutputs(charcoal).fluidOutputs(Materials.Creosote.getFluid(2000L)).eut(16).duration(500).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(plant, GTUtility.getIntegratedCircuit(4)).itemOutputs(charcoal).fluidInputs(Materials.Nitrogen.getGas(2000L)).fluidOutputs(Materials.CharcoalByproducts.getGas(4000L)).eut(16).duration(250).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(charcoal, GTUtility.getIntegratedCircuit(3)).itemOutputs(coke).fluidOutputs(Materials.Creosote.getFluid(4000L)).eut(16).duration(1000).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(charcoal, GTUtility.getIntegratedCircuit(4)).itemOutputs(coke).fluidInputs(Materials.Nitrogen.getGas(1000L)).fluidOutputs(Materials.CharcoalByproducts.getGas(2000L)).eut(16).duration(500).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(coke, GTUtility.getIntegratedCircuit(5)).itemOutputs(Materials.Ash.getDust(5)).fluidInputs(GTModHandler.getSteam(2000L)).fluidOutputs(Materials.WoodTar.getFluid(4000L)).eut(240).duration(1500).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(coke, GTUtility.getIntegratedCircuit(6)).itemOutputs(Materials.Ash.getDust(5)).fluidInputs(GTModHandler.getSteam(2000L)).fluidOutputs(Materials.WoodGas.getGas(6000L)).eut(240).duration(1500).addTo(RecipeMaps.pyrolyseRecipes);
    }

    private static void convertPyroToCokeOven() {
        int aCount = 0;
        for (GTRecipe g : RecipeMaps.pyrolyseRecipes.getAllRecipes()) {
            if (!AddGregtechRecipe.importPyroRecipe(g.copy())) continue;
            ++aCount;
        }
        Logger.INFO("Converted " + aCount + " Pyrolyse recipes into Industrial Coke Oven recipes.");
    }
}

