/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.fluids.GTPPFluids;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLoaderCoalTar {
    public static void generate() {
        RecipeLoaderCoalTar.recipeCreateEthylene();
        RecipeLoaderCoalTar.recipeCreateBenzene();
        RecipeLoaderCoalTar.recipeCreateEthylbenzene();
        RecipeLoaderCoalTar.recipeCoalToCoalTar();
        RecipeLoaderCoalTar.recipeCoalTarToCoalTarOil();
        RecipeLoaderCoalTar.recipeCoalTarOilToSulfuricOilToNaphthalene();
        RecipeLoaderCoalTar.recipeNaphthaleneToPhthalicAcid();
        RecipeLoaderCoalTar.recipePhthalicAcidToPhthalicAnhydride();
        RecipeLoaderCoalTar.generateFuelRecipes();
    }

    private static void recipeCreateEthylene() {
        FluidStack bioEth1 = FluidRegistry.getFluidStack((String)"fluid.bioethanol", (int)1000);
        FluidStack bioEth2 = FluidRegistry.getFluidStack((String)"bioethanol", (int)1000);
        if (bioEth1 != null) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17), ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(Materials.Ethylene.getCells(1)).fluidInputs(bioEth1).fluidOutputs(GTModHandler.getWater(1000L)).eut(80).duration(2400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        }
        if (bioEth2 != null) {
            GTValues.RA.stdBuilder().itemInputs(ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(Materials.Ethylene.getCells(1)).fluidInputs(bioEth2).fluidOutputs(GTModHandler.getWater(1000L)).eut(80).duration(2400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        }
    }

    private static void recipeCreateBenzene() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Toluene.getCells(1)).itemOutputs(Materials.Benzene.getCells(1)).fluidInputs(Materials.Hydrogen.getGas(2000L)).fluidOutputs(Materials.Methane.getGas(1000L)).duration(200).eut(90).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    private static void recipeCreateEthylbenzene() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Ethylene.getCells(2), GTUtility.getIntegratedCircuit(3)).itemOutputs(ItemList.Cell_Empty.get(2L, new Object[0])).fluidInputs(Materials.Benzene.getFluid(2000L)).fluidOutputs(new FluidStack(GTPPFluids.Ethylbenzene, 2000)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(Materials.Benzene.getCells(2), GTUtility.getIntegratedCircuit(3)).itemOutputs(ItemList.Cell_Empty.get(2L, new Object[0])).fluidInputs(Materials.Ethylene.getGas(2000L)).fluidOutputs(new FluidStack(GTPPFluids.Ethylbenzene, 2000)).duration(300).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.chemicalReactorRecipes);
    }

    private static void recipeCoalToCoalTar() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Charcoal, 32L)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDirt", 2)).fluidOutputs(new FluidStack(GTPPFluids.CoalTar, 800)).duration(360).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 16L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.DarkAsh, 2L)).fluidOutputs(new FluidStack(GTPPFluids.CoalTar, 800)).duration(1080).eut(60).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 12L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.DarkAsh, 2L)).fluidOutputs(new FluidStack(GTPPFluids.CoalTar, 2200)).duration(720).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), GTOreDictUnificator.get("fuelCoke", 8L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Ash, 3L)).fluidOutputs(new FluidStack(GTPPFluids.CoalTar, 3400)).duration(360).eut(240).addTo(RecipeMaps.pyrolyseRecipes);
    }

    private static void recipeCoalTarToCoalTarOil() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).fluidInputs(new FluidStack(GTPPFluids.CoalTar, 1000)).fluidOutputs(new FluidStack(GTPPFluids.CoalTarOil, 600)).duration(600).eut(64).addTo(RecipeMaps.distilleryRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(2)).fluidInputs(new FluidStack(GTPPFluids.CoalTar, 1000)).fluidOutputs(Materials.Naphtha.getFluid(150L)).duration(600).eut(64).addTo(RecipeMaps.distilleryRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3)).fluidInputs(new FluidStack(GTPPFluids.CoalTar, 1000)).fluidOutputs(new FluidStack(GTPPFluids.Ethylbenzene, 200)).duration(600).eut(64).addTo(RecipeMaps.distilleryRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4)).fluidInputs(new FluidStack(GTPPFluids.CoalTar, 1000)).fluidOutputs(new FluidStack(GTPPFluids.Anthracene, 50)).duration(600).eut(64).addTo(RecipeMaps.distilleryRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(5)).fluidInputs(new FluidStack(GTPPFluids.CoalTar, 1000)).fluidOutputs(new FluidStack(GTPPFluids.Kerosene, 600)).duration(600).eut(64).addTo(RecipeMaps.distilleryRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(GTPPFluids.CoalTar, 1000)).fluidOutputs(new FluidStack(GTPPFluids.CoalTarOil, 600), Materials.Naphtha.getFluid(150L), new FluidStack(GTPPFluids.Ethylbenzene, 200), new FluidStack(GTPPFluids.Anthracene, 50), new FluidStack(GTPPFluids.Kerosene, 600)).duration(300).eut(256).addTo(RecipeMaps.distillationTowerRecipes);
    }

    private static void recipeCoalTarOilToSulfuricOilToNaphthalene() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTarOil", 8), Materials.SulfuricAcid.getCells(8)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricCoalTarOil", 16)).duration(320).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(6)).fluidInputs(new FluidStack(GTPPFluids.SulfuricCoalTarOil, 20)).fluidOutputs(new FluidStack(GTPPFluids.Naphthalene, 20)).eut(TierEU.RECIPE_LV).duration(20).addTo(RecipeMaps.distilleryRecipes);
    }

    private static void recipeNaphthaleneToPhthalicAcid() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Lithium.getDust(5)).fluidInputs(new FluidStack(GTPPFluids.Naphthalene, 2000)).fluidOutputs(Materials.PhthalicAcid.getFluid(2500L)).eut(30).duration(320).addTo(GTRecipeConstants.UniversalChemical);
    }

    private static void recipePhthalicAcidToPhthalicAnhydride() {
        GTValues.RA.stdBuilder().itemOutputs(GregtechItemList.PhthalicAnhydrideDust.get(15L, new Object[0])).fluidInputs(Materials.PhthalicAcid.getFluid(1000L)).eut(TierEU.RECIPE_MV).duration(1200).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    private static void generateFuelRecipes() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalGas", 1)).metadata(GTRecipeConstants.FUEL_VALUE, 96).metadata(GTRecipeConstants.FUEL_TYPE, GTRecipeConstants.FuelType.GasTurbine.ordinal()).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(GTPPFluids.SulfuricCoalTarOil, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 64).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(GTPPFluids.CoalTarOil, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 32).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(GTPPFluids.CoalTar, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 16).addTo(GTPPRecipeMaps.semiFluidFuels);
    }
}

