/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.item.base.misc.BaseItemParticle;
import gtPlusPlus.core.util.Utils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class IonParticles
extends BaseItemParticle {
    public static HashMap<String, Integer> NameToMetaMap = new HashMap();
    public static HashMap<Integer, String> MetaToNameMap = new HashMap();
    public static final String[] ions = new String[]{"Hydrogen", "Helium"};
    public IIcon[] texture = new IIcon[ions.length];

    public IonParticles() {
        super("Ion", ions.length, EnumRarity.rare);
    }

    @Override
    public String[] getAffixes() {
        return new String[]{"", ""};
    }

    public String func_77658_a() {
        return "";
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.particle.ion." + ions[itemStack.func_77960_j()];
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Charge", 0L);
        tagMain.func_74782_a("Ion", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static long getChargeState(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("Ion")) != null) {
                return aNBT.func_74763_f("Charge");
            }
        } else {
            IonParticles.createNBT(aStack);
        }
        return 0L;
    }

    public static boolean setChargeState(ItemStack aStack, long aCharge) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("Ion")) != null) {
            aNBT.func_74772_a("Charge", aCharge);
            return true;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            IonParticles.createNBT(stack);
        }
        return IonParticles.getChargeState(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        long aCharge = IonParticles.getChargeState(stack);
        String ionName = MetaToNameMap.get(stack.func_77960_j());
        if (aCharge == 0L) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"gtpp.tooltip.ion_particles.state_not_set", (Object[])new Object[]{ionName}));
        } else if (aCharge > 0L) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"gtpp.tooltip.ion_particles.charge_positive", (Object[])new Object[]{ionName, aCharge}));
        } else {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"gtpp.tooltip.ion_particles.charge_negative", (Object[])new Object[]{ionName, aCharge}));
        }
        super.func_77624_a(stack, player, list, bool);
    }

    public void func_94581_a(IIconRegister reg) {
        for (int i = 0; i < this.texture.length; ++i) {
            this.texture[i] = reg.func_94245_a(Mods.GTPlusPlus.ID + ":ion" + i);
        }
    }

    public IIcon func_77617_a(int meta) {
        return this.texture[meta];
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon func_77618_c(int aMeta, int aPass) {
        return this.texture[aMeta];
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    static {
        int key = 0;
        for (String s : ions) {
            NameToMetaMap.put(Utils.sanitizeString(s.toLowerCase()), key);
            MetaToNameMap.put(key, Utils.sanitizeString(s.toLowerCase()));
            Materials m = Materials.get(s);
            int aColour = 0;
            aColour = m == null ? Utils.rgbtoHexValue(128, 128, 128) : Utils.rgbtoHexValue(m.mRGBa[0], m.mRGBa[1], m.mRGBa[2]);
            aColourMap.put(key++, aColour);
        }
    }
}

