/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.postload.chains;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.system.material.WerkstoffLoader;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class NetheriteRecipes {
    static ItemStack missing = new ItemStack((Block)Blocks.field_150480_ab);

    public static void run() {
        GTValues.RA.stdBuilder().fluidInputs(Materials.NetherAir.getFluid(10000L)).fluidOutputs(Materials.NitrogenDioxide.getGas(1400L), Materials.SulfurDioxide.getGas(3800L), Materials.SulfurTrioxide.getGas(2100L)).duration(1200).eut(TierEU.RECIPE_LV).addTo(GTPPRecipeMaps.centrifugeNonCellRecipes);
        GTValues.RA.stdBuilder().fluidInputs(Materials.NetherAir.getFluid(1000L)).fluidOutputs(Materials.NetherSemiFluid.getFluid(100L)).duration(200).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.vacuumFreezerRecipes);
        GTValues.RA.stdBuilder().fluidInputs(Materials.NetherSemiFluid.getFluid(100000L)).itemOutputs(ItemList.Heavy_Hellish_Mud.get(2L, new Object[0])).fluidOutputs(Materials.NefariousGas.getFluid(4000L), FluidUtils.getFluidStack("fluid.coalgas", 16000), FluidUtils.getFluidStack("fluid.anthracene", 70000), Materials.SulfurTrioxide.getGas(210000L), Materials.SulfurDioxide.getGas(380000L), Materials.NitrogenDioxide.getGas(140000L), WerkstoffLoader.Neon.getFluidOrGas(36000)).duration(480).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.distillationTowerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cell, Materials.NefariousGas, 1L)).metadata(GTRecipeConstants.FUEL_VALUE, 1200).metadata(GTRecipeConstants.FUEL_TYPE, 1).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).fluidInputs(Materials.Grade1PurifiedWater.getFluid(8000L), Materials.NefariousGas.getFluid(16000L)).fluidOutputs(Materials.NefariousOil.getFluid(12000L)).duration(520).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.crackingRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).fluidInputs(Materials.Grade2PurifiedWater.getFluid(4000L), Materials.NefariousGas.getFluid(16000L)).fluidOutputs(Materials.NefariousOil.getFluid(12000L)).duration(120).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.crackingRecipes);
        GTValues.RA.stdBuilder().fluidInputs(Materials.NefariousOil.getFluid(1000L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 572).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Heavy_Hellish_Mud.get(32L, new Object[0])).fluidInputs(Materials.PoorNetherWaste.getFluid(16000L)).fluidOutputs(Materials.RichNetherWaste.getFluid(16000L)).duration(300).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GregtechItemList.TripleCompressedNetherrack.get(1L, new Object[0]), GTModHandler.getModItem(Mods.ThaumicTinkerer.ID, "kamiResource", 64L, 6, missing)).itemOutputs(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "ancient_debris", 1L)).duration(1).eut(TierEU.RECIPE_UEV).addTo(BartWorksRecipeMaps.electricImplosionCompressorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "ancient_debris", 1L, missing)).itemOutputs(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_scrap", 1L, missing), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_scrap", 1L, missing)).outputChances(10000, 2500).duration(540).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.hammerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_scrap", 1L, missing)).fluidInputs(FluidUtils.getLava(100)).itemOutputs(ItemList.Hot_Netherite_Scrap.get(1L, new Object[0])).duration(500).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.chemicalBathRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Hot_Netherite_Scrap.get(2L, new Object[0])).fluidInputs(Materials.RichNetherWaste.getFluid(2000L)).itemOutputs(ItemList.Netherite_Scrap_Seed.get(1L, new Object[0]), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_scrap", 2L, missing)).outputChances(1000, 10000).duration(1200).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.autoclaveRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Hot_Netherite_Scrap.get(64L, new Object[0]), ItemList.Heavy_Hellish_Mud.get(64L, new Object[0])).fluidInputs(Materials.PoorNetherWaste.getFluid(32000L)).itemOutputs(ItemList.Brittle_Netherite_Scrap.get(4L, new Object[0]), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_scrap", 64L, missing)).duration(900).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.chemicalBathRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Netherite_Scrap_Seed.get(1L, new Object[0])).fluidInputs(Materials.PoorNetherWaste.getFluid(16000L)).itemOutputs(ItemList.Brittle_Netherite_Scrap.get(1L, new Object[0]), ItemList.Netherite_Scrap_Seed.get(1L, new Object[0])).outputChances(5000, 5000).duration(1200).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.chemicalBathRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Brittle_Netherite_Scrap.get(1L, new Object[0])).itemOutputs(ItemList.Netherite_Nanoparticles.get(1L, new Object[0])).duration(320).eut(TierEU.RECIPE_LuV).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Netherite_Nanoparticles.get(1L, new Object[0])).fluidInputs(Materials.HellishMetal.getMolten(144L)).itemOutputs(ItemList.Intensely_Bonded_Netherite_Nanoparticles.get(1L, new Object[0])).fluidOutputs(Materials.Thaumium.getMolten(32L)).duration(300).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COIL_HEAT, 7500).addTo(RecipeMaps.blastFurnaceRecipes);
        NetheriteRecipes.addNetheriteParts();
    }

    private static void addNetheriteParts() {
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.ingot, 1, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.plate, 1, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.plateDouble, 1, 2);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.plateDense, 1, 9);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.stick, 2, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.round, 9, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.bolt, 8, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.screw, 8, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.ring, 4, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.foil, 8, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.itemCasing, 2, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.gearGtSmall, 1, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.rotor, 1, 5);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.stickLong, 1, 1);
        NetheriteRecipes.addNetheritePartRecipe(OrePrefixes.gearGt, 1, 4);
        NetheriteRecipes.addNetheritePartRecipe(GTOreDictUnificator.get(OrePrefixes.block, Materials.InfusedGold, 1L), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_block", 1L, missing), 9);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, Materials.Netherite, 4L), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.frameGt, Materials.Netherite, 1L)).duration(64).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, Materials.Netherite, 64L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateSuperdense, Materials.Netherite, 1L)).duration(10000).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COMPRESSION_TIER, 1).addTo(RecipeMaps.compressorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Netherite, 2L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.InfusedGold, 1L), ItemList.Netherite_Nanoparticles.get(1L, new Object[0])).duration(468).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Netherite, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Netherite, 1L)).duration(98).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_block", 3L, missing)).itemOutputs(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "netherite_stairs", 4L, missing)).duration(72000).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.cutterRecipes);
    }

    private static void addNetheritePartRecipe(OrePrefixes prefix, int multiplier, int inverseMultiplier) {
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix, Materials.InfusedGold, (long)multiplier), ItemList.Intensely_Bonded_Netherite_Nanoparticles.get(inverseMultiplier, new Object[0])).itemOutputs(GTOreDictUnificator.get(prefix, Materials.Netherite, (long)multiplier)).fluidInputs(Materials.Boron.getPlasma(2L * (long)inverseMultiplier)).fluidOutputs(Materials.Boron.getMolten(2L * (long)inverseMultiplier)).duration(680).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.plasmaArcFurnaceRecipes);
    }

    private static void addNetheritePartRecipe(ItemStack inputStack, ItemStack outputStack, int inverseMultiplier) {
        GTValues.RA.stdBuilder().itemInputs(inputStack, ItemList.Intensely_Bonded_Netherite_Nanoparticles.get(inverseMultiplier, new Object[0])).itemOutputs(outputStack).fluidInputs(Materials.Boron.getPlasma(2L * (long)inverseMultiplier)).fluidOutputs(Materials.Boron.getMolten(2L * (long)inverseMultiplier)).duration(640).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.plasmaArcFurnaceRecipes);
    }
}

