/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import ic2.core.Ic2Items;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.ThaumcraftApiHelper;

public class GTAchievements {
    public static int oreReg = -1;
    public static int assReg = -1;
    public ConcurrentHashMap<String, Achievement> achievementList = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Boolean> issuedAchievements = new ConcurrentHashMap();
    public int adjX = 5;
    public int adjY = 9;

    public GTAchievements() {
        for (GTRecipe recipe : RecipeMaps.assemblylineVisualRecipes.getAllRecipes()) {
            this.registerAssAchievement(recipe);
        }
        this.registerAchievement("flintpick", 0, 0, MetaGeneratedTool01.INSTANCE.getToolWithStats(2, 1, Materials.Flint, Materials.Wood, null), "", false);
        this.registerAchievement("crops", -4, 0, GTModHandler.getIC2Item("crop", 1L), "flintpick", false);
        this.registerAchievement("havestlead", -4, 2, ItemList.Crop_Drop_Plumbilia.get(1L, new Object[0]), "crops", false);
        this.registerAchievement("havestcopper", -2, 1, ItemList.Crop_Drop_Coppon.get(1L, new Object[0]), "crops", false);
        this.registerAchievement("havesttin", -2, -1, ItemList.Crop_Drop_Tine.get(1L, new Object[0]), "crops", false);
        this.registerAchievement("havestoil", -4, -4, ItemList.Crop_Drop_OilBerry.get(1L, new Object[0]), "crops", false);
        this.registerAchievement("havestiron", -2, -3, ItemList.Crop_Drop_Ferru.get(1L, new Object[0]), "crops", false);
        this.registerAchievement("havestgold", -2, -6, ItemList.Crop_Drop_Aurelia.get(1L, new Object[0]), "havestiron", false);
        this.registerAchievement("havestsilver", -4, -5, ItemList.Crop_Drop_Argentia.get(1L, new Object[0]), "havestiron", false);
        this.registerAchievement("havestemeralds", -2, -8, ItemList.Crop_Drop_BobsYerUncleRanks.get(1L, new Object[0]), "havestgold", false);
        this.registerAchievement("tools", 0, 4, MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HARDHAMMER.ID, 1, Materials.Iron, Materials.Wood, null), "flintpick", false);
        this.registerAchievement("driltime", 2, 4, MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_LV.ID, 1, Materials.BlueSteel, Materials.StainlessSteel, null), "tools", false);
        this.registerAchievement("brrrr", 2, 6, MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_LV.ID, 1, Materials.BlueSteel, Materials.StainlessSteel, null), "driltime", false);
        this.registerAchievement("highpowerdrill", 3, 5, MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_HV.ID, 1, Materials.TungstenSteel, Materials.TungstenSteel, null), "driltime", false);
        this.registerAchievement("hammertime", 3, 7, MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.JACKHAMMER.ID, 1, Materials.TungstenSteel, Materials.TungstenSteel, null), "highpowerdrill", false);
        this.registerAchievement("unitool", -2, 4, MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.UNIVERSALSPADE.ID, 1, Materials.Steel, Materials.Iron, null), "tools", false);
        this.registerAchievement("recycling", -4, 4, ItemList.Machine_LV_ArcFurnace.get(1L, new Object[0]), "unitool", false);
        this.registerAchievement("crushed", 0, 6, GTOreDictUnificator.get(OrePrefixes.crushed, Materials.Tin, 1L), "tools", false);
        this.registerAchievement("cleandust", 0, 10, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Redstone, 1L), "crushed", false);
        this.registerAchievement("washing", -2, 6, GTOreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Iron, 1L), "crushed", false);
        this.registerAchievement("spinit", -4, 6, GTOreDictUnificator.get(OrePrefixes.crushedCentrifuged, Materials.Redstone, 1L), "crushed", false);
        this.registerAchievement("newfuel", -4, 8, ItemList.ThoriumCell_4.get(1L, new Object[0]), "spinit", false);
        this.registerAchievement("newmetal", -4, 10, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Lutetium, 1L), "newfuel", false);
        this.registerAchievement("reflect", -2, 9, ItemList.Neutron_Reflector.get(1L, new Object[0]), "newfuel", false);
        this.registerAchievement("bronze", 2, 0, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Bronze, 1L), "flintpick", false);
        this.registerAchievement("simplyeco", 2, 2, ItemList.Machine_Bronze_Boiler_Solar.get(1L, ItemList.Machine_HP_Solar.get(1L, new Object[0])), "bronze", false);
        this.registerAchievement("firststeam", 2, -2, ItemList.Machine_Bronze_Boiler.get(1L, new Object[0]), "bronze", false);
        this.registerAchievement("alloysmelter", 2, -4, ItemList.Machine_Bronze_AlloySmelter.get(1L, new Object[0]), "firststeam", false);
        this.registerAchievement("macerator", 0, -2, ItemList.Machine_Bronze_Macerator.get(1L, new Object[0]), "firststeam", false);
        this.registerAchievement("extract", 0, -4, ItemList.Machine_Bronze_Extractor.get(1L, new Object[0]), "alloysmelter", false);
        this.registerAchievement("smallparts", 0, -5, ItemList.Circuit_Primitive.get(1L, new Object[0]), "alloysmelter", false);
        this.registerAchievement("gtbasiccircuit", 0, -8, Ic2Items.electronicCircuit.func_77946_l(), "smallparts", false);
        this.registerAchievement("bettercircuits", 0, -9, ItemList.Circuit_Good.get(1L, new Object[0]), "gtbasiccircuit", false);
        this.registerAchievement("stepforward", -2, -9, Ic2Items.advancedCircuit.func_77946_l(), "bettercircuits", false);
        this.registerAchievement("gtmonosilicon", -5, -10, ItemList.Circuit_Silicon_Ingot.get(1L, new Object[0]), "stepforward", false);
        this.registerAchievement("gtlogicwafer", -7, -10, ItemList.Circuit_Wafer_ILC.get(1L, new Object[0]), "gtmonosilicon", false);
        this.registerAchievement("gtlogiccircuit", -9, -10, ItemList.Circuit_Basic.get(1L, new Object[0]), "gtlogicwafer", false);
        this.registerAchievement("gtcleanroom", -11, -10, ItemList.Machine_Multi_Cleanroom.get(1L, new Object[0]), "gtlogiccircuit", false);
        this.registerAchievement("energyflow", -13, -10, ItemList.Circuit_Nanoprocessor.get(1L, new Object[0]), "gtcleanroom", false);
        this.registerAchievement("gtquantumprocessor", -13, -12, ItemList.Circuit_Quantumprocessor.get(1L, new Object[0]), "energyflow", false);
        this.registerAchievement("gtcrystalprocessor", -11, -12, ItemList.Circuit_Crystalprocessor.get(1L, new Object[0]), "gtquantumprocessor", false);
        this.registerAchievement("gtwetware", -9, -12, ItemList.Circuit_Neuroprocessor.get(1L, new Object[0]), "gtcrystalprocessor", false);
        this.registerAchievement("gtwetmain", -7, -12, ItemList.Circuit_Wetwaremainframe.get(1L, new Object[0]), "gtwetware", false);
        this.registerAchievement("orbs", -10, -14, ItemList.Energy_LapotronicOrb.get(1L, new Object[0]), "energyflow", false);
        this.registerAchievement("thatspower", -8, -14, ItemList.Energy_LapotronicOrb2.get(1L, new Object[0]), "orbs", false);
        this.registerAchievement("datasaving", -2, -12, ItemList.Tool_DataOrb.get(1L, new Object[0]), "stepforward", false);
        this.registerAchievement("superbuffer", 0, -12, ItemList.Automation_SuperBuffer_LV.get(1L, new Object[0]), "datasaving", false);
        this.registerAchievement("newstorage", -2, -14, ItemList.Quantum_Chest_HV.get(1L, new Object[0]), "superbuffer", false);
        this.registerAchievement("whereistheocean", 2, -14, ItemList.Quantum_Tank_IV.get(1L, new Object[0]), "superbuffer", false);
        this.registerAchievement("luck", 2, -6, ItemList.ZPM.get(1L, new Object[0]), "", false);
        this.registerAchievement("steel", 4, 0, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 1L), "bronze", false);
        this.registerAchievement("highpressure", 4, 2, ItemList.Machine_Steel_Boiler.get(1L, new Object[0]), "steel", false);
        this.registerAchievement("extremepressure", 4, 4, ItemList.Machine_Multi_LargeBoiler_Steel.get(1L, new Object[0]), "highpressure", false);
        this.registerAchievement("cheapermac", 6, 1, ItemList.Machine_LV_Hammer.get(1L, new Object[0]), "steel", false);
        this.registerAchievement("complexalloys", 6, 3, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.BlueSteel, 1L), "cheapermac", false);
        this.registerAchievement("magneticiron", 4, -2, GTOreDictUnificator.get(OrePrefixes.stick, Materials.IronMagnetic, 1L), "steel", false);
        this.registerAchievement("lvmotor", 4, -6, ItemList.Electric_Motor_LV.get(1L, new Object[0]), "magneticiron", false);
        this.registerAchievement("pumpcover", 2, -8, ItemList.Electric_Pump_LV.get(1L, new Object[0]), "lvmotor", false);
        this.registerAchievement("closeit", 2, -10, ItemList.Cover_Shutter.get(1L, new Object[0]), "pumpcover", false);
        this.registerAchievement("slurp", 2, -12, ItemList.Pump_HV.get(1L, new Object[0]), "closeit", false);
        this.registerAchievement("transport", 4, -10, ItemList.Conveyor_Module_LV.get(1L, new Object[0]), "lvmotor", false);
        this.registerAchievement("manipulation", 4, -12, ItemList.Cover_Controller.get(1L, new Object[0]), "transport", false);
        this.registerAchievement("buffer", 4, -14, ItemList.Automation_ChestBuffer_LV.get(1L, new Object[0]), "manipulation", false);
        this.registerAchievement("complexmachines", 6, -9, ItemList.Robot_Arm_LV.get(1L, new Object[0]), "lvmotor", false);
        this.registerAchievement("avengers", 8, -11, ItemList.Machine_LV_Assembler.get(1L, new Object[0]), "complexmachines", false);
        this.registerAchievement("filterregulate", 10, -11, ItemList.Component_Filter.get(1L, new Object[0]), "avengers", false);
        this.registerAchievement("steampower", 6, -6, ItemList.Generator_Steam_Turbine_LV.get(1L, new Object[0]), "lvmotor", false);
        this.registerAchievement("batterys", 6, -4, ItemList.Battery_Buffer_2by2_MV.get(1L, new Object[0]), "steampower", false);
        this.registerAchievement("badweather", 6, -8, ItemList.Casing_FireHazard.get(1L, new Object[0]), "steampower", false);
        this.registerAchievement("electricproblems", 7, -7, ItemList.Casing_ExplosionHazard.get(1L, new Object[0]), "steampower", false);
        this.registerAchievement("ebf", 8, -6, ItemList.Machine_Multi_BlastFurnace.get(1L, new Object[0]), "steampower", false);
        this.registerAchievement("energyhatch", 12, -6, ItemList.Hatch_Energy_LV.get(1L, new Object[0]), "ebf", false);
        this.registerAchievement("gtaluminium", 8, 0, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Aluminium, 1L), "steel", false);
        this.registerAchievement("highpowersmelt", 8, 2, ItemList.Machine_Multi_Furnace.get(1L, new Object[0]), "gtaluminium", false);
        this.registerAchievement("oilplant", 8, 4, ItemList.Distillation_Tower.get(1L, new Object[0]), "highpowersmelt", false);
        this.registerAchievement("factory", 8, 6, ItemList.Processing_Array.get(1L, new Object[0]), "oilplant", false);
        this.registerAchievement("upgradeebf", 8, -2, ItemList.Hatch_Energy_MV.get(1L, new Object[0]), "gtaluminium", false);
        this.registerAchievement("maintainance", 10, -2, ItemList.Hatch_Maintenance.get(1L, new Object[0]), "upgradeebf", false);
        this.registerAchievement("upgrade", 10, 0, ItemList.Casing_Coil_Kanthal.get(1L, new Object[0]), "gtaluminium", false);
        this.registerAchievement("titan", 14, 0, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Titanium, 1L), "upgrade", false);
        this.registerAchievement("magic", 14, 3, ItemList.MagicEnergyConverter_LV.get(1L, new Object[0]), "titan", false);
        this.registerAchievement("highmage", 10, 3, ItemList.MagicEnergyAbsorber_HV.get(1L, new Object[0]), "magic", false);
        this.registerAchievement("artificaldia", 12, 2, ItemList.IC2_Industrial_Diamond.get(1L, new Object[0]), "titan", false);
        this.registerAchievement("muchsteam", 13, 1, ItemList.LargeSteamTurbine.get(1L, new Object[0]), "titan", false);
        this.registerAchievement("efficientsteam", 11, 1, ItemList.LargeSteamTurbine.get(1L, new Object[0]), "muchsteam", false);
        this.registerAchievement("upgrade2", 16, 0, ItemList.Casing_Coil_Nichrome.get(1L, new Object[0]), "titan", false);
        this.registerAchievement("tungsten", 16, 2, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Tungsten, 1L), "upgrade2", false);
        this.registerAchievement("osmium", 16, -2, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Osmium, 1L), "upgrade2", false);
        this.registerAchievement("hightech", 15, -3, ItemList.Field_Generator_LV.get(1L, new Object[0]), "osmium", false);
        this.registerAchievement("amplifier", 16, -5, ItemList.Machine_LV_Amplifab.get(1L, new Object[0]), "hightech", false);
        this.registerAchievement("scanning", 13, -3, ItemList.Machine_HV_Scanner.get(1L, new Object[0]), "hightech", false);
        this.registerAchievement("alienpower", 14, -5, ItemList.Generator_Naquadah_Mark_I.get(1L, new Object[0]), "hightech", false);
        this.registerAchievement("universal", 15, -6, ItemList.Machine_LV_Massfab.get(1L, new Object[0]), "hightech", false);
        this.registerAchievement("replication", 17, -6, ItemList.Machine_LV_Replicator.get(1L, new Object[0]), "universal", false);
        this.registerAchievement("tungstensteel", 16, 4, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.TungstenSteel, 1L), "tungsten", false);
        this.registerAchievement("upgrade3", 15, 5, ItemList.Casing_Coil_TungstenSteel.get(1L, new Object[0]), "tungstensteel", false);
        this.registerAchievement("hssg", 13, 5, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.HSSG, 1L), "upgrade3", false);
        this.registerAchievement("upgrade4", 11, 5, ItemList.Casing_Coil_HSSG.get(1L, new Object[0]), "hssg", false);
        this.registerAchievement("stargatematerial", 11, 7, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Naquadah, 1L), "upgrade4", false);
        this.registerAchievement("conducting", 14, 6, ItemList.Casing_Coil_Superconductor.get(1L, new Object[0]), "upgrade3", false);
        this.registerAchievement("fusion", 15, 7, ItemList.FusionComputer_LuV.get(1L, new Object[0]), "tungstensteel", false);
        this.registerAchievement("higherefficency", 15, 9, ItemList.Generator_Plasma_EV.get(1L, new Object[0]), "fusion", false);
        this.registerAchievement("advancing", 13, 7, ItemList.FusionComputer_ZPMV.get(1L, new Object[0]), "fusion", false);
        this.registerAchievement("stargateliquid", 11, 9, ItemList.Generator_Plasma_IV.get(1L, new Object[0]), "advancing", false);
        this.registerAchievement("tothelimit", 13, 9, ItemList.Generator_Plasma_IV.get(1L, new Object[0]), "advancing", false);
        this.registerAchievement("fullefficiency", 12, 10, ItemList.Generator_Plasma_LuV.get(1L, new Object[0]), "tothelimit", false);
        this.registerAchievement("upgrade5", 9, 9, ItemList.Casing_Coil_Naquadah.get(1L, new Object[0]), "stargateliquid", false);
        this.registerAchievement("alienmetallurgy", 9, 7, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.NaquadahAlloy, 1L), "upgrade5", false);
        this.registerAchievement("over9000", 7, 7, ItemList.Casing_Coil_NaquadahAlloy.get(1L, new Object[0]), "alienmetallurgy", false);
        this.registerAchievement("finalpreparations", 7, 9, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Naquadria, 1L), "over9000", false);
        this.registerAchievement("denseaspossible", 6, 10, ItemList.FusionComputer_UV.get(1L, new Object[0]), "finalpreparations", false);
        this.registerAchievement("zpmage", 8, 10, ItemList.Energy_Module.get(1L, new Object[0]), "denseaspossible", false);
        this.registerAchievement("uvage", 10, 10, ItemList.Energy_Cluster.get(1L, new Object[0]), "zpmage", false);
        this.registerAchievement("whatnow", 12, 10, ItemList.ZPM2.get(1L, new Object[0]), "uvage", false);
        if (GTMod.gregtechproxy.mAchievements) {
            AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("GregTech 5", this.achievementList.values().toArray(new Achievement[0])));
            MinecraftForge.EVENT_BUS.register((Object)this);
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    public static void registerOre(Materials aMaterial, int min, int max, int chance, boolean overworld, boolean nether, boolean end) {
    }

    public Achievement registerAchievement(String textId, int x, int y, ItemStack icon, Achievement requirement, boolean special) {
        if (!GTMod.gregtechproxy.mAchievements) {
            return null;
        }
        Achievement achievement = new Achievement(textId, textId, this.adjX + x, this.adjY + y, icon, requirement);
        if (special) {
            achievement.func_75987_b();
        }
        achievement.func_75971_g();
        if (GTValues.D2) {
            GTLog.out.println("achievement." + textId + "=");
            GTLog.out.println("achievement." + textId + ".desc=");
        }
        this.achievementList.put(textId, achievement);
        return achievement;
    }

    public Achievement registerAchievement(String textId, int x, int y, ItemStack icon, String requirement, boolean special) {
        if (!GTMod.gregtechproxy.mAchievements) {
            return null;
        }
        Achievement achievement = new Achievement(textId, textId, this.adjX + x, this.adjY + y, icon, this.getAchievement(requirement));
        if (special) {
            achievement.func_75987_b();
        }
        achievement.func_75971_g();
        if (GTValues.D2) {
            GTLog.out.println("achievement." + textId + "=");
            GTLog.out.println("achievement." + textId + ".desc=");
        }
        this.achievementList.put(textId, achievement);
        return achievement;
    }

    public Achievement registerOreAchievement(Materials aMaterial) {
        return null;
    }

    public Achievement registerAssAchievement(GTRecipe recipe) {
        if (recipe == null) {
            GTMod.GT_FML_LOGGER.error("Invalid achievement registration attempt for null recipe", (Throwable)new Exception());
            return null;
        }
        if (recipe.getOutput(0) == null) {
            GTMod.GT_FML_LOGGER.error("Invalid achievement registration attempt for recipe with null output", (Throwable)new Exception());
            return null;
        }
        if (this.achievementList.get(recipe.getOutput(0).func_77977_a()) == null) {
            return this.registerAchievement(recipe.getOutput(0).func_77977_a(), -(11 + ++assReg % 5), assReg / 5 - 8, recipe.getOutput(0), AchievementList.field_76004_f, false);
        }
        return null;
    }

    public void issueAchievement(EntityPlayer entityplayer, String textId) {
        if (entityplayer == null || !GTMod.gregtechproxy.mAchievements) {
            return;
        }
        entityplayer.func_71029_a((StatBase)this.achievementList.get(textId));
    }

    public Achievement getAchievement(String textId) {
        if (this.achievementList.containsKey(textId)) {
            return this.achievementList.get(textId);
        }
        return null;
    }

    public void issueAchivementHatch(EntityPlayer player, ItemStack stack) {
        if (player == null || stack == null) {
            return;
        }
        ItemData data = GTOreDictUnificator.getItemData(stack);
        if (data != null && data.mPrefix == OrePrefixes.ingot) {
            if (data.mMaterial.mMaterial == Materials.Aluminium) {
                this.issueAchievement(player, "gtaluminium");
            } else if (data.mMaterial.mMaterial == Materials.Titanium) {
                this.issueAchievement(player, "titan");
            } else if (data.mMaterial.mMaterial == Materials.BlueSteel) {
                this.issueAchievement(player, "complexalloys");
            } else if (data.mMaterial.mMaterial == Materials.Tungsten) {
                this.issueAchievement(player, "tungsten");
            } else if (data.mMaterial.mMaterial == Materials.Osmium) {
                this.issueAchievement(player, "osmium");
            } else if (data.mMaterial.mMaterial == Materials.TungstenSteel) {
                this.issueAchievement(player, "tungstensteel");
            } else if (data.mMaterial.mMaterial == Materials.HSSG) {
                this.issueAchievement(player, "hssg");
            } else if (data.mMaterial.mMaterial == Materials.Naquadah) {
                this.issueAchievement(player, "stargatematerial");
            } else if (data.mMaterial.mMaterial == Materials.NaquadahAlloy) {
                this.issueAchievement(player, "alienmetallurgy");
            } else if (data.mMaterial.mMaterial == Materials.Naquadria) {
                this.issueAchievement(player, "finalpreparations");
            }
        }
        if (ItemList.IC2_Industrial_Diamond.isStackEqual(stack)) {
            this.issueAchievement(player, "artificaldia");
            this.issueAchievement(player, "buildCoalDiamond");
        }
    }

    public void issueAchivementHatchFluid(EntityPlayer player, FluidStack fluid) {
        if (player == null || fluid == null) {
            return;
        }
        switch (fluid.getFluid().getUnlocalizedName()) {
            case "fluid.plasma.helium": {
                this.issueAchievement(player, "fusion");
                break;
            }
            case "fluid.molten.europium": {
                this.issueAchievement(player, "advancing");
                break;
            }
            case "fluid.molten.naquadah": {
                this.issueAchievement(player, "stargateliquid");
                break;
            }
            case "fluid.molten.americium": {
                this.issueAchievement(player, "tothelimit");
                break;
            }
            case "fluid.molten.neutronium": {
                this.issueAchievement(player, "denseaspossible");
                break;
            }
            case "fluid.plasma.nitrogen": {
                this.issueAchievement(player, "higherefficency");
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        EntityPlayer player = event.player;
        ItemStack stack = event.crafting;
        if (player == null || stack == null) {
            return;
        }
        ItemData data = GTOreDictUnificator.getItemData(stack);
        if (data != null && data.mPrefix == OrePrefixes.dust && data.mMaterial.mMaterial == Materials.Bronze) {
            this.issueAchievement(player, "bronze");
        }
        switch (stack.func_77977_a()) {
            case "gt.metaitem.01.2300": {
                this.issueAchievement(player, "bronze");
                break;
            }
            case "gt.metaitem.01.32700": {
                this.issueAchievement(player, "smallparts");
                break;
            }
            case "gt.metaitem.01.32702": {
                this.issueAchievement(player, "bettercircuits");
                break;
            }
            case "gt.metaitem.01.23354": {
                this.issueAchievement(player, "magneticiron");
                break;
            }
            case "gt.metaitem.01.32600": {
                this.issueAchievement(player, "lvmotor");
                this.issueAchievement(player, "buildCable");
                break;
            }
            case "gt.metaitem.01.32610": {
                this.issueAchievement(player, "pumpcover");
                break;
            }
            case "gt.metaitem.01.32630": {
                this.issueAchievement(player, "transport");
                break;
            }
            case "gt.metaitem.01.32650": {
                this.issueAchievement(player, "complexmachines");
                break;
            }
            case "gt.metaitem.01.32670": {
                this.issueAchievement(player, "hightech");
                break;
            }
            case "ic2.blockCrop": {
                this.issueAchievement(player, "crops");
                break;
            }
            case "ic2.itemPartCircuit": {
                this.issueAchievement(player, "gtbasiccircuit");
                break;
            }
            case "ic2.itemPartCircuitAdv": {
                this.issueAchievement(player, "stepforward");
                break;
            }
            case "gt.blockmachines.boiler.solar": {
                this.issueAchievement(player, "simplyeco");
                break;
            }
            case "gt.blockmachines.boiler.bronze": {
                this.issueAchievement(player, "firststeam");
                break;
            }
            case "gt.blockmachines.boiler.steel": {
                this.issueAchievement(player, "highpressure");
                break;
            }
            case "gt.blockmachines.bronzemachine.macerator": {
                this.issueAchievement(player, "macerator");
                this.issueAchievement(player, "buildMacerator");
                break;
            }
            case "gt.blockmachines.bronzemachine.alloysmelter.tier.3": {
                this.issueAchievement(player, "buildIndFurnace");
                break;
            }
            case "gt.blockmachines.bronzemachine.alloysmelter": {
                this.issueAchievement(player, "alloysmelter");
                this.issueAchievement(player, "buildElecFurnace");
                break;
            }
            case "gt.blockmachines.bronzemachine.extractor": {
                this.issueAchievement(player, "extract");
                this.issueAchievement(player, "buildCompressor");
                this.issueAchievement(player, "buildExtractor");
                break;
            }
            case "gt.blockmachines.basicmachine.pump.tier.03": {
                this.issueAchievement(player, "slurp");
                break;
            }
            case "gt.blockmachines.multimachine.blastfurnace": {
                this.issueAchievement(player, "ebf");
                break;
            }
            case "gt.blockmachines.hatch.energy.tier.02": {
                this.issueAchievement(player, "upgradeebf");
                break;
            }
            case "gt.blockmachines.multimachine.multifurnace": {
                this.issueAchievement(player, "highpowersmelt");
                break;
            }
            case "gt.blockmachines.hatch.energy.tier.01": {
                this.issueAchievement(player, "energyhatch");
                break;
            }
            case "gt.blockmachines.multimachine.processingarray": {
                this.issueAchievement(player, "factory");
                break;
            }
            case "gt.blockmachines.basicgenerator.magicenergyconverter.tier.01": {
                this.issueAchievement(player, "magic");
                break;
            }
            case "gt.blockmachines.basicgenerator.magicenergyabsorber.tier.03": {
                this.issueAchievement(player, "highmage");
                break;
            }
            case "gt.blockmachines.basicgenerator.plasmagenerator.tier.07": {
                this.issueAchievement(player, "fullefficiency");
                break;
            }
            case "gt.blockmachines.multimachine.largeturbine": {
                this.issueAchievement(player, "muchsteam");
                break;
            }
            case "gt.blockmachines.multimachine.largehpturbine": {
                this.issueAchievement(player, "efficientsteam");
                break;
            }
            case "gt.blockmachines.multimachine.cleanroom": {
                this.issueAchievement(player, "gtcleanroom");
                break;
            }
            case "gt.neutronreflector": {
                this.issueAchievement(player, "reflect");
                break;
            }
            case "gt.blockcasings5.1": {
                this.issueAchievement(player, "upgrade");
                break;
            }
            case "gt.blockcasings5.2": {
                this.issueAchievement(player, "upgrade2");
                break;
            }
            case "gt.blockcasings5.3": {
                this.issueAchievement(player, "upgrade3");
                break;
            }
            case "gt.blockcasings5.4": {
                this.issueAchievement(player, "upgrade4");
                break;
            }
            case "gt.blockcasings5.5": {
                this.issueAchievement(player, "upgrade5");
                break;
            }
            case "gt.blockcasings5.6": {
                this.issueAchievement(player, "over9000");
                break;
            }
            case "gt.blockcasings.15": {
                this.issueAchievement(player, "conducting");
            }
        }
        if (!stack.func_77977_a().startsWith("gt.blockmachines.")) {
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicmachine.arcfurnace.tier.")) {
            this.issueAchievement(player, "recycling");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicmachine.disassembler.tier.")) {
            this.issueAchievement(player, "repair");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.automation.superbuffer.tier.")) {
            this.issueAchievement(player, "superbuffer");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.quantum.tank.tier.")) {
            this.issueAchievement(player, "whereistheocean");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.quantum.chest.tier.")) {
            this.issueAchievement(player, "newstorage");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicmachine.hammer.tier.")) {
            this.issueAchievement(player, "cheapermac");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.automation.chestbuffer.tier.")) {
            this.issueAchievement(player, "buffer");
            this.issueAchievement(player, "buildBatBox");
            if (stack.func_77977_a().startsWith("gt.blockmachines.automation.chestbuffer.tier.3")) {
                this.issueAchievement(player, "buildMFE");
            }
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicgenerator.steamturbine.tier.")) {
            this.issueAchievement(player, "steampower");
            this.issueAchievement(player, "buildGenerator");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicmachine.assembler.tier.")) {
            this.issueAchievement(player, "avengers");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.batterybuffer.")) {
            this.issueAchievement(player, "batterys");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicmachine.amplifab.tier.")) {
            this.issueAchievement(player, "amplifier");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicmachine.massfab.tier.")) {
            this.issueAchievement(player, "universal");
            this.issueAchievement(player, "buildMassFab");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicgenerator.naquadah.tier.")) {
            this.issueAchievement(player, "alienpower");
            return;
        }
        if (stack.func_77977_a().startsWith("gt.blockmachines.basicmachine.replicator.tier.")) {
            this.issueAchievement(player, "replication");
            return;
        }
    }

    @SubscribeEvent
    public void onSmelting(PlayerEvent.ItemSmeltedEvent event) {
        EntityPlayer player = event.player;
        ItemStack stack = event.smelting;
        if (player == null || stack == null) {
            return;
        }
        if (stack.func_77973_b() == Items.field_151025_P) {
            event.player.func_71029_a((StatBase)AchievementList.field_76014_m);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = event.item.func_92059_d();
        if (player == null || stack == null) {
            return;
        }
        ItemData data = GTOreDictUnificator.getItemData(stack);
        if (data != null && data.mPrefix != null) {
            if (data.mPrefix == OrePrefixes.dust) {
                if (data.mMaterial.mMaterial == Materials.Lutetium) {
                    this.issueAchievement(player, "newmetal");
                }
                if (data.mMaterial.mMaterial != Materials.Gunpowder) {
                    this.issueAchievement(player, "cleandust");
                }
            } else if (data.mPrefix.name().startsWith("ore")) {
                int data_getAllMaterialStacks_sS = data.getAllMaterialStacks().size();
                for (int i = 0; i < data_getAllMaterialStacks_sS; ++i) {
                    this.issueAchievement(player, data.getAllMaterialStacks().get((int)i).mMaterial.mName);
                    if (data.getAllMaterialStacks().get((int)i).mMaterial == Materials.AnyIron) {
                        this.issueAchievement(player, "iron");
                    }
                    if (data.getAllMaterialStacks().get((int)i).mMaterial != Materials.Copper && data.getAllMaterialStacks().get((int)i).mMaterial != Materials.Tin) continue;
                    this.issueAchievement(event.entityPlayer, "mineOre");
                }
            } else if (data.mPrefix == OrePrefixes.crushed) {
                this.issueAchievement(player, "crushed");
            } else if (data.mPrefix == OrePrefixes.crushedPurified) {
                this.issueAchievement(player, "washing");
            } else if (data.mPrefix == OrePrefixes.crushedCentrifuged) {
                this.issueAchievement(player, "spinit");
            } else if (data.mMaterial.mMaterial == Materials.Steel) {
                if (data.mPrefix == OrePrefixes.ingot && stack.field_77994_a == stack.func_77976_d()) {
                    this.issueAchievement(player, "steel");
                } else if (data.mPrefix == OrePrefixes.nugget && Mods.Thaumcraft.isModLoaded() && ThaumcraftApiHelper.isResearchComplete((String)player.getDisplayName(), (String)"GT_IRON_TO_STEEL")) {
                    this.issueAchievement(player, "steel");
                }
            }
        }
        switch (stack.func_77977_a()) {
            case "gt.metaitem.02.32500": {
                this.issueAchievement(player, "havestlead");
                break;
            }
            case "gt.metaitem.02.32501": {
                this.issueAchievement(player, "havestsilver");
                break;
            }
            case "gt.metaitem.02.32503": {
                this.issueAchievement(player, "havestiron");
                break;
            }
            case "gt.metaitem.02.32504": {
                this.issueAchievement(player, "havestgold");
                break;
            }
            case "gt.metaitem.02.32530": {
                this.issueAchievement(player, "havestcopper");
                break;
            }
            case "gt.metaitem.02.32540": {
                this.issueAchievement(player, "havesttin");
                break;
            }
            case "gt.metaitem.02.32510": {
                this.issueAchievement(player, "havestoil");
                break;
            }
            case "gt.metaitem.02.32511": {
                this.issueAchievement(player, "havestemeralds");
                break;
            }
            case "gt.metaitem.03.32082": {
                this.issueAchievement(player, "energyflow");
                break;
            }
            case "gt.metaitem.01.32702": {
                this.issueAchievement(player, "bettercircuits");
                break;
            }
            case "gt.metaitem.01.32707": {
                this.issueAchievement(player, "datasaving");
                break;
            }
            case "gt.metaitem.01.32597": {
                this.issueAchievement(player, "orbs");
                break;
            }
            case "gt.metaitem.01.32599": {
                this.issueAchievement(player, "thatspower");
                break;
            }
            case "gt.metaitem.01.32598": {
                this.issueAchievement(player, "luck");
                break;
            }
            case "gt.metaitem.01.32749": {
                this.issueAchievement(player, "closeit");
                break;
            }
            case "gt.metaitem.01.32730": {
                this.issueAchievement(player, "manipulation");
                break;
            }
            case "gt.metaitem.01.32729": {
                this.issueAchievement(player, "filterregulate");
                break;
            }
            case "gt.metaitem.01.32605": {
                this.issueAchievement(player, "whatnow");
                break;
            }
            case "gt.metaitem.01.32736": {
                this.issueAchievement(player, "zpmage");
                break;
            }
            case "gt.metaitem.01.32737": {
                this.issueAchievement(player, "uvage");
                break;
            }
            case "gt.metaitem.03.32030": {
                this.issueAchievement(player, "gtmonosilicon");
                break;
            }
            case "gt.metaitem.03.32036": {
                this.issueAchievement(player, "gtlogicwafer");
                break;
            }
            case "gt.metaitem.01.32701": {
                this.issueAchievement(player, "gtlogiccircuit");
                break;
            }
            case "gt.metaitem.03.32085": {
                this.issueAchievement(player, "gtquantumprocessor");
                break;
            }
            case "gt.metaitem.03.32089": {
                this.issueAchievement(player, "gtcrystalprocessor");
                break;
            }
            case "gt.metaitem.03.32092": {
                this.issueAchievement(player, "gtwetware");
                break;
            }
            case "gt.metaitem.03.32095": {
                this.issueAchievement(player, "gtwetmain");
                break;
            }
            case "gt.Thoriumcell": {
                this.issueAchievement(player, "newfuel");
                break;
            }
            case "ic2.itemPartCircuitAdv": {
                this.issueAchievement(player, "stepforward");
                break;
            }
            case "gt.blockcasings5.1": {
                this.issueAchievement(player, "upgrade");
                break;
            }
            case "gt.blockcasings5.2": {
                this.issueAchievement(player, "upgrade2");
                break;
            }
            case "gt.blockcasings5.3": {
                this.issueAchievement(player, "upgrade3");
                break;
            }
            case "gt.blockcasings5.4": {
                this.issueAchievement(player, "upgrade4");
                break;
            }
            case "gt.blockcasings5.5": {
                this.issueAchievement(player, "upgrade5");
                break;
            }
            case "gt.blockcasings5.6": {
                this.issueAchievement(player, "over9000");
                break;
            }
            case "gt.blockcasings.15": {
                this.issueAchievement(player, "conducting");
                break;
            }
            case "gt.metaitem.01.32761": {
                if (!player.field_71075_bZ.field_75098_d) break;
                for (GTRecipe recipe : RecipeMaps.assemblylineVisualRecipes.getAllRecipes()) {
                    this.issueAchievement(player, recipe.getOutput(0).func_77977_a());
                    recipe.mHidden = false;
                }
                break;
            }
        }
        if (stack.func_77973_b() == Ic2Items.quantumBodyarmor.func_77973_b() || stack.func_77973_b() == Ic2Items.quantumBoots.func_77973_b() || stack.func_77973_b() == Ic2Items.quantumHelmet.func_77973_b() || stack.func_77973_b() == Ic2Items.quantumLeggings.func_77973_b()) {
            this.issueAchievement(player, "buildQArmor");
        }
        for (GTRecipe recipe : RecipeMaps.assemblylineVisualRecipes.getAllRecipes()) {
            if (!recipe.getOutput(0).func_77977_a().equals(stack.func_77977_a())) continue;
            this.issueAchievement(player, recipe.getOutput(0).func_77977_a());
            recipe.mHidden = false;
        }
    }
}

