/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.steam;

import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverSteamValve;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.misc.teams.GTTeam;
import gregtech.common.misc.teams.GTTeamManager;
import gregtech.common.misc.teams.PipelessSteamManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTESteamPipelessHatchOutput
extends MTEHatchOutput
implements IFluidStore {
    private GTTeam ownerTeam;

    public MTESteamPipelessHatchOutput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTESteamPipelessHatchOutput(String aName, int aTier, ITexture[][][] aTextures) {
        super(aName, aTier, 4, new String[]{""}, aTextures);
    }

    @Override
    public String[] getDescription() {
        if (this.mTier == 0) {
            return new String[]{EnumChatFormatting.GRAY + "Stores Steam globally in a network, up to 2^(2^31) L.", EnumChatFormatting.GRAY + "Does not connect to Pipes. This block accepts Steam into the network.", EnumChatFormatting.GRAY + "Supports Steam, Superheated Steam, and Supercritical Steam (and their dense variants).", EnumChatFormatting.GRAY + "Capacity: " + GTUtility.formatNumbers(this.getCapacity()) + "L", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "In a dream, you remember something named a 'Wireless Energy Dynamo,' or something like", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "that. You don't remember what it did, but the similarities here are clear. However, you", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "remember laughing at their uselessness. Hard to imagine that reality, when these are so useful..."};
        }
        return new String[]{EnumChatFormatting.GRAY + "Stores Steam globally in a network, up to 2^(2^31) L.", EnumChatFormatting.GRAY + "Does not connect to Pipes. This block accepts Steam into the network.", EnumChatFormatting.GRAY + "Supports Steam, Superheated Steam, and Supercritical Steam (and their dense variants).", EnumChatFormatting.GRAY + "Capacity: " + GTUtility.formatNumbers(this.getCapacity()) + "L", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "You've heard whispers of a mechanism called the 'Steamgate.' In your research, you're still unsure of", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "what this means or what all it will entail to produce something so elusive and monumental. However one", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "thing's for sure, you'll need a lot of steam to get there, and this vent is a key part of the puzzle..."};
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (aTick % WirelessNetworkManager.ticks_between_energy_addition == 0L) {
            this.tryPushingSteam();
        }
    }

    private PipelessSteamManager getSteamManager() {
        if (this.ownerTeam == null) {
            IGregTechTileEntity te = this.getBaseMetaTileEntity();
            this.ownerTeam = GTTeamManager.getTeam(te.getOwnerName(), te.getOwnerUuid());
        }
        return GTTeamManager.getSteamData(this.ownerTeam);
    }

    private void tryPushingSteam() {
        if (this.mFluid == null || this.mFluid.amount == 0) {
            return;
        }
        PipelessSteamManager manager = this.getSteamManager();
        if (GTModHandler.isAnySteam(this.mFluid)) {
            manager.fillSteam(this.mFluid.amount);
            this.drain(Integer.MAX_VALUE, true);
        } else if (this.mFluid.getFluid() == Materials.DenseSteam.mGas) {
            manager.fillDenseSteam(this.mFluid.amount);
            this.drain(Integer.MAX_VALUE, true);
        } else if (GTModHandler.isSuperHeatedSteam(this.mFluid)) {
            manager.fillSuperheatedSteam(this.mFluid.amount);
            this.drain(Integer.MAX_VALUE, true);
        } else if (this.mFluid.getFluid() == Materials.DenseSuperheatedSteam.mGas) {
            manager.fillDenseSuperheatedSteam(this.mFluid.amount);
            this.drain(Integer.MAX_VALUE, true);
        } else if (this.mFluid.getFluid().getName().equals("supercriticalsteam")) {
            manager.fillSupercriticalSteam(this.mFluid.amount);
            this.drain(Integer.MAX_VALUE, true);
        } else if (this.mFluid.getFluid() == Materials.DenseSupercriticalSteam.mGas) {
            manager.fillDenseSupercriticalSteam(this.mFluid.amount);
            this.drain(Integer.MAX_VALUE, true);
        }
    }

    @Override
    public boolean isEmptyAndAcceptsAnyFluid() {
        return this.getFluidAmount() == 0;
    }

    @Override
    public int getCapacity() {
        if (this.mTier == 0) {
            return 64000 * (int)WirelessNetworkManager.ticks_between_energy_addition;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean canStoreFluid(@NotNull FluidStack fluidStack) {
        if (this.mFluid != null && !GTUtility.areFluidsEqual(this.mFluid, fluidStack)) {
            return false;
        }
        return CoverSteamValve.isFluidCompatible(fluidStack);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_WIRELESS_ON[0]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_WIRELESS_ON[0]};
    }

    @Override
    protected ITexture getBaseTexture(int colorIndex) {
        if (this.mTier == 0) {
            return TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZE_SIDE);
        }
        return TextureFactory.of(Textures.BlockIcons.MACHINE_STEEL_SIDE);
    }

    @Override
    public boolean hasFluidLocking() {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamPipelessHatchOutput(this.mName, this.mTier, this.mTextures);
    }

    @Override
    protected boolean supportsFluidPushing() {
        return false;
    }

    @Override
    public String[] getInfoData() {
        String name = this.mTier == 0 ? "Pipeless Steam Vent" : "Pipeless Jetstream Vent";
        return new String[]{EnumChatFormatting.BLUE + name + EnumChatFormatting.RESET, "Stored Fluid:", EnumChatFormatting.GOLD + (this.mFluid == null ? "No Fluid" : this.mFluid.getLocalizedName()) + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mFluid == null ? 0L : (long)this.mFluid.amount) + " L" + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getCapacity()) + " L" + EnumChatFormatting.RESET};
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
    }
}

